/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.installer;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.oomph.console.Activator;
import org.eclipse.oomph.console.configuration.NotFoundException;
import org.eclipse.oomph.console.configuration.ProductVersionSelector;
import org.eclipse.oomph.console.core.p2.AcceptCacheUsageConfirmer;
import org.eclipse.oomph.console.core.p2.P2ServiceUI;
import org.eclipse.oomph.console.core.parameters.Parameters;
import org.eclipse.oomph.console.core.util.InstallationInitializer;
import org.eclipse.oomph.console.core.util.LaunchUtil;
import org.eclipse.oomph.console.core.util.NonStrictSSL;
import org.eclipse.oomph.console.core.util.ScopeAdjuster;
import org.eclipse.oomph.console.installer.ConsoleProgressLog;
import org.eclipse.oomph.console.installer.ConsoleProgressMonitor;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.setup.CertificatePolicy;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.UnsignedPolicy;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.UserCallback;
import org.osgi.framework.BundleContext;

public class ConsoleInstaller {
    private SetupContext context;
    private ResourceSet resourceSet;
    private final String product;
    private final String version;
    private final String project;
    private final String redirection;
    private final String location;
    private final String folder;
    private final String workspace;
    private final boolean launch;
    private final boolean verbose;

    public ConsoleInstaller(String product) {
        this.product = product.contains(":") ? product.split(":")[0] : product;
        this.version = product.contains(":") ? product.split(":")[1] : Parameters.VERSION;
        this.project = Parameters.PROJECT.replaceAll("\\s+", "");
        this.redirection = Parameters.REDIRECTION;
        this.location = Parameters.INSTALLATION_LOCATION;
        this.folder = Parameters.INSTALLATION_PRODUCT_FOLDER;
        this.workspace = Parameters.WORKSPACE_LOCATION;
        this.launch = Parameters.LAUNCH_AUTOMATICALLY;
        this.verbose = Parameters.VERBOSE;
        if (Parameters.SSL_INSECURE) {
            this.disableSSLVerification();
        }
    }

    public void run() throws Exception {
        this.init(this.product, this.version, this.project);
        URIConverter uriConverter = this.resourceSet.getURIConverter();
        String overrideRedirection = System.getProperty(this.redirection);
        if (overrideRedirection != null) {
            String[] mapping = overrideRedirection.split("->", 2);
            URI sourceURI = URI.createURI((String)mapping[0]);
            URI targetURI = URI.createURI((String)mapping[1].replace("\\", "/"));
            uriConverter.getURIMap().put(sourceURI, targetURI);
        }
        SetupPrompter prompter = new SetupPrompter(){

            public UserCallback getUserCallback() {
                return null;
            }

            public String getValue(VariableTask variable) {
                return System.getProperty(variable.getName());
            }

            public OS getOS() {
                return OS.INSTANCE;
            }

            public boolean promptVariables(List<? extends SetupTaskContext> performers) {
                for (SetupTaskContext setupTaskContext : performers) {
                    SetupTaskPerformer promptedPerformer = (SetupTaskPerformer)setupTaskContext;
                    List unresolvedVariables = promptedPerformer.getUnresolvedVariables();
                    int i = 0;
                    while (i <= unresolvedVariables.size() - 1) {
                        VariableTask variable = (VariableTask)unresolvedVariables.get(i);
                        String value = System.getProperty(variable.getName(), variable.getValue());
                        if (value == null) {
                            value = variable.getDefaultValue();
                        }
                        if (value == null && !variable.getChoices().isEmpty()) {
                            value = ((VariableChoice)variable.getChoices().get(0)).getValue();
                        }
                        if (value != null) {
                            variable.setValue(value);
                        }
                        ++i;
                    }
                }
                return true;
            }

            public String getVMPath() {
                return null;
            }
        };
        ScopeAdjuster adjuster = new ScopeAdjuster();
        adjuster.setWorkspaceLacation(this.context.getUser(), this.workspace);
        adjuster.setInstallationLocation(this.context.getUser(), this.location);
        adjuster.setProductFolderName(this.context.getUser(), this.folder);
        adjuster.setProductFolderName(this.context.getInstallation().getProductVersion(), this.folder);
        Trigger trigger = Trigger.getByName((String)Parameters.TRIGGER);
        SetupTaskPerformer performer = SetupTaskPerformer.create((URIConverter)uriConverter, (SetupPrompter)prompter, (Trigger)trigger, (SetupContext)this.context, (boolean)false);
        performer.recordVariables(this.context.getInstallation(), this.context.getWorkspace(), this.context.getUser());
        if (Parameters.CLEAN_UNRESOLVED) {
            performer.getUnresolvedVariables().clear();
        }
        performer.put(UIServices.class, (Object)P2ServiceUI.SERVICE_UI);
        performer.put(CacheUsageConfirmer.class, (Object)new AcceptCacheUsageConfirmer());
        performer.put(ILicense.class, (Object)Confirmer.ACCEPT);
        performer.put(Certificate.class, (Object)Confirmer.ACCEPT);
        performer.setProgress((ProgressLog)new ConsoleProgressLog(Parameters.TEXT_LAYOUT));
        performer.setOffline(Parameters.SETUP_OFFLINE);
        performer.setMirrors(Parameters.SETUP_MIRRORS);
        performer.setSkipConfirmation(true);
        File installationLocation = performer.getInstallationLocation();
        if (this.launch && installationLocation.exists()) {
            try {
                LaunchUtil.launchProduct((SetupTaskPerformer)performer, (boolean)false);
                return;
            }
            catch (IOException | NullPointerException e) {
                System.out.println("Old installation did probably not finish correctly...");
                System.out.println("Reinstalling");
            }
        }
        performer.perform((IProgressMonitor)new ConsoleProgressMonitor(this.verbose, this.getHeaderText(this.context)));
        this.saveResources(performer);
        if (this.launch) {
            LaunchUtil.launchProduct((SetupTaskPerformer)performer, (boolean)true);
        }
    }

    private void saveResources(SetupTaskPerformer performer) throws IOException {
        Resource workspaceResource;
        Installation installation = performer.getInstallation();
        Resource installationResource = installation.eResource();
        Objects.requireNonNull(installationResource, "installationResource is null");
        installationResource.setURI(URI.createFileURI((String)new File(performer.getProductConfigurationLocation(), "org.eclipse.oomph.setup/installation.setup").toString()));
        Workspace workspace = performer.getWorkspace();
        Resource resource = workspaceResource = workspace != null ? workspace.eResource() : null;
        if (workspaceResource != null) {
            workspaceResource.setURI(URI.createFileURI((String)new File(performer.getWorkspaceLocation(), ".metadata/.plugins/org.eclipse.oomph.setup/workspace.setup").toString()));
        }
        performer.savePasswords();
        if (performer.getProductConfigurationLocation() != null) {
            installationResource.save(Collections.emptyMap());
        }
        if (workspaceResource != null && performer.getWorkspaceLocation() != null) {
            workspaceResource.save(Collections.emptyMap());
        }
    }

    private void init(String productId, String versionId, String projectId) throws NotFoundException {
        InstallationInitializer installationHelper = new InstallationInitializer();
        this.resourceSet = installationHelper.getResourceSet();
        this.initInstallation(productId, versionId, projectId);
    }

    private void initInstallation(String productId, String versionId, String projectId) throws NotFoundException {
        ProductVersionSelector selector = new ProductVersionSelector(this.resourceSet);
        ProductVersion version = null;
        Installation installation = null;
        LinkedList<Stream> streams = new LinkedList<Stream>();
        Configuration configuration = selector.selectConfiguration();
        if (configuration != null) {
            Workspace workspace;
            version = configuration.getInstallation().getProductVersion();
            if (version != null) {
                this.context = SetupContext.create((ResourceSet)this.resourceSet, (ProductVersion)version);
                installation = this.context.getInstallation();
                installation.getSetupTasks().addAll((Collection)configuration.getInstallation().getSetupTasks());
            }
            if ((workspace = configuration.getWorkspace()) != null) {
                streams.addAll((Collection<Stream>)workspace.getStreams());
            }
        }
        if (version == null) {
            Product product = selector.selectProduct(productId);
            version = selector.selectProductVersion(product, versionId);
            this.context = SetupContext.create((ResourceSet)this.resourceSet, (ProductVersion)version);
            installation = this.context.getInstallation();
        }
        installation.setProductVersion(version);
        if (!projectId.isEmpty()) {
            streams.addAll(selector.selectProjectStreams(Arrays.asList(projectId.split(","))));
        }
        User user = this.context.getUser();
        user.setUnsignedPolicy(UnsignedPolicy.ACCEPT);
        user.setCertificatePolicy(CertificatePolicy.ACCEPT);
        this.context = SetupContext.create((Installation)installation, streams, (User)user);
    }

    private void disableSSLVerification() {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        bundleContext.registerService(SSLSocketFactory.class.getName(), (Object)NonStrictSSL.getSSLSocketFactory(), null);
        bundleContext.registerService(HostnameVerifier.class.getName(), (Object)NonStrictSSL.getHostnameVerifier(), null);
    }

    private String getHeaderText(SetupContext context) {
        String versionTasks = this.getChilds((List<SetupTask>)context.getInstallation().getProductVersion().getSetupTasks(), new LinkedList<SetupTask>()).stream().filter(t -> t instanceof P2Task || t instanceof CompoundTask).map(t -> t instanceof P2Task ? ((P2Task)t).getLabel() : ((CompoundTask)t).getName()).collect(Collectors.joining(" + "));
        String tasks = this.getChilds((List<SetupTask>)context.getInstallation().getSetupTasks(), new LinkedList<SetupTask>()).stream().filter(t -> t instanceof P2Task || t instanceof CompoundTask).map(t -> t instanceof P2Task ? ((P2Task)t).getLabel() : ((CompoundTask)t).getName()).collect(Collectors.joining(" + "));
        String streams = context.getWorkspace().getStreams().stream().map(s -> s.getProject().getName() != null ? s.getProject().getName() : s.getProject().getLabel()).collect(Collectors.joining(" + "));
        return "Performing P2 Director (" + versionTasks + (String)(!tasks.isEmpty() ? " + " + tasks : "") + (String)(!streams.isEmpty() ? " + " + streams : "") + ")";
    }

    private List<SetupTask> getChilds(List<SetupTask> src, List<SetupTask> dst) {
        for (SetupTask t : src) {
            if (t instanceof CompoundTask) {
                this.getChilds((List<SetupTask>)((CompoundTask)t).getSetupTasks(), dst);
                continue;
            }
            dst.add(t);
        }
        return dst;
    }
}

