/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.console.configuration;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.console.configuration.NotFoundException;
import org.eclipse.oomph.console.core.parameters.Parameters;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.util.StringUtil;

public class ProductVersionSelector {
    private final ResourceSet resourceSet;

    public ProductVersionSelector(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public Product selectProduct(String productId) throws NotFoundException {
        List products = this.filter(SetupPackage.Literals.PRODUCT);
        Optional<Product> selectedProduct = products.stream().filter((? super T a) -> productId.equals(a.getName())).findFirst();
        if (selectedProduct.isPresent()) {
            return selectedProduct.get();
        }
        throw new NotFoundException("Cannot find the product called: " + productId + System.lineSeparator() + "The available product(s) are: " + products.stream().map(Scope::getName).distinct().collect(Collectors.joining(", ")));
    }

    public List<Stream> selectStreams(List<String> streamsList) throws NotFoundException {
        List streams = this.filter(SetupPackage.Literals.STREAM);
        List<Stream> result = streams.stream().distinct().filter((? super T a) -> streamsList.contains(a.getName())).collect(Collectors.toList());
        if (!result.isEmpty() && !streamsList.isEmpty()) {
            return result;
        }
        throw new NotFoundException("Cannot find the streams: " + streamsList.toString() + System.lineSeparator() + "The available stream(s) are: " + streams.stream().map(Scope::getName).distinct().collect(Collectors.joining(", ")));
    }

    public Project selectProject(String projectId) throws NotFoundException {
        List projects = this.filter(SetupPackage.Literals.PROJECT);
        Optional<Project> selectedProject = projects.stream().filter((? super T a) -> projectId.equals(a.getName())).findFirst();
        if (selectedProject.isPresent()) {
            return selectedProject.get();
        }
        throw new NotFoundException("Cannot find the project called: " + projectId + System.lineSeparator() + "The available project(s) are: " + projects.stream().map(Scope::getName).distinct().collect(Collectors.joining(", ")));
    }

    public List<Stream> selectProjectStreams(List<String> projectsList) throws NotFoundException {
        LinkedList<Stream> result = new LinkedList<Stream>();
        for (String id : projectsList) {
            String[] ids = id.contains(":") ? id.split(":", 2) : new String[]{};
            String projectName = ids.length > 0 ? ids[0] : System.getProperty("oomph.project.id." + id, id);
            String projectStream = ids.length > 0 ? ids[1] : System.getProperty("oomph.project.stream." + id, Parameters.STREAM);
            Project project = this.selectProject(projectName);
            EList streams = project.getStreams();
            List filtered = streams.stream().distinct().filter((? super T a) -> projectStream.equals(a.getName())).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                throw new NotFoundException("Cannot find in project " + projectName + " the stream called: " + projectStream + System.lineSeparator() + "The available project stream(s) are: " + streams.stream().map(Scope::getName).distinct().collect(Collectors.joining(", ")));
            }
            result.addAll(filtered);
        }
        return result;
    }

    public ProductVersion select(Product product, String versionId) throws NotFoundException {
        Optional<ProductVersion> version = product.getVersions().stream().filter((? super T a) -> versionId.equals(a.getName())).findFirst();
        if (version.isPresent()) {
            return version.get();
        }
        throw new NotFoundException("Cannot find in product " + product.getName() + " the version called: " + versionId + System.lineSeparator() + "The available product version(s) are: " + product.getVersions().stream().map(Scope::getName).distinct().collect(Collectors.joining(", ")));
    }

    public ProductVersion selectProductVersion(Product product, String versionId) throws NotFoundException {
        return this.select(product, versionId);
    }

    public Configuration selectConfiguration() throws NotFoundException {
        if (StringUtil.isEmpty((String)Parameters.CONFIGURATION)) {
            return null;
        }
        URI uri = this.resourceSet.getURIConverter().normalize(URI.createURI((String)Parameters.CONFIGURATION));
        Resource resource = this.resourceSet.createResource(uri);
        try {
            resource.load(this.resourceSet.getLoadOptions());
        }
        catch (IOException e) {
            throw new NotFoundException(e);
        }
        return (Configuration)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.CONFIGURATION);
    }

    private <E> List<E> filter(EClass eClass) {
        LinkedList<Notifier> result = new LinkedList<Notifier>();
        TreeIterator iterator = EcoreUtil.getAllContents((ResourceSet)this.resourceSet, (boolean)true);
        while (iterator.hasNext()) {
            Notifier curr = (Notifier)iterator.next();
            if (!eClass.isInstance((Object)curr)) continue;
            result.add(curr);
        }
        return result;
    }
}

