/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test.matchers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.util.AssertionErrors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b<\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\nJ\u0006\u0010#\u001a\u00020\nJ\u0006\u0010$\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\nJ\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020\nJ\u0006\u0010)\u001a\u00020\nJ\u0006\u0010*\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\nJ\u0006\u0010,\u001a\u00020\nJ\u0006\u0010-\u001a\u00020\nJ\u0006\u0010.\u001a\u00020\nJ\u0006\u0010/\u001a\u00020\nJ\u0006\u00100\u001a\u00020\nJ\u0006\u00101\u001a\u00020\nJ\u0006\u00102\u001a\u00020\nJ\u0006\u00103\u001a\u00020\nJ\u0006\u00104\u001a\u00020\nJ\u0006\u00105\u001a\u00020\nJ\u0006\u00106\u001a\u00020\nJ\u0006\u00107\u001a\u00020\nJ\u0006\u00108\u001a\u00020\nJ\u0006\u00109\u001a\u00020\nJ\u0006\u0010:\u001a\u00020\nJ\u0006\u0010;\u001a\u00020\nJ\u0006\u0010<\u001a\u00020\nJ\u0006\u0010=\u001a\u00020\nJ\u0006\u0010>\u001a\u00020\nJ\u0006\u0010?\u001a\u00020\nJ\u0006\u0010@\u001a\u00020\nJ\u0006\u0010A\u001a\u00020\nJ\u0006\u0010B\u001a\u00020\nJ\u0006\u0010C\u001a\u00020\nJ\u0006\u0010D\u001a\u00020\nJ\u0006\u0010E\u001a\u00020\nJ\u0006\u0010F\u001a\u00020\nJ\u0006\u0010G\u001a\u00020\nJ\u0006\u0010H\u001a\u00020\nJ\u0006\u0010I\u001a\u00020\nJ\u0006\u0010J\u001a\u00020\nJ\u0006\u0010K\u001a\u00020\nJ\u0006\u0010L\u001a\u00020\nJ\u0006\u0010M\u001a\u00020\nJ\u0006\u0010N\u001a\u00020\nJ\u0006\u0010O\u001a\u00020\nJ\u0006\u0010P\u001a\u00020\nJ\u0006\u0010Q\u001a\u00020\nJ\u0006\u0010R\u001a\u00020\nJ\u0006\u0010S\u001a\u00020\nJ\u0006\u0010T\u001a\u00020\nJ\u0006\u0010U\u001a\u00020\nJ\u000e\u0010V\u001a\u00020\n2\u0006\u0010V\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lio/kjson/spring/test/matchers/JSONStatusResultMatchersDSL;", "", "response", "Lorg/springframework/mock/web/MockHttpServletResponse;", "(Lorg/springframework/mock/web/MockHttpServletResponse;)V", "findStatus", "", "code", "", "is1xxInformational", "", "is2xxSuccessful", "is3xxRedirection", "is4xxClientError", "is5xxServerError", "isAccepted", "isAlreadyReported", "isBadGateway", "isBadRequest", "isBandwidthLimitExceeded", "isCheckpoint", "isConflict", "isContinue", "isCreated", "isDestinationLocked", "isEqualTo", "expected", "Lorg/springframework/http/HttpStatus;", "isExpectationFailed", "isFailedDependency", "isForbidden", "isFound", "isGatewayTimeout", "isGone", "isHttpVersionNotSupported", "isIAmATeapot", "isImUsed", "isInsufficientSpaceOnResource", "isInsufficientStorage", "isInternalServerError", "isLengthRequired", "isLocked", "isLoopDetected", "isMethodFailure", "isMethodNotAllowed", "isMovedPermanently", "isMovedTemporarily", "isMultiStatus", "isMultipleChoices", "isNetworkAuthenticationRequired", "isNoContent", "isNonAuthoritativeInformation", "isNotAcceptable", "isNotExtended", "isNotFound", "isNotImplemented", "isNotModified", "isOk", "isPartialContent", "isPayloadTooLarge", "isPaymentRequired", "isPermanentRedirect", "isPreconditionFailed", "isPreconditionRequired", "isProcessing", "isProxyAuthenticationRequired", "isRequestEntityTooLarge", "isRequestHeaderFieldsTooLarge", "isRequestTimeout", "isRequestUriTooLong", "isRequestedRangeNotSatisfiable", "isResetContent", "isSeeOther", "isServiceUnavailable", "isSwitchingProtocols", "isTemporaryRedirect", "isTooEarly", "isTooManyRequests", "isUnauthorized", "isUnavailableForLegalReasons", "isUnprocessableEntity", "isUnsupportedMediaType", "isUpgradeRequired", "isUriTooLong", "isUseProxy", "isVariantAlsoNegotiates", "reason", "kjson-spring3-test"})
public final class JSONStatusResultMatchersDSL {
    @NotNull
    private final MockHttpServletResponse response;

    public JSONStatusResultMatchersDSL(@NotNull MockHttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.response = response;
    }

    public final void is1xxInformational() {
        int it = this.response.getStatus();
        boolean bl = false;
        if (!(100 <= it ? it < 200 : false)) {
            AssertionErrors.fail((String)"Status", (Object)"1xx INFORMATIONAL", (Object)this.findStatus(it));
        }
    }

    public final void is2xxSuccessful() {
        int it = this.response.getStatus();
        boolean bl = false;
        if (!(200 <= it ? it < 300 : false)) {
            AssertionErrors.fail((String)"Status", (Object)"2xx SUCCESSFUL", (Object)this.findStatus(it));
        }
    }

    public final void is3xxRedirection() {
        int it = this.response.getStatus();
        boolean bl = false;
        if (!(300 <= it ? it < 400 : false)) {
            AssertionErrors.fail((String)"Status", (Object)"3xx REDIRECTION", (Object)this.findStatus(it));
        }
    }

    public final void is4xxClientError() {
        int it = this.response.getStatus();
        boolean bl = false;
        if (!(400 <= it ? it < 500 : false)) {
            AssertionErrors.fail((String)"Status", (Object)"4xx CLIENT ERROR", (Object)this.findStatus(it));
        }
    }

    public final void is5xxServerError() {
        int it = this.response.getStatus();
        boolean bl = false;
        if (!(500 <= it ? it < 600 : false)) {
            AssertionErrors.fail((String)"Status", (Object)"5xx SERVER ERROR", (Object)this.findStatus(it));
        }
    }

    public final void reason(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        String it = this.response.getErrorMessage();
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it, (Object)reason)) {
            AssertionErrors.fail((String)"Response status reason", (Object)reason, (Object)it);
        }
    }

    public final void isContinue() {
        this.isEqualTo(HttpStatus.CONTINUE);
    }

    public final void isSwitchingProtocols() {
        this.isEqualTo(HttpStatus.SWITCHING_PROTOCOLS);
    }

    public final void isProcessing() {
        this.isEqualTo(HttpStatus.PROCESSING);
    }

    public final void isCheckpoint() {
        this.isEqualTo(HttpStatus.CHECKPOINT);
    }

    public final void isOk() {
        this.isEqualTo(HttpStatus.OK);
    }

    public final void isCreated() {
        this.isEqualTo(HttpStatus.CREATED);
    }

    public final void isAccepted() {
        this.isEqualTo(HttpStatus.ACCEPTED);
    }

    public final void isNonAuthoritativeInformation() {
        this.isEqualTo(HttpStatus.NON_AUTHORITATIVE_INFORMATION);
    }

    public final void isNoContent() {
        this.isEqualTo(HttpStatus.NO_CONTENT);
    }

    public final void isResetContent() {
        this.isEqualTo(HttpStatus.RESET_CONTENT);
    }

    public final void isPartialContent() {
        this.isEqualTo(HttpStatus.PARTIAL_CONTENT);
    }

    public final void isMultiStatus() {
        this.isEqualTo(HttpStatus.MULTI_STATUS);
    }

    public final void isAlreadyReported() {
        this.isEqualTo(HttpStatus.ALREADY_REPORTED);
    }

    public final void isImUsed() {
        this.isEqualTo(HttpStatus.IM_USED);
    }

    public final void isMultipleChoices() {
        this.isEqualTo(HttpStatus.MULTIPLE_CHOICES);
    }

    public final void isMovedPermanently() {
        this.isEqualTo(HttpStatus.MOVED_PERMANENTLY);
    }

    public final void isFound() {
        this.isEqualTo(HttpStatus.FOUND);
    }

    public final void isMovedTemporarily() {
        this.isEqualTo(HttpStatus.MOVED_TEMPORARILY);
    }

    public final void isSeeOther() {
        this.isEqualTo(HttpStatus.SEE_OTHER);
    }

    public final void isNotModified() {
        this.isEqualTo(HttpStatus.NOT_MODIFIED);
    }

    public final void isUseProxy() {
        this.isEqualTo(HttpStatus.USE_PROXY);
    }

    public final void isTemporaryRedirect() {
        this.isEqualTo(HttpStatus.TEMPORARY_REDIRECT);
    }

    public final void isPermanentRedirect() {
        this.isEqualTo(HttpStatus.PERMANENT_REDIRECT);
    }

    public final void isBadRequest() {
        this.isEqualTo(HttpStatus.BAD_REQUEST);
    }

    public final void isUnauthorized() {
        this.isEqualTo(HttpStatus.UNAUTHORIZED);
    }

    public final void isPaymentRequired() {
        this.isEqualTo(HttpStatus.PAYMENT_REQUIRED);
    }

    public final void isForbidden() {
        this.isEqualTo(HttpStatus.FORBIDDEN);
    }

    public final void isNotFound() {
        this.isEqualTo(HttpStatus.NOT_FOUND);
    }

    public final void isMethodNotAllowed() {
        this.isEqualTo(HttpStatus.METHOD_NOT_ALLOWED);
    }

    public final void isNotAcceptable() {
        this.isEqualTo(HttpStatus.NOT_ACCEPTABLE);
    }

    public final void isProxyAuthenticationRequired() {
        this.isEqualTo(HttpStatus.PROXY_AUTHENTICATION_REQUIRED);
    }

    public final void isRequestTimeout() {
        this.isEqualTo(HttpStatus.REQUEST_TIMEOUT);
    }

    public final void isConflict() {
        this.isEqualTo(HttpStatus.CONFLICT);
    }

    public final void isGone() {
        this.isEqualTo(HttpStatus.GONE);
    }

    public final void isLengthRequired() {
        this.isEqualTo(HttpStatus.LENGTH_REQUIRED);
    }

    public final void isPreconditionFailed() {
        this.isEqualTo(HttpStatus.PRECONDITION_FAILED);
    }

    public final void isPayloadTooLarge() {
        this.isEqualTo(HttpStatus.PAYLOAD_TOO_LARGE);
    }

    public final void isRequestEntityTooLarge() {
        this.isEqualTo(HttpStatus.REQUEST_ENTITY_TOO_LARGE);
    }

    public final void isUriTooLong() {
        this.isEqualTo(HttpStatus.URI_TOO_LONG);
    }

    public final void isRequestUriTooLong() {
        this.isEqualTo(HttpStatus.REQUEST_URI_TOO_LONG);
    }

    public final void isUnsupportedMediaType() {
        this.isEqualTo(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    public final void isRequestedRangeNotSatisfiable() {
        this.isEqualTo(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
    }

    public final void isExpectationFailed() {
        this.isEqualTo(HttpStatus.EXPECTATION_FAILED);
    }

    public final void isIAmATeapot() {
        this.isEqualTo(HttpStatus.I_AM_A_TEAPOT);
    }

    public final void isInsufficientSpaceOnResource() {
        this.isEqualTo(HttpStatus.INSUFFICIENT_SPACE_ON_RESOURCE);
    }

    public final void isMethodFailure() {
        this.isEqualTo(HttpStatus.METHOD_FAILURE);
    }

    public final void isDestinationLocked() {
        this.isEqualTo(HttpStatus.DESTINATION_LOCKED);
    }

    public final void isUnprocessableEntity() {
        this.isEqualTo(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public final void isLocked() {
        this.isEqualTo(HttpStatus.LOCKED);
    }

    public final void isFailedDependency() {
        this.isEqualTo(HttpStatus.FAILED_DEPENDENCY);
    }

    public final void isTooEarly() {
        this.isEqualTo(HttpStatus.TOO_EARLY);
    }

    public final void isUpgradeRequired() {
        this.isEqualTo(HttpStatus.UPGRADE_REQUIRED);
    }

    public final void isPreconditionRequired() {
        this.isEqualTo(HttpStatus.PRECONDITION_REQUIRED);
    }

    public final void isTooManyRequests() {
        this.isEqualTo(HttpStatus.TOO_MANY_REQUESTS);
    }

    public final void isRequestHeaderFieldsTooLarge() {
        this.isEqualTo(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
    }

    public final void isUnavailableForLegalReasons() {
        this.isEqualTo(HttpStatus.UNAVAILABLE_FOR_LEGAL_REASONS);
    }

    public final void isInternalServerError() {
        this.isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public final void isNotImplemented() {
        this.isEqualTo(HttpStatus.NOT_IMPLEMENTED);
    }

    public final void isBadGateway() {
        this.isEqualTo(HttpStatus.BAD_GATEWAY);
    }

    public final void isServiceUnavailable() {
        this.isEqualTo(HttpStatus.SERVICE_UNAVAILABLE);
    }

    public final void isGatewayTimeout() {
        this.isEqualTo(HttpStatus.GATEWAY_TIMEOUT);
    }

    public final void isHttpVersionNotSupported() {
        this.isEqualTo(HttpStatus.HTTP_VERSION_NOT_SUPPORTED);
    }

    public final void isVariantAlsoNegotiates() {
        this.isEqualTo(HttpStatus.VARIANT_ALSO_NEGOTIATES);
    }

    public final void isInsufficientStorage() {
        this.isEqualTo(HttpStatus.INSUFFICIENT_STORAGE);
    }

    public final void isLoopDetected() {
        this.isEqualTo(HttpStatus.LOOP_DETECTED);
    }

    public final void isBandwidthLimitExceeded() {
        this.isEqualTo(HttpStatus.BANDWIDTH_LIMIT_EXCEEDED);
    }

    public final void isNotExtended() {
        this.isEqualTo(HttpStatus.NOT_EXTENDED);
    }

    public final void isNetworkAuthenticationRequired() {
        this.isEqualTo(HttpStatus.NETWORK_AUTHENTICATION_REQUIRED);
    }

    public final void isEqualTo(int expected) {
        int it = this.response.getStatus();
        boolean bl = false;
        if (it != expected) {
            AssertionErrors.fail((String)"Status", (Object)this.findStatus(expected), (Object)this.findStatus(it));
        }
    }

    public final void isEqualTo(@NotNull HttpStatus expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        int it = this.response.getStatus();
        boolean bl = false;
        if (it != expected.value()) {
            AssertionErrors.fail((String)"Status", (Object)expected.toString(), (Object)this.findStatus(it));
        }
    }

    private final String findStatus(int code) {
        Object object;
        HttpStatus httpStatus;
        block2: {
            HttpStatus[] httpStatusArray = HttpStatus.values();
            int n = httpStatusArray.length;
            for (int i = 0; i < n; ++i) {
                HttpStatus httpStatus2;
                HttpStatus it = httpStatus2 = httpStatusArray[i];
                boolean bl = false;
                if (!(it.value() == code)) continue;
                httpStatus = httpStatus2;
                break block2;
            }
            httpStatus = null;
        }
        if ((object = httpStatus != null ? httpStatus.toString() : null) == null) {
            object = code + " UNKNOWN";
        }
        return object;
    }
}

