/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test.matchers;

import io.kjson.spring.test.JSONResultActions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.springframework.test.util.AssertionErrors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u001c\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/kjson/spring/test/matchers/JSONHeaderResultMatchersDSL;", "", "resultActions", "Lio/kjson/spring/test/JSONResultActions;", "(Lio/kjson/spring/test/JSONResultActions;)V", "doesNotExist", "", "name", "", "exists", "string", "value", "matcher", "Lorg/hamcrest/Matcher;", "kjson-spring3-test"})
public final class JSONHeaderResultMatchersDSL {
    @NotNull
    private final JSONResultActions resultActions;

    public JSONHeaderResultMatchersDSL(@NotNull JSONResultActions resultActions) {
        Intrinsics.checkNotNullParameter((Object)resultActions, (String)"resultActions");
        this.resultActions = resultActions;
    }

    public final void string(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AssertionErrors.assertEquals((String)("Response header '" + name + "'"), (Object)value, (Object)this.resultActions.getMvcResult().getResponse().getHeader(name));
    }

    public final void string(@NotNull String name, @NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        MatcherAssert.assertThat((String)("Response header '" + name + "'"), (Object)this.resultActions.getMvcResult().getResponse().getHeader(name), matcher);
    }

    public final void exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AssertionErrors.assertTrue((String)("Response should contain header '" + name + "'"), (boolean)this.resultActions.getMvcResult().getResponse().containsHeader(name));
    }

    public final void doesNotExist(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AssertionErrors.assertFalse((String)("Response should not contain header '" + name + "'"), (boolean)this.resultActions.getMvcResult().getResponse().containsHeader(name));
    }
}

