/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test.matchers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/kjson/spring/test/matchers/MediaTypeMatcher;", "Lorg/hamcrest/BaseMatcher;", "", "mediaType", "Lorg/springframework/http/MediaType;", "(Lorg/springframework/http/MediaType;)V", "describeTo", "", "description", "Lorg/hamcrest/Description;", "matches", "", "actual", "", "kjson-spring-test"})
public final class MediaTypeMatcher
extends BaseMatcher<String> {
    @NotNull
    private final MediaType mediaType;

    public MediaTypeMatcher(@NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        this.mediaType = mediaType;
    }

    public void describeTo(@NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        description.appendText("valid Media Type");
    }

    public boolean matches(@Nullable Object actual) {
        MediaType mediaType;
        if (!(actual instanceof String)) {
            return false;
        }
        try {
            mediaType = MediaType.parseMediaType((String)((String)actual));
            Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"{\n            MediaType.\u2026diaType(actual)\n        }");
        }
        catch (Exception _) {
            return false;
        }
        MediaType actualMediaType = mediaType;
        return actualMediaType.equalsTypeAndSubtype((MimeType)this.mediaType);
    }
}

