/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test.matchers;

import io.kjson.spring.test.JSONResultActions;
import io.kjson.test.JSONExpect;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.MediaType;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.result.ContentResultMatchers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000eJ\u001f\u0010\u0012\u001a\u00020\u000b2\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\u0002\b\u0016J\u001a\u0010\u0017\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00190\u0014J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000eJ\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bH\u0007R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/kjson/spring/test/matchers/JSONContentResultMatchersDSL;", "", "resultActions", "Lio/kjson/spring/test/JSONResultActions;", "(Lio/kjson/spring/test/JSONResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/ContentResultMatchers;", "kotlin.jvm.PlatformType", "getResultActions", "()Lio/kjson/spring/test/JSONResultActions;", "bytes", "", "", "contentType", "", "Lorg/springframework/http/MediaType;", "contentTypeCompatibleWith", "encoding", "matchesJSON", "tests", "Lkotlin/Function1;", "Lio/kjson/test/JSONExpect;", "Lkotlin/ExtensionFunctionType;", "string", "test", "", "matcher", "Lorg/hamcrest/Matcher;", "kjson-spring-test"})
public final class JSONContentResultMatchersDSL {
    @NotNull
    private final JSONResultActions resultActions;
    private final ContentResultMatchers matchers;

    public JSONContentResultMatchersDSL(@NotNull JSONResultActions resultActions) {
        Intrinsics.checkNotNullParameter((Object)resultActions, (String)"resultActions");
        this.resultActions = resultActions;
        this.matchers = MockMvcResultMatchers.content();
    }

    @NotNull
    public final JSONResultActions getResultActions() {
        return this.resultActions;
    }

    public final void contentType(@NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.matchers.contentType(contentType).match(this.resultActions.getMvcResult());
    }

    public final void contentType(@NotNull MediaType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.matchers.contentType(contentType).match(this.resultActions.getMvcResult());
    }

    public final void contentTypeCompatibleWith(@NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.matchers.contentTypeCompatibleWith(contentType).match(this.resultActions.getMvcResult());
    }

    public final void contentTypeCompatibleWith(@NotNull MediaType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.matchers.contentTypeCompatibleWith(contentType).match(this.resultActions.getMvcResult());
    }

    public final void encoding(@NotNull String encoding) {
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        this.matchers.encoding(encoding).match(this.resultActions.getMvcResult());
    }

    public final void string(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        AssertionErrors.assertEquals((String)"Response content", (Object)string, (Object)this.resultActions.getMvcResult().getResponse().getContentAsString());
    }

    public final void string(@NotNull Function1<? super String, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        String string = this.resultActions.getMvcResult().getResponse().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultActions.mvcResult.response.contentAsString");
        if (!((Boolean)test.invoke((Object)string)).booleanValue()) {
            AssertionErrors.fail((String)"Response content doesn't match test");
        }
    }

    @Deprecated(message="The use of Matcher may be removed in a future version", replaceWith=@ReplaceWith(expression="string { test(it) }", imports={}))
    public final void string(@NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        MatcherAssert.assertThat((String)"Response content", (Object)this.resultActions.getMvcResult().getResponse().getContentAsString(), matcher);
    }

    public final void bytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        AssertionErrors.assertEquals((String)"Response content", (Object)bytes, (Object)this.resultActions.getMvcResult().getResponse().getContentAsByteArray());
    }

    public final void matchesJSON(@NotNull Function1<? super JSONExpect, Unit> tests) {
        Intrinsics.checkNotNullParameter(tests, (String)"tests");
        String string = this.resultActions.getMvcResult().getResponse().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultActions.mvcResult.response.contentAsString");
        JSONExpect.Companion.expectJSON(string, tests);
    }
}

