/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test.matchers;

import io.kjson.spring.test.JSONResultActions;
import io.kjson.spring.test.matchers.JSONContentResultMatchersDSL;
import io.kjson.spring.test.matchers.JSONHeaderResultMatchersDSL;
import io.kjson.spring.test.matchers.JSONStatusResultMatchersDSL;
import io.kjson.test.JSONExpect;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u000f\u001a\u00020\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0014J\u001f\u0010\u0015\u001a\u00020\u00102\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0014J\u001f\u0010\u0018\u001a\u00020\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0014J\u001f\u0010\u001a\u001a\u00020\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\b\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lio/kjson/spring/test/matchers/JSONMockMvcResultMatchersDSL;", "", "resultActions", "Lio/kjson/spring/test/JSONResultActions;", "(Lio/kjson/spring/test/JSONResultActions;)V", "contentAsString", "", "getContentAsString", "()Ljava/lang/String;", "response", "Lorg/springframework/mock/web/MockHttpServletResponse;", "getResponse", "()Lorg/springframework/mock/web/MockHttpServletResponse;", "getResultActions", "()Lio/kjson/spring/test/JSONResultActions;", "content", "", "dsl", "Lkotlin/Function1;", "Lio/kjson/spring/test/matchers/JSONContentResultMatchersDSL;", "Lkotlin/ExtensionFunctionType;", "contentMatchesJSON", "tests", "Lio/kjson/test/JSONExpect;", "header", "Lio/kjson/spring/test/matchers/JSONHeaderResultMatchersDSL;", "status", "Lio/kjson/spring/test/matchers/JSONStatusResultMatchersDSL;", "kjson-spring-test"})
public final class JSONMockMvcResultMatchersDSL {
    @NotNull
    private final JSONResultActions resultActions;

    public JSONMockMvcResultMatchersDSL(@NotNull JSONResultActions resultActions) {
        Intrinsics.checkNotNullParameter((Object)resultActions, (String)"resultActions");
        this.resultActions = resultActions;
    }

    @NotNull
    public final JSONResultActions getResultActions() {
        return this.resultActions;
    }

    @NotNull
    public final MockHttpServletResponse getResponse() {
        MockHttpServletResponse mockHttpServletResponse = this.resultActions.getMvcResult().getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)mockHttpServletResponse, (String)"resultActions.mvcResult.response");
        return mockHttpServletResponse;
    }

    @NotNull
    public final String getContentAsString() {
        String string = this.resultActions.getMvcResult().getResponse().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultActions.mvcResult.response.contentAsString");
        return string;
    }

    public final void status(@NotNull Function1<? super JSONStatusResultMatchersDSL, Unit> dsl) {
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        MockHttpServletResponse mockHttpServletResponse = this.resultActions.getMvcResult().getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)mockHttpServletResponse, (String)"resultActions.mvcResult.response");
        dsl.invoke((Object)new JSONStatusResultMatchersDSL(mockHttpServletResponse));
    }

    public final void content(@NotNull Function1<? super JSONContentResultMatchersDSL, Unit> dsl) {
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        dsl.invoke((Object)new JSONContentResultMatchersDSL(this.resultActions));
    }

    public final void contentMatchesJSON(@NotNull Function1<? super JSONExpect, Unit> tests) {
        Intrinsics.checkNotNullParameter(tests, (String)"tests");
        MockMvcResultMatchers.content().contentTypeCompatibleWith(MediaType.APPLICATION_JSON).match(this.resultActions.getMvcResult());
        String string = this.resultActions.getMvcResult().getResponse().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultActions.mvcResult.response.contentAsString");
        JSONExpect.Companion.expectJSON(string, tests);
    }

    public final void header(@NotNull Function1<? super JSONHeaderResultMatchersDSL, Unit> dsl) {
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        dsl.invoke((Object)new JSONHeaderResultMatchersDSL(this.resultActions));
    }
}

