/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test.matchers;

import io.kjson.spring.test.JSONMockMvc;
import io.kjson.spring.test.matchers.JSONContentResultMatchersDSL;
import io.kjson.spring.test.matchers.JSONStatusResultMatchersDSL;
import io.kjson.test.JSONExpect;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\b\fJ\u001f\u0010\r\u001a\u00020\b2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\b\fJ\u001f\u0010\u0010\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\b\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lio/kjson/spring/test/matchers/JSONMockMvcResultMatchersDSL;", "", "resultActions", "Lio/kjson/spring/test/JSONMockMvc$JSONResultActions;", "(Lio/kjson/spring/test/JSONMockMvc$JSONResultActions;)V", "getResultActions", "()Lio/kjson/spring/test/JSONMockMvc$JSONResultActions;", "content", "", "dsl", "Lkotlin/Function1;", "Lio/kjson/spring/test/matchers/JSONContentResultMatchersDSL;", "Lkotlin/ExtensionFunctionType;", "contentMatchesJSON", "tests", "Lio/kjson/test/JSONExpect;", "status", "Lio/kjson/spring/test/matchers/JSONStatusResultMatchersDSL;", "kjson-spring-test"})
public final class JSONMockMvcResultMatchersDSL {
    @NotNull
    private final JSONMockMvc.JSONResultActions resultActions;

    public JSONMockMvcResultMatchersDSL(@NotNull JSONMockMvc.JSONResultActions resultActions) {
        Intrinsics.checkNotNullParameter((Object)resultActions, (String)"resultActions");
        this.resultActions = resultActions;
    }

    @NotNull
    public final JSONMockMvc.JSONResultActions getResultActions() {
        return this.resultActions;
    }

    public final void status(@NotNull Function1<? super JSONStatusResultMatchersDSL, Unit> dsl) {
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        MockHttpServletResponse mockHttpServletResponse = this.resultActions.getMvcResult().getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)mockHttpServletResponse, (String)"resultActions.mvcResult.response");
        dsl.invoke((Object)new JSONStatusResultMatchersDSL(mockHttpServletResponse));
    }

    public final void content(@NotNull Function1<? super JSONContentResultMatchersDSL, Unit> dsl) {
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        dsl.invoke((Object)new JSONContentResultMatchersDSL(this.resultActions));
    }

    public final void contentMatchesJSON(@NotNull Function1<? super JSONExpect, Unit> tests) {
        Intrinsics.checkNotNullParameter(tests, (String)"tests");
        MockMvcResultMatchers.content().contentTypeCompatibleWith(MediaType.APPLICATION_JSON).match(this.resultActions.getMvcResult());
        String string = this.resultActions.getMvcResult().getResponse().getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultActions.mvcResult.response.contentAsString");
        JSONExpect.Companion.expectJSON(string, tests);
    }
}

