/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test;

import io.kjson.JSONConfig;
import io.kjson.JSONFunKt;
import io.kjson.spring.test.JSONMockServerDSL;
import io.kjson.spring.test.JSONTestConfig;
import io.kjson.test.JSONExpect;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.MultiValueMap;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u000289B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\bJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019J'\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001c\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001dJ=\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132&\u0010\u001e\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00130\u001f0\u001c\"\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00130\u001fH\u0007\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#J'\u0010$\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001c\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010%\u001a\u00020\b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019J\u000e\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0013J\u001f\u0010'\u001a\u00020\b2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\b0\u0019\u00a2\u0006\u0002\b*J\u001a\u0010+\u001a\u00020\b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019J\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0013J\u0018\u0010+\u001a\u00020\b2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u001fH\u0007J(\u0010/\u001a\u00020\b2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0013J&\u00105\u001a\u00020\b2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000106J7\u00105\u001a\u00020\b2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\u0019\u00107\u001a\u0015\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u0001060\u0019\u00a2\u0006\u0002\b*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/kjson/spring/test/JSONMockServerDSL;", "Lorg/springframework/test/web/client/ResponseCreator;", "()V", "request", "Lorg/springframework/mock/http/client/MockClientHttpRequest;", "response", "Lio/kjson/spring/test/JSONMockServerDSL$Response;", "accept", "", "expectedMediaType", "Lorg/springframework/http/MediaType;", "acceptApplicationJSON", "contentType", "contentTypeApplicationJSON", "createResponse", "Lorg/springframework/http/client/ClientHttpResponse;", "Lorg/springframework/http/client/ClientHttpRequest;", "getHeaders", "", "", "name", "expectedCount", "", "header", "test", "Lkotlin/Function1;", "", "expectedValues", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "matchers", "Lorg/hamcrest/Matcher;", "(Ljava/lang/String;[Lorg/hamcrest/Matcher;)V", "headerDoesNotExist", "method", "Lorg/springframework/http/HttpMethod;", "queryParam", "requestContent", "body", "requestJSON", "tests", "Lio/kjson/test/JSONExpect;", "Lkotlin/ExtensionFunctionType;", "requestTo", "expectedURI", "Ljava/net/URI;", "matcher", "respond", "status", "Lorg/springframework/http/HttpStatus;", "headers", "Lorg/springframework/http/HttpHeaders;", "result", "respondJSON", "", "block", "Companion", "Response", "kjson-spring-test"})
public final class JSONMockServerDSL
implements ResponseCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private MockClientHttpRequest request;
    @Nullable
    private Response response;

    private JSONMockServerDSL() {
    }

    public final void requestTo(@NotNull String expectedURI) {
        Intrinsics.checkNotNullParameter((Object)expectedURI, (String)"expectedURI");
        this.requestTo(new URI(expectedURI));
    }

    public final void requestTo(@NotNull URI expectedURI) {
        Intrinsics.checkNotNullParameter((Object)expectedURI, (String)"expectedURI");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        URI uri = mockClientHttpRequest.getURI();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        if (!Companion.equalIgnoringQuery(uri, expectedURI)) {
            Companion.fail("Request URI doesn't match; expected " + expectedURI + ", was " + uri);
            throw new KotlinNothingValueException();
        }
    }

    public final void requestTo(@NotNull Function1<? super String, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        String string = mockClientHttpRequest.getURI().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.uri.toString()");
        if (!((Boolean)test.invoke((Object)string)).booleanValue()) {
            MockClientHttpRequest mockClientHttpRequest2 = this.request;
            if (mockClientHttpRequest2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"request");
                mockClientHttpRequest2 = null;
            }
            Companion.fail(Intrinsics.stringPlus((String)"Request URI doesn't match; was ", (Object)mockClientHttpRequest2.getURI()));
            throw new KotlinNothingValueException();
        }
    }

    @Deprecated(message="The use of Matcher will be removed in a future version", replaceWith=@ReplaceWith(expression="requestTo { test(it) }", imports={}))
    public final void requestTo(@NotNull Matcher<? super String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        MatcherAssert.assertThat((String)"Request URI", (Object)mockClientHttpRequest.getURI().toString(), matcher);
    }

    public final void method(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        if (mockClientHttpRequest.getMethod() != method) {
            StringBuilder stringBuilder = new StringBuilder().append("Request method incorrect; expected ").append(method).append(", was ");
            MockClientHttpRequest mockClientHttpRequest2 = this.request;
            if (mockClientHttpRequest2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"request");
                mockClientHttpRequest2 = null;
            }
            Companion.fail(stringBuilder.append(mockClientHttpRequest2.getMethod()).toString());
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void queryParam(@NotNull String name, String ... expectedValues) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expectedValues, (String)"expectedValues");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        String string = mockClientHttpRequest.getURI().getQuery();
        if (string == null) {
            list = null;
        } else {
            char[] cArray = new char[]{'&'};
            List list2 = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)Intrinsics.stringPlus((String)name, (Object)"="), (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
        }
        List queryEntries = list;
        if (queryEntries == null || queryEntries.isEmpty()) {
            throw new AssertionError((Object)("Request query param [" + name + "] not found"));
        }
        int n = expectedValues.length;
        if (queryEntries.size() != n) {
            Companion.fail("Request query param [" + name + "] number incorrect; expected " + n + ", was " + queryEntries.size());
            throw new KotlinNothingValueException();
        }
        int n2 = 0;
        while (n2 < n) {
            int i;
            String queryValue = StringsKt.substringAfter$default((String)((String)queryEntries.get(i)), (char)'=', null, (int)2, null);
            if (Intrinsics.areEqual((Object)expectedValues[i = n2++], (Object)queryValue)) continue;
            Companion.fail("Request query param [" + name + "] incorrect; expected " + expectedValues[i] + ", was " + queryValue);
            throw new KotlinNothingValueException();
        }
    }

    public final void header(@NotNull String name, String ... expectedValues) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expectedValues, (String)"expectedValues");
        int n = expectedValues.length;
        List<String> headers = this.getHeaders(name, n);
        int n2 = 0;
        while (n2 < n) {
            int i;
            if (Intrinsics.areEqual((Object)expectedValues[i = n2++], (Object)headers.get(i))) continue;
            Companion.fail("Request header [" + name + "] incorrect; expected " + expectedValues[i] + ", was " + headers.get(i));
            throw new KotlinNothingValueException();
        }
    }

    public final void header(@NotNull String name, @NotNull Function1<? super String, Boolean> test) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(test, (String)"test");
        String header = (String)CollectionsKt.first(this.getHeaders(name, 1));
        if (!((Boolean)test.invoke((Object)header)).booleanValue()) {
            Companion.fail("Request header [" + name + "] incorrect; was " + header);
            throw new KotlinNothingValueException();
        }
    }

    @Deprecated(message="The use of Matcher will be removed in a future version", replaceWith=@ReplaceWith(expression="header(name) { test(it) }", imports={}))
    public final void header(@NotNull String name, Matcher<? super String> ... matchers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matchers, (String)"matchers");
        int n = matchers.length;
        List<String> headers = this.getHeaders(name, n);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            MatcherAssert.assertThat((String)("Request header [" + name + ']'), (Object)headers.get(i), matchers[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void accept(@NotNull MediaType expectedMediaType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expectedMediaType, (String)"expectedMediaType");
        String header = (String)CollectionsKt.first(this.getHeaders("Accept", 1));
        char[] cArray = new char[]{','};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)header, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!Companion.checkMediaType(it, "Accept").isCompatibleWith(expectedMediaType)) continue;
            return;
        }
        Companion.fail("Request [Accept] header incorrect; expected " + expectedMediaType + ", was " + header);
        throw new KotlinNothingValueException();
    }

    public final void acceptApplicationJSON() {
        MediaType mediaType = MediaType.APPLICATION_JSON;
        Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"APPLICATION_JSON");
        this.accept(mediaType);
    }

    public final void contentType(@NotNull MediaType expectedMediaType) {
        Intrinsics.checkNotNullParameter((Object)expectedMediaType, (String)"expectedMediaType");
        String header = (String)CollectionsKt.first(this.getHeaders("Content-Type", 1));
        if (!Companion.checkMediaType(header, "Content-Type").isCompatibleWith(expectedMediaType)) {
            Companion.fail("Request [Content-Type] header incorrect; expected " + expectedMediaType + ", was " + header);
            throw new KotlinNothingValueException();
        }
    }

    public final void contentTypeApplicationJSON() {
        MediaType mediaType = MediaType.APPLICATION_JSON;
        Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"APPLICATION_JSON");
        this.contentType(mediaType);
    }

    private final List<String> getHeaders(String name, int expectedCount) {
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        List list = (List)mockClientHttpRequest.getHeaders().get((Object)name);
        if (list == null) {
            throw new AssertionError((Object)("Header [" + name + "] not found"));
        }
        List headers = list;
        if (headers.size() != expectedCount) {
            if (expectedCount == 1) {
                Companion.fail("Request [" + name + "] header; expected single header, was multiple (" + headers.size() + ')');
                throw new KotlinNothingValueException();
            }
            Companion.fail("Request [" + name + "] header number incorrect; expected " + expectedCount + ", was " + headers.size());
            throw new KotlinNothingValueException();
        }
        return headers;
    }

    public final void headerDoesNotExist(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        if (mockClientHttpRequest.getHeaders().containsKey((Object)name)) {
            Companion.fail("Request [" + name + "] header expected not to be present");
            throw new KotlinNothingValueException();
        }
    }

    public final void requestContent(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        if (!Intrinsics.areEqual((Object)mockClientHttpRequest.getBodyAsString(), (Object)body)) {
            Companion.fail("Request body incorrect");
            throw new KotlinNothingValueException();
        }
    }

    public final void requestContent(@NotNull Function1<? super String, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        String string = mockClientHttpRequest.getBodyAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.bodyAsString");
        if (!((Boolean)test.invoke((Object)string)).booleanValue()) {
            Companion.fail("Request body incorrect");
            throw new KotlinNothingValueException();
        }
    }

    public final void requestJSON(@NotNull Function1<? super JSONExpect, Unit> tests) {
        Intrinsics.checkNotNullParameter(tests, (String)"tests");
        this.contentTypeApplicationJSON();
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        String string = mockClientHttpRequest.getBodyAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.bodyAsString");
        JSONExpect.Companion.expectJSON(string, tests);
    }

    public final void respondJSON(@NotNull HttpStatus status, @Nullable HttpHeaders headers, @NotNull Function1<? super MockClientHttpRequest, ? extends Object> block) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MockClientHttpRequest mockClientHttpRequest = this.request;
        if (mockClientHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            mockClientHttpRequest = null;
        }
        this.respondJSON(status, headers, block.invoke((Object)mockClientHttpRequest));
    }

    public static /* synthetic */ void respondJSON$default(JSONMockServerDSL jSONMockServerDSL, HttpStatus httpStatus, HttpHeaders httpHeaders, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            httpStatus = HttpStatus.OK;
        }
        if ((n & 2) != 0) {
            httpHeaders = null;
        }
        jSONMockServerDSL.respondJSON(httpStatus, httpHeaders, (Function1<? super MockClientHttpRequest, ? extends Object>)function1);
    }

    public final void respondJSON(@NotNull HttpStatus status, @Nullable HttpHeaders headers, @Nullable Object result) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        HttpHeaders headers1 = new HttpHeaders();
        HttpHeaders httpHeaders = headers;
        if (httpHeaders != null) {
            HttpHeaders it = httpHeaders;
            boolean bl = false;
            headers1.addAll((MultiValueMap)it);
        }
        headers1.setContentType(MediaType.APPLICATION_JSON);
        this.respond(status, headers1, JSONFunKt.stringifyJSON((Object)result, (JSONConfig)JSONTestConfig.Companion.getConfig()));
    }

    public static /* synthetic */ void respondJSON$default(JSONMockServerDSL jSONMockServerDSL, HttpStatus httpStatus, HttpHeaders httpHeaders, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            httpStatus = HttpStatus.OK;
        }
        if ((n & 2) != 0) {
            httpHeaders = null;
        }
        jSONMockServerDSL.respondJSON(httpStatus, httpHeaders, object);
    }

    public final void respond(@NotNull HttpStatus status, @Nullable HttpHeaders headers, @Nullable String result) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.response = new Response(status, headers, result);
    }

    public static /* synthetic */ void respond$default(JSONMockServerDSL jSONMockServerDSL, HttpStatus httpStatus, HttpHeaders httpHeaders, String string, int n, Object object) {
        if ((n & 1) != 0) {
            httpStatus = HttpStatus.OK;
        }
        if ((n & 2) != 0) {
            httpHeaders = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        jSONMockServerDSL.respond(httpStatus, httpHeaders, string);
    }

    @Nullable
    public ClientHttpResponse createResponse(@Nullable ClientHttpRequest request) {
        MockClientHttpResponse mockClientHttpResponse;
        Response response = this.response;
        if (response == null) {
            mockClientHttpResponse = null;
        } else {
            MockClientHttpResponse mockClientHttpResponse2;
            byte[] byArray;
            byte[] byArray2;
            Response resp = response;
            boolean bl = false;
            String string = resp.getBody();
            if (string == null) {
                byArray2 = null;
            } else {
                String string2 = string;
                byte[] byArray3 = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                byArray2 = byArray = byArray3;
            }
            if (byArray2 == null) {
                byArray = new byte[]{};
            }
            byte[] body = byArray;
            MockClientHttpResponse $this$createResponse_u24lambda_u2d6_u24lambda_u2d5 = mockClientHttpResponse2 = new MockClientHttpResponse(body, resp.getStatus());
            boolean bl2 = false;
            HttpHeaders httpHeaders = resp.getHeaders();
            if (httpHeaders != null) {
                HttpHeaders it = httpHeaders;
                boolean bl3 = false;
                $this$createResponse_u24lambda_u2d6_u24lambda_u2d5.getHeaders().addAll((MultiValueMap)it);
            }
            mockClientHttpResponse = mockClientHttpResponse2;
        }
        return (ClientHttpResponse)mockClientHttpResponse;
    }

    public /* synthetic */ JSONMockServerDSL(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/kjson/spring/test/JSONMockServerDSL$Response;", "", "status", "Lorg/springframework/http/HttpStatus;", "headers", "Lorg/springframework/http/HttpHeaders;", "body", "", "(Lorg/springframework/http/HttpStatus;Lorg/springframework/http/HttpHeaders;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getHeaders", "()Lorg/springframework/http/HttpHeaders;", "getStatus", "()Lorg/springframework/http/HttpStatus;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kjson-spring-test"})
    public static final class Response {
        @NotNull
        private final HttpStatus status;
        @Nullable
        private final HttpHeaders headers;
        @Nullable
        private final String body;

        public Response(@NotNull HttpStatus status, @Nullable HttpHeaders headers, @Nullable String body) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.status = status;
            this.headers = headers;
            this.body = body;
        }

        @NotNull
        public final HttpStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final HttpHeaders getHeaders() {
            return this.headers;
        }

        @Nullable
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final HttpStatus component1() {
            return this.status;
        }

        @Nullable
        public final HttpHeaders component2() {
            return this.headers;
        }

        @Nullable
        public final String component3() {
            return this.body;
        }

        @NotNull
        public final Response copy(@NotNull HttpStatus status, @Nullable HttpHeaders headers, @Nullable String body) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new Response(status, headers, body);
        }

        public static /* synthetic */ Response copy$default(Response response, HttpStatus httpStatus, HttpHeaders httpHeaders, String string, int n, Object object) {
            if ((n & 1) != 0) {
                httpStatus = response.status;
            }
            if ((n & 2) != 0) {
                httpHeaders = response.headers;
            }
            if ((n & 4) != 0) {
                string = response.body;
            }
            return response.copy(httpStatus, httpHeaders, string);
        }

        @NotNull
        public String toString() {
            return "Response(status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + ')';
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + (this.headers == null ? 0 : this.headers.hashCode());
            result = result * 31 + (this.body == null ? 0 : this.body.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response = (Response)other;
            if (this.status != response.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headers, (Object)response.headers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.body, (Object)response.body);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJG\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0019\b\u0002\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bJ;\u0010\u001c\u001a\u00020\u0010*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0019\b\u0002\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bJ;\u0010\u001d\u001a\u00020\u0010*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0019\b\u0002\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001b\u00a8\u0006\u001e"}, d2={"Lio/kjson/spring/test/JSONMockServerDSL$Companion;", "", "()V", "checkMediaType", "Lorg/springframework/http/MediaType;", "header", "", "name", "fail", "", "message", "equalIgnoringQuery", "", "Ljava/net/URI;", "other", "mock", "Lorg/springframework/test/web/client/ResponseActions;", "Lorg/springframework/test/web/client/MockRestServiceServer;", "expectedCount", "Lorg/springframework/test/web/client/ExpectedCount;", "method", "Lorg/springframework/http/HttpMethod;", "uri", "block", "Lkotlin/Function1;", "Lio/kjson/spring/test/JSONMockServerDSL;", "", "Lkotlin/ExtensionFunctionType;", "mockGet", "mockPost", "kjson-spring-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Void fail(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            throw new AssertionError((Object)message);
        }

        @NotNull
        public final MediaType checkMediaType(@NotNull String header, @NotNull String name) {
            MediaType mediaType;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                mediaType = MediaType.parseMediaType((String)header);
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"{\n            MediaType.\u2026diaType(header)\n        }");
            }
            catch (Exception _) {
                this.fail("Request [" + name + "] header media type invalid: " + header);
                throw new KotlinNothingValueException();
            }
            return mediaType;
        }

        public final boolean equalIgnoringQuery(@NotNull URI $this$equalIgnoringQuery, @NotNull URI other) {
            Intrinsics.checkNotNullParameter((Object)$this$equalIgnoringQuery, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return $this$equalIgnoringQuery.isOpaque() ? other.isOpaque() && Intrinsics.areEqual((Object)$this$equalIgnoringQuery.getSchemeSpecificPart(), (Object)other.getSchemeSpecificPart()) : !other.isOpaque() && Intrinsics.areEqual((Object)$this$equalIgnoringQuery.getScheme(), (Object)other.getScheme()) && Intrinsics.areEqual((Object)$this$equalIgnoringQuery.getUserInfo(), (Object)other.getUserInfo()) && Intrinsics.areEqual((Object)$this$equalIgnoringQuery.getHost(), (Object)other.getHost()) && $this$equalIgnoringQuery.getPort() == other.getPort() && Intrinsics.areEqual((Object)$this$equalIgnoringQuery.getPath(), (Object)other.getPath());
        }

        @NotNull
        public final ResponseActions mock(@NotNull MockRestServiceServer $this$mock, @NotNull ExpectedCount expectedCount, @Nullable HttpMethod method, @Nullable URI uri, @NotNull Function1<? super JSONMockServerDSL, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$mock, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expectedCount, (String)"expectedCount");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            JSONMockServerDSL serverDSL = new JSONMockServerDSL(null);
            ResponseActions responseActions = $this$mock.expect(expectedCount, arg_0 -> Companion.mock$lambda-3(serverDSL, method, uri, block, arg_0));
            responseActions.andRespond((ResponseCreator)serverDSL);
            Intrinsics.checkNotNullExpressionValue((Object)responseActions, (String)"responseActions");
            return responseActions;
        }

        public static /* synthetic */ ResponseActions mock$default(Companion companion, MockRestServiceServer mockRestServiceServer, ExpectedCount expectedCount, HttpMethod httpMethod, URI uRI, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                ExpectedCount expectedCount2 = ExpectedCount.once();
                Intrinsics.checkNotNullExpressionValue((Object)expectedCount2, (String)"once()");
                expectedCount = expectedCount2;
            }
            if ((n & 2) != 0) {
                httpMethod = null;
            }
            if ((n & 4) != 0) {
                uRI = null;
            }
            if ((n & 8) != 0) {
                function1 = mock.1.INSTANCE;
            }
            return companion.mock(mockRestServiceServer, expectedCount, httpMethod, uRI, (Function1<? super JSONMockServerDSL, Unit>)function1);
        }

        @NotNull
        public final ResponseActions mockGet(@NotNull MockRestServiceServer $this$mockGet, @NotNull ExpectedCount expectedCount, @Nullable URI uri, @NotNull Function1<? super JSONMockServerDSL, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$mockGet, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expectedCount, (String)"expectedCount");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.mock($this$mockGet, expectedCount, HttpMethod.GET, uri, block);
        }

        public static /* synthetic */ ResponseActions mockGet$default(Companion companion, MockRestServiceServer mockRestServiceServer, ExpectedCount expectedCount, URI uRI, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                ExpectedCount expectedCount2 = ExpectedCount.once();
                Intrinsics.checkNotNullExpressionValue((Object)expectedCount2, (String)"once()");
                expectedCount = expectedCount2;
            }
            if ((n & 2) != 0) {
                uRI = null;
            }
            if ((n & 4) != 0) {
                function1 = mockGet.1.INSTANCE;
            }
            return companion.mockGet(mockRestServiceServer, expectedCount, uRI, (Function1<? super JSONMockServerDSL, Unit>)function1);
        }

        @NotNull
        public final ResponseActions mockPost(@NotNull MockRestServiceServer $this$mockPost, @NotNull ExpectedCount expectedCount, @Nullable URI uri, @NotNull Function1<? super JSONMockServerDSL, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$mockPost, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expectedCount, (String)"expectedCount");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.mock($this$mockPost, expectedCount, HttpMethod.POST, uri, block);
        }

        public static /* synthetic */ ResponseActions mockPost$default(Companion companion, MockRestServiceServer mockRestServiceServer, ExpectedCount expectedCount, URI uRI, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                ExpectedCount expectedCount2 = ExpectedCount.once();
                Intrinsics.checkNotNullExpressionValue((Object)expectedCount2, (String)"once()");
                expectedCount = expectedCount2;
            }
            if ((n & 2) != 0) {
                uRI = null;
            }
            if ((n & 4) != 0) {
                function1 = mockPost.1.INSTANCE;
            }
            return companion.mockPost(mockRestServiceServer, expectedCount, uRI, (Function1<? super JSONMockServerDSL, Unit>)function1);
        }

        private static final void mock$lambda-3(JSONMockServerDSL $serverDSL, HttpMethod $method, URI $uri, Function1 $block, ClientHttpRequest request) {
            Object it;
            JSONMockServerDSL jSONMockServerDSL;
            Intrinsics.checkNotNullParameter((Object)$serverDSL, (String)"$serverDSL");
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            ClientHttpRequest clientHttpRequest = request;
            if (clientHttpRequest == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.springframework.mock.http.client.MockClientHttpRequest");
            }
            $serverDSL.request = (MockClientHttpRequest)clientHttpRequest;
            JSONMockServerDSL $this$mock_u24lambda_u2d3_u24lambda_u2d2 = jSONMockServerDSL = $serverDSL;
            boolean bl = false;
            HttpMethod httpMethod = $method;
            if (httpMethod != null) {
                it = httpMethod;
                boolean bl2 = false;
                $this$mock_u24lambda_u2d3_u24lambda_u2d2.method((HttpMethod)it);
            }
            URI uRI = $uri;
            if (uRI != null) {
                it = uRI;
                boolean bl3 = false;
                $this$mock_u24lambda_u2d3_u24lambda_u2d2.requestTo((URI)it);
            }
            $block.invoke((Object)$this$mock_u24lambda_u2d3_u24lambda_u2d2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

