/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.spring.test;

import io.kjson.spring.test.MediaTypeMatcher;
import io.kjson.test.JSONExpect;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J'\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b\"\u00020\t\u00a2\u0006\u0002\u0010\fJ;\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2&\u0010\r\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\t0\u000e0\u000b\"\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\t0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J'\u0010\u0013\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b\"\u00020\t\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0014\u001a\u00020\u00062\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u0016\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u00062\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/kjson/spring/test/JSONMockServerDSL;", "", "request", "Lorg/springframework/mock/http/client/MockClientHttpRequest;", "(Lorg/springframework/mock/http/client/MockClientHttpRequest;)V", "acceptApplicationJSON", "", "header", "name", "", "expectedValues", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "matchers", "Lorg/hamcrest/Matcher;", "(Ljava/lang/String;[Lorg/hamcrest/Matcher;)V", "headerDoesNotExist", "method", "Lorg/springframework/http/HttpMethod;", "queryParam", "requestJSON", "tests", "Lkotlin/Function1;", "Lio/kjson/test/JSONExpect;", "Lkotlin/ExtensionFunctionType;", "requestTo", "expectedURI", "Ljava/net/URI;", "matcher", "Companion", "kjson-spring-test"})
public final class JSONMockServerDSL {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockClientHttpRequest request;
    @NotNull
    private static final MediaTypeMatcher mediaTypeMatcher;

    private JSONMockServerDSL(MockClientHttpRequest request) {
        this.request = request;
    }

    public final void requestTo(@NotNull String expectedURI) {
        Intrinsics.checkNotNullParameter((Object)expectedURI, (String)"expectedURI");
        this.requestTo(new URI(expectedURI));
    }

    public final void requestTo(@NotNull URI expectedURI) {
        Intrinsics.checkNotNullParameter((Object)expectedURI, (String)"expectedURI");
        URI uri = this.request.getURI();
        boolean bl = uri.isOpaque() ? !Intrinsics.areEqual((Object)uri.getSchemeSpecificPart(), (Object)expectedURI.getSchemeSpecificPart()) : !Intrinsics.areEqual((Object)uri.getScheme(), (Object)expectedURI.getScheme()) || !Intrinsics.areEqual((Object)uri.getUserInfo(), (Object)expectedURI.getUserInfo()) || uri.getPort() != expectedURI.getPort() || !Intrinsics.areEqual((Object)uri.getHost(), (Object)expectedURI.getHost()) || !Intrinsics.areEqual((Object)uri.getPath(), (Object)expectedURI.getPath());
        if (bl) {
            throw new AssertionError((Object)("Request URI doesn't match; expected " + expectedURI + ", was " + this.request.getURI()));
        }
    }

    public final void requestTo(@NotNull Matcher<? super String> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        MockRestRequestMatchers.requestTo(matcher).match((ClientHttpRequest)this.request);
    }

    public final void method(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.request.getMethod() != method) {
            throw new AssertionError((Object)("Request method incorrect; expected " + method + ", was " + this.request.getMethod()));
        }
    }

    public final void queryParam(@NotNull String name, String ... expectedValues) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expectedValues, (String)"expectedValues");
        MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)this.request.getURI()).build().getQueryParams();
        List list = (List)queryParams.get((Object)name);
        if (list == null) {
            throw new AssertionError((Object)("Query param [" + name + "] not found"));
        }
        List param = list;
        int n = expectedValues.length;
        if (param.size() != n) {
            throw new AssertionError((Object)("Query param [" + name + "] number incorrect; expected " + n + ", was " + param.size()));
        }
        int n2 = 0;
        while (n2 < n) {
            int i;
            if (!Intrinsics.areEqual((Object)expectedValues[i = n2++], param.get(i))) {
                throw new AssertionError((Object)("Query param [" + name + "] incorrect; expected " + expectedValues[i] + ", was " + param.get(i)));
            }
        }
    }

    public final void header(@NotNull String name, String ... expectedValues) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expectedValues, (String)"expectedValues");
        MockRestRequestMatchers.header((String)name, (String[])Arrays.copyOf(expectedValues, expectedValues.length)).match((ClientHttpRequest)this.request);
    }

    public final void header(@NotNull String name, Matcher<? super String> ... matchers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matchers, (String)"matchers");
        MockRestRequestMatchers.header((String)name, Arrays.copyOf(matchers, matchers.length)).match((ClientHttpRequest)this.request);
    }

    public final void acceptApplicationJSON() {
        Matcher[] matcherArray = new Matcher[]{(Matcher)mediaTypeMatcher};
        MockRestRequestMatchers.header((String)"Accept", (Matcher[])matcherArray).match((ClientHttpRequest)this.request);
    }

    public final void headerDoesNotExist(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MockRestRequestMatchers.headerDoesNotExist((String)name).match((ClientHttpRequest)this.request);
    }

    public final void requestJSON(@NotNull Function1<? super JSONExpect, Unit> tests) {
        Intrinsics.checkNotNullParameter(tests, (String)"tests");
        Object object = new Matcher[]{(Matcher)mediaTypeMatcher};
        MockRestRequestMatchers.header((String)"Content-Type", (Matcher[])object).match((ClientHttpRequest)this.request);
        object = this.request.getBodyAsString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"request.bodyAsString");
        JSONExpect.Companion.expectJSON((String)object, tests);
    }

    public /* synthetic */ JSONMockServerDSL(MockClientHttpRequest request, DefaultConstructorMarker $constructor_marker) {
        this(request);
    }

    static {
        MediaType mediaType = MediaType.APPLICATION_JSON;
        Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"APPLICATION_JSON");
        mediaTypeMatcher = new MediaTypeMatcher(mediaType);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J9\u0010\u0015\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J9\u0010\u0016\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/kjson/spring/test/JSONMockServerDSL$Companion;", "", "()V", "mediaTypeMatcher", "Lio/kjson/spring/test/MediaTypeMatcher;", "getMediaTypeMatcher", "()Lio/kjson/spring/test/MediaTypeMatcher;", "mock", "Lorg/springframework/test/web/client/ResponseActions;", "Lorg/springframework/test/web/client/MockRestServiceServer;", "expectedCount", "Lorg/springframework/test/web/client/ExpectedCount;", "method", "Lorg/springframework/http/HttpMethod;", "uri", "Ljava/net/URI;", "block", "Lkotlin/Function1;", "Lio/kjson/spring/test/JSONMockServerDSL;", "", "Lkotlin/ExtensionFunctionType;", "mockGet", "mockPost", "kjson-spring-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaTypeMatcher getMediaTypeMatcher() {
            return mediaTypeMatcher;
        }

        @NotNull
        public final ResponseActions mock(@NotNull MockRestServiceServer $this$mock, @NotNull ExpectedCount expectedCount, @Nullable HttpMethod method, @Nullable URI uri, @NotNull Function1<? super JSONMockServerDSL, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$mock, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expectedCount, (String)"expectedCount");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            ResponseActions responseActions = $this$mock.expect(expectedCount, arg_0 -> Companion.mock$lambda-3(method, uri, block, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)responseActions, (String)"expect(expectedCount) { \u2026          }\n            }");
            return responseActions;
        }

        public static /* synthetic */ ResponseActions mock$default(Companion companion, MockRestServiceServer mockRestServiceServer, ExpectedCount expectedCount, HttpMethod httpMethod, URI uRI, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                ExpectedCount expectedCount2 = ExpectedCount.once();
                Intrinsics.checkNotNullExpressionValue((Object)expectedCount2, (String)"once()");
                expectedCount = expectedCount2;
            }
            if ((n & 2) != 0) {
                httpMethod = null;
            }
            if ((n & 4) != 0) {
                uRI = null;
            }
            return companion.mock(mockRestServiceServer, expectedCount, httpMethod, uRI, (Function1<? super JSONMockServerDSL, Unit>)function1);
        }

        @NotNull
        public final ResponseActions mockGet(@NotNull MockRestServiceServer $this$mockGet, @NotNull ExpectedCount expectedCount, @Nullable URI uri, @NotNull Function1<? super JSONMockServerDSL, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$mockGet, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expectedCount, (String)"expectedCount");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.mock($this$mockGet, expectedCount, HttpMethod.GET, uri, block);
        }

        public static /* synthetic */ ResponseActions mockGet$default(Companion companion, MockRestServiceServer mockRestServiceServer, ExpectedCount expectedCount, URI uRI, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                ExpectedCount expectedCount2 = ExpectedCount.once();
                Intrinsics.checkNotNullExpressionValue((Object)expectedCount2, (String)"once()");
                expectedCount = expectedCount2;
            }
            if ((n & 2) != 0) {
                uRI = null;
            }
            return companion.mockGet(mockRestServiceServer, expectedCount, uRI, (Function1<? super JSONMockServerDSL, Unit>)function1);
        }

        @NotNull
        public final ResponseActions mockPost(@NotNull MockRestServiceServer $this$mockPost, @NotNull ExpectedCount expectedCount, @Nullable URI uri, @NotNull Function1<? super JSONMockServerDSL, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$mockPost, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expectedCount, (String)"expectedCount");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.mock($this$mockPost, expectedCount, HttpMethod.POST, uri, block);
        }

        public static /* synthetic */ ResponseActions mockPost$default(Companion companion, MockRestServiceServer mockRestServiceServer, ExpectedCount expectedCount, URI uRI, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                ExpectedCount expectedCount2 = ExpectedCount.once();
                Intrinsics.checkNotNullExpressionValue((Object)expectedCount2, (String)"once()");
                expectedCount = expectedCount2;
            }
            if ((n & 2) != 0) {
                uRI = null;
            }
            return companion.mockPost(mockRestServiceServer, expectedCount, uRI, (Function1<? super JSONMockServerDSL, Unit>)function1);
        }

        private static final void mock$lambda-3(HttpMethod $method, URI $uri, Function1 $block, ClientHttpRequest request) {
            Object it;
            JSONMockServerDSL jSONMockServerDSL;
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            ClientHttpRequest clientHttpRequest = request;
            if (clientHttpRequest == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.springframework.mock.http.client.MockClientHttpRequest");
            }
            JSONMockServerDSL $this$mock_u24lambda_u2d3_u24lambda_u2d2 = jSONMockServerDSL = new JSONMockServerDSL((MockClientHttpRequest)clientHttpRequest, null);
            boolean bl = false;
            HttpMethod httpMethod = $method;
            if (httpMethod != null) {
                it = httpMethod;
                boolean bl2 = false;
                $this$mock_u24lambda_u2d3_u24lambda_u2d2.method((HttpMethod)it);
            }
            URI uRI = $uri;
            if (uRI != null) {
                it = uRI;
                boolean bl3 = false;
                $this$mock_u24lambda_u2d3_u24lambda_u2d2.requestTo((URI)it);
            }
            $block.invoke((Object)$this$mock_u24lambda_u2d3_u24lambda_u2d2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

