/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.ktor;

import io.kjson.JSONConfig;
import io.kjson.JSONDeserializer;
import io.kjson.JSONStreamer;
import io.kjson.JSONValue;
import io.kjson.ktor.JSONKtorException;
import io.kjson.ktor.JSONKtorFunctionsKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.Headers;
import io.ktor.http.HttpStatusCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import net.pwall.pipeline.AbstractIntPipeline;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.StringAcceptor;
import net.pwall.pipeline.codec.DecoderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lio/kjson/ktor/JSONKtorClientException;", "Lio/kjson/ktor/JSONKtorException;", "urlString", "", "statusCode", "Lio/ktor/http/HttpStatusCode;", "responseHeaders", "Lio/ktor/http/Headers;", "responseBody", "", "config", "Lio/kjson/JSONConfig;", "(Ljava/lang/String;Lio/ktor/http/HttpStatusCode;Lio/ktor/http/Headers;[BLio/kjson/JSONConfig;)V", "getConfig", "()Lio/kjson/JSONConfig;", "getResponseBody", "()[B", "getResponseHeaders", "()Lio/ktor/http/Headers;", "getStatusCode", "()Lio/ktor/http/HttpStatusCode;", "getUrlString", "()Ljava/lang/String;", "body", "T", "", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KType;", "(Lkotlin/reflect/KType;)Ljava/lang/Object;", "bodyAsString", "kjson-ktor"})
public final class JSONKtorClientException
extends JSONKtorException {
    @NotNull
    private final String urlString;
    @NotNull
    private final HttpStatusCode statusCode;
    @NotNull
    private final Headers responseHeaders;
    @Nullable
    private final byte[] responseBody;
    @NotNull
    private final JSONConfig config;

    public JSONKtorClientException(@NotNull String urlString, @NotNull HttpStatusCode statusCode, @NotNull Headers responseHeaders, @Nullable byte[] responseBody, @NotNull JSONConfig config) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
        Intrinsics.checkNotNullParameter((Object)responseHeaders, (String)"responseHeaders");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super("Unexpected response status (" + statusCode + ") - " + urlString);
        this.urlString = urlString;
        this.statusCode = statusCode;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.config = config;
    }

    @NotNull
    public final String getUrlString() {
        return this.urlString;
    }

    @NotNull
    public final HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    @Nullable
    public final byte[] getResponseBody() {
        return this.responseBody;
    }

    @NotNull
    public final JSONConfig getConfig() {
        return this.config;
    }

    public final /* synthetic */ <T> T body() {
        boolean $i$f$body = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return this.body(null);
    }

    @Nullable
    public final <T> T body(@NotNull KType type) {
        HeaderValue parsedContentTypeHeader;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.responseBody == null) {
            return null;
        }
        HeaderValue headerValue = parsedContentTypeHeader = JSONKtorFunctionsKt.parsedContentTypeHeader(this.responseHeaders);
        if (!Intrinsics.areEqual((Object)(headerValue != null ? headerValue.getValue() : null), (Object)JSONKtorFunctionsKt.getApplicationJSONString())) {
            throw new JSONKtorException("Content-Type not " + JSONKtorFunctionsKt.getApplicationJSONString() + " - " + this.urlString);
        }
        String string = JSONKtorFunctionsKt.getParam(parsedContentTypeHeader, "charset");
        if (string == null) {
            string = this.config.getCharset().name();
        }
        String charsetName = string;
        AbstractIntPipeline pipeline2 = DecoderFactory.getDecoder((String)charsetName, (IntAcceptor)((IntAcceptor)new JSONStreamer(this.config.getParseOptions())));
        pipeline2.accept(this.responseBody);
        return (T)JSONDeserializer.INSTANCE.deserialize(type, (JSONValue)pipeline2.getResult(), this.config);
    }

    @Nullable
    public final String bodyAsString() {
        if (this.responseBody == null) {
            return null;
        }
        HeaderValue parsedContentTypeHeader = JSONKtorFunctionsKt.parsedContentTypeHeader(this.responseHeaders);
        Object object = parsedContentTypeHeader;
        if (object == null || (object = JSONKtorFunctionsKt.getParam(object, "charset")) == null) {
            object = this.config.getCharset().name();
        }
        Object charsetName = object;
        AbstractIntPipeline pipeline2 = DecoderFactory.getDecoder((String)charsetName, (IntAcceptor)((IntAcceptor)new StringAcceptor(this.responseBody.length)));
        pipeline2.accept(this.responseBody);
        return (String)pipeline2.getResult();
    }
}

