/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONPrimitive;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 M2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001MB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\r\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\b\u0010%\u001a\u00020\u001bH\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\u001bH\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\b\u0010)\u001a\u00020\u001bH\u0016J\b\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\b\u0010,\u001a\u00020\u001bH\u0016J\b\u0010-\u001a\u00020\u001bH\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0003H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u000bH\u0016J\b\u00108\u001a\u00020\u0005H\u0016J\b\u00109\u001a\u00020\bH\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\u0018\u0010=\u001a\u00020>H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b?\u0010@J\u0018\u0010A\u001a\u00020BH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bC\u0010DJ\u0018\u0010E\u001a\u00020FH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bG\u0010HJ\u0018\u0010I\u001a\u00020JH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bK\u0010LR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006N"}, d2={"Lio/kjson/JSONDecimal;", "Lio/kjson/JSONNumber;", "Lio/kjson/JSONPrimitive;", "Ljava/math/BigDecimal;", "str", "", "(Ljava/lang/String;)V", "long", "", "(J)V", "int", "", "(I)V", "value", "(Ljava/math/BigDecimal;)V", "asDecimal", "getAsDecimal", "()Ljava/math/BigDecimal;", "asDecimalOrNull", "getAsDecimalOrNull", "getValue", "appendTo", "", "a", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "equals", "", "other", "", "hashCode", "isByte", "isInt", "isIntegral", "isLong", "isNegative", "isNotNegative", "isNotPositive", "isNotZero", "isPositive", "isShort", "isUByte", "isUInt", "isULong", "isUShort", "isZero", "toByte", "", "toChar", "", "toDecimal", "toDouble", "", "toFloat", "", "toInt", "toJSON", "toLong", "toShort", "", "toString", "toUByte", "Lkotlin/UByte;", "toUByte-w2LRezQ", "()B", "toUInt", "Lkotlin/UInt;", "toUInt-pVg5ArA", "()I", "toULong", "Lkotlin/ULong;", "toULong-s-VKNKU", "()J", "toUShort", "Lkotlin/UShort;", "toUShort-Mh2AYeg", "()S", "Companion", "kjson-core"})
public final class JSONDecimal
extends JSONNumber
implements JSONPrimitive<BigDecimal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal value;
    @NotNull
    private static final JSONDecimal ZERO;
    @NotNull
    private static final BigDecimal MIN_LONG;
    @NotNull
    private static final BigDecimal MAX_LONG;
    @NotNull
    private static final BigDecimal MIN_INT;
    @NotNull
    private static final BigDecimal MAX_INT;
    @NotNull
    private static final BigDecimal MIN_SHORT;
    @NotNull
    private static final BigDecimal MAX_SHORT;
    @NotNull
    private static final BigDecimal MIN_BYTE;
    @NotNull
    private static final BigDecimal MAX_BYTE;
    @NotNull
    private static final BigDecimal MAX_ULONG;
    @NotNull
    private static final BigDecimal MAX_UINT;
    @NotNull
    private static final BigDecimal MAX_USHORT;
    @NotNull
    private static final BigDecimal MAX_UBYTE;

    public JSONDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(null);
        this.value = value;
    }

    @Override
    @NotNull
    public BigDecimal getValue() {
        return this.value;
    }

    public JSONDecimal(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(new BigDecimal(str));
    }

    public JSONDecimal(long l) {
        this(new BigDecimal(l));
    }

    public JSONDecimal(int n) {
        this(new BigDecimal(n));
    }

    @Override
    @NotNull
    public String toJSON() {
        String string = this.getValue().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        return string;
    }

    @Override
    public void appendTo(@NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        a.append(this.getValue().toString());
    }

    @Override
    public boolean isIntegral() {
        return this.getValue().scale() <= 0 || this.getValue().remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLong() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = MIN_LONG;
        BigDecimal bigDecimal2 = MAX_LONG;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInt() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = MIN_INT;
        BigDecimal bigDecimal2 = MAX_INT;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShort() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = MIN_SHORT;
        BigDecimal bigDecimal2 = MAX_SHORT;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isByte() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = MIN_BYTE;
        BigDecimal bigDecimal2 = MAX_BYTE;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isULong() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = MAX_ULONG;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUInt() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = MAX_UINT;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUShort() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = MAX_USHORT;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUByte() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = MAX_UBYTE;
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    @Override
    public boolean isZero() {
        return this.getValue().compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public boolean isNegative() {
        return this.getValue().compareTo(BigDecimal.ZERO) < 0;
    }

    @Override
    public boolean isPositive() {
        return this.getValue().compareTo(BigDecimal.ZERO) > 0;
    }

    @Override
    public boolean isNotZero() {
        return this.getValue().compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public boolean isNotNegative() {
        return this.getValue().compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public boolean isNotPositive() {
        return this.getValue().compareTo(BigDecimal.ZERO) <= 0;
    }

    @Override
    public double toDouble() {
        return this.getValue().doubleValue();
    }

    @Override
    public float toFloat() {
        return this.getValue().floatValue();
    }

    @Override
    public long toLong() {
        return this.getValue().longValue();
    }

    @Override
    public int toInt() {
        return this.getValue().intValue();
    }

    public char toChar() {
        return this.getValue().toChar();
    }

    @Override
    public short toShort() {
        return this.getValue().shortValue();
    }

    @Override
    public byte toByte() {
        return this.getValue().byteValue();
    }

    @Override
    @NotNull
    public BigDecimal toDecimal() {
        return this.getValue();
    }

    @Override
    public long toULong-s-VKNKU() {
        return ULong.constructor-impl((long)this.getValue().longValue());
    }

    @Override
    public int toUInt-pVg5ArA() {
        return UInt.constructor-impl((int)this.getValue().intValue());
    }

    @Override
    public short toUShort-Mh2AYeg() {
        return UShort.constructor-impl((short)((short)this.getValue().intValue()));
    }

    @Override
    public byte toUByte-w2LRezQ() {
        return UByte.constructor-impl((byte)((byte)this.getValue().intValue()));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONNumber)) {
            return false;
        }
        JSONNumber jSONNumber = (JSONNumber)other;
        if (jSONNumber instanceof JSONInt) {
            bl = this.getValue().compareTo(new BigDecimal(((JSONInt)other).getValue())) == 0;
        } else if (jSONNumber instanceof JSONLong) {
            bl = this.getValue().compareTo(new BigDecimal(((JSONLong)other).getValue())) == 0;
        } else if (jSONNumber instanceof JSONDecimal) {
            bl = this.getValue().compareTo(((JSONDecimal)other).getValue()) == 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.getValue().intValue();
    }

    @NotNull
    public String toString() {
        return this.toJSON();
    }

    @NotNull
    public final BigDecimal getAsDecimal() {
        return this.getValue();
    }

    @NotNull
    public final BigDecimal getAsDecimalOrNull() {
        return this.getValue();
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        ZERO = new JSONDecimal(bigDecimal);
        MIN_LONG = new BigDecimal(Long.MIN_VALUE);
        MAX_LONG = new BigDecimal(Long.MAX_VALUE);
        MIN_INT = new BigDecimal(Integer.MIN_VALUE);
        MAX_INT = new BigDecimal(Integer.MAX_VALUE);
        MIN_SHORT = new BigDecimal(Short.MIN_VALUE);
        MAX_SHORT = new BigDecimal(Short.MAX_VALUE);
        MIN_BYTE = new BigDecimal(-128);
        MAX_BYTE = new BigDecimal(127);
        BigDecimal bigDecimal2 = MAX_LONG.add(MAX_LONG);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.add(other)");
        BigDecimal bigDecimal3 = bigDecimal2;
        BigDecimal bigDecimal4 = BigDecimal.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"ONE");
        BigDecimal bigDecimal5 = bigDecimal3.add(bigDecimal4);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"this.add(other)");
        MAX_ULONG = bigDecimal5;
        MAX_UINT = new BigDecimal((long)-1 & 0xFFFFFFFFL);
        MAX_USHORT = new BigDecimal(0xFFFFFFFF & 0xFFFF);
        MAX_UBYTE = new BigDecimal(0xFFFFFFFF & 0xFF);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0018J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lio/kjson/JSONDecimal$Companion;", "", "()V", "MAX_BYTE", "Ljava/math/BigDecimal;", "MAX_INT", "MAX_LONG", "MAX_SHORT", "MAX_UBYTE", "MAX_UINT", "MAX_ULONG", "MAX_USHORT", "MIN_BYTE", "MIN_INT", "MIN_LONG", "MIN_SHORT", "ZERO", "Lio/kjson/JSONDecimal;", "getZERO", "()Lio/kjson/JSONDecimal;", "of", "d", "i", "", "", "s", "", "kjson-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONDecimal getZERO() {
            return ZERO;
        }

        @NotNull
        public final JSONDecimal of(@NotNull BigDecimal d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return Intrinsics.areEqual((Object)d, (Object)BigDecimal.ZERO) ? this.getZERO() : new JSONDecimal(d);
        }

        @NotNull
        public final JSONDecimal of(int i) {
            return i == 0 ? this.getZERO() : new JSONDecimal(i);
        }

        @NotNull
        public final JSONDecimal of(long i) {
            return i == 0L ? this.getZERO() : new JSONDecimal(i);
        }

        @NotNull
        public final JSONDecimal of(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return Intrinsics.areEqual((Object)s, (Object)"0") ? this.getZERO() : new JSONDecimal(s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

