/*
 * @(#) JSONNumberValue.kt
 *
 * kjson-core  JSON Kotlin core functionality
 * Copyright (c) 2021, 2022 Peter Wall
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package io.kjson

import java.math.BigDecimal

/**
 * An abstract base class for the three number types of JSON value.  It includes functions to assist with conversion
 * between number types.
 *
 * @author  Peter Wall
 */
abstract class JSONNumberValue internal constructor() : Number() {

    abstract val value: Number

    abstract fun isIntegral(): Boolean

    abstract fun isLong(): Boolean

    abstract fun isInt(): Boolean

    abstract fun isShort(): Boolean

    abstract fun isByte(): Boolean

    abstract fun isULong(): Boolean

    abstract fun isUInt(): Boolean

    abstract fun isUShort(): Boolean

    abstract fun isUByte(): Boolean

    abstract fun isZero(): Boolean

    abstract fun isNegative(): Boolean

    abstract fun isPositive(): Boolean

    abstract fun isNotZero(): Boolean

    abstract fun isNotNegative(): Boolean

    abstract fun isNotPositive(): Boolean

    abstract fun toDecimal(): BigDecimal

    abstract fun toULong(): ULong

    abstract fun toUInt(): UInt

    abstract fun toUShort(): UShort

    abstract fun toUByte(): UByte

}
