/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONNumberValue;
import io.kjson.JSONValue;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\nH\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lio/kjson/JSONDecimal;", "Lio/kjson/JSONNumberValue;", "Lio/kjson/JSONValue;", "str", "", "(Ljava/lang/String;)V", "long", "", "(J)V", "int", "", "(I)V", "value", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "getValue", "()Ljava/math/BigDecimal;", "appendTo", "", "a", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "equals", "", "other", "", "hashCode", "isByte", "isInt", "isIntegral", "isLong", "isShort", "toByte", "", "toChar", "", "toDecimal", "toDouble", "", "toFloat", "", "toInt", "toJSON", "toLong", "toShort", "", "toString", "Companion", "kjson-core"})
public final class JSONDecimal
extends JSONNumberValue
implements JSONValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal value;
    @NotNull
    private static final JSONDecimal ZERO;

    public JSONDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @Override
    @NotNull
    public BigDecimal getValue() {
        return this.value;
    }

    public JSONDecimal(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(new BigDecimal(str));
    }

    public JSONDecimal(long l) {
        this(new BigDecimal(l));
    }

    public JSONDecimal(int n) {
        this(new BigDecimal(n));
    }

    @Override
    @NotNull
    public String toJSON() {
        String string = this.getValue().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        return string;
    }

    @Override
    public void appendTo(@NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        a.append(this.getValue().toString());
    }

    @Override
    public boolean isIntegral() {
        return this.getValue().scale() <= 0 || this.getValue().remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLong() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = new BigDecimal(Long.MIN_VALUE);
        BigDecimal bigDecimal2 = new BigDecimal(Long.MAX_VALUE);
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInt() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = new BigDecimal(Integer.MIN_VALUE);
        BigDecimal bigDecimal2 = new BigDecimal(Integer.MAX_VALUE);
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShort() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = new BigDecimal(Short.MIN_VALUE);
        BigDecimal bigDecimal2 = new BigDecimal(Short.MAX_VALUE);
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isByte() {
        if (!this.isIntegral()) return false;
        BigDecimal bigDecimal = new BigDecimal(-128);
        BigDecimal bigDecimal2 = new BigDecimal(127);
        BigDecimal bigDecimal3 = this.getValue();
        if (0 > bigDecimal3.compareTo((Object)bigDecimal)) return false;
        if (bigDecimal3.compareTo((Object)bigDecimal2) > 0) return false;
        return true;
    }

    @Override
    public double toDouble() {
        return this.getValue().doubleValue();
    }

    @Override
    public float toFloat() {
        return this.getValue().floatValue();
    }

    @Override
    public long toLong() {
        return this.getValue().longValue();
    }

    @Override
    public int toInt() {
        return this.getValue().intValue();
    }

    public char toChar() {
        return this.getValue().toChar();
    }

    @Override
    public short toShort() {
        return this.getValue().shortValue();
    }

    @Override
    public byte toByte() {
        return this.getValue().byteValue();
    }

    @Override
    @NotNull
    public BigDecimal toDecimal() {
        return this.getValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONValue)) {
            return false;
        }
        JSONValue jSONValue = (JSONValue)other;
        return jSONValue instanceof JSONInt ? this.getValue().compareTo(new BigDecimal(((JSONInt)other).getValue())) == 0 : (jSONValue instanceof JSONLong ? this.getValue().compareTo(new BigDecimal(((JSONLong)other).getValue())) == 0 : (jSONValue instanceof JSONDecimal ? this.getValue().compareTo(((JSONDecimal)other).getValue()) == 0 : false));
    }

    public int hashCode() {
        return this.getValue().intValue();
    }

    @NotNull
    public String toString() {
        return this.toJSON();
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        ZERO = new JSONDecimal(bigDecimal);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/kjson/JSONDecimal$Companion;", "", "()V", "ZERO", "Lio/kjson/JSONDecimal;", "getZERO", "()Lio/kjson/JSONDecimal;", "of", "d", "Ljava/math/BigDecimal;", "kjson-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONDecimal getZERO() {
            return ZERO;
        }

        @NotNull
        public final JSONDecimal of(@NotNull BigDecimal d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return Intrinsics.areEqual((Object)d, (Object)BigDecimal.ZERO) ? this.getZERO() : new JSONDecimal(d);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

