/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONException;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.Parser;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nJ\u000e\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\fJ\u000e\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000eJ\u001c\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018*\u00060\u0017j\u0002`\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0019\u001a\u00020\u001a*\u0004\u0018\u00010\u00102\n\u0010\u001b\u001a\u00060\u0017j\u0002`\u0018J\f\u0010\u001c\u001a\u00020\u000e*\u0004\u0018\u00010\u0010\u00a8\u0006\u001d"}, d2={"Lio/kjson/JSON;", "", "()V", "of", "Lio/kjson/JSONDecimal;", "value", "Ljava/math/BigDecimal;", "Lio/kjson/JSONBoolean;", "", "Lio/kjson/JSONInt;", "", "Lio/kjson/JSONLong;", "", "Lio/kjson/JSONString;", "", "parse", "Lio/kjson/JSONValue;", "json", "parseArray", "Lio/kjson/JSONArray;", "parseObject", "Lio/kjson/JSONObject;", "appendJSON", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendTo", "", "a", "toJSON", "kjson-core"})
public final class JSON {
    @NotNull
    public static final JSON INSTANCE = new JSON();

    private JSON() {
    }

    @NotNull
    public final JSONInt of(int value) {
        return JSONInt.Companion.of(value);
    }

    @NotNull
    public final JSONLong of(long value) {
        return JSONLong.Companion.of(value);
    }

    @NotNull
    public final JSONDecimal of(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return JSONDecimal.Companion.of(value);
    }

    @NotNull
    public final JSONString of(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return JSONString.Companion.of(value);
    }

    @NotNull
    public final JSONBoolean of(boolean value) {
        return JSONBoolean.Companion.of(value);
    }

    @Nullable
    public final JSONValue parse(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return Parser.INSTANCE.parse(json);
    }

    @NotNull
    public final String toJSON(@Nullable JSONValue $this$toJSON) {
        String string;
        JSONValue jSONValue = $this$toJSON;
        return jSONValue == null ? "null" : ((string = jSONValue.toJSON()) == null ? "null" : string);
    }

    public final void appendTo(@Nullable JSONValue $this$appendTo, @NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if ($this$appendTo == null) {
            a.append("null");
        } else {
            $this$appendTo.appendTo(a);
        }
    }

    @NotNull
    public final Appendable appendJSON(@NotNull Appendable $this$appendJSON, @Nullable JSONValue json) {
        Intrinsics.checkNotNullParameter((Object)$this$appendJSON, (String)"<this>");
        Appendable appendable = $this$appendJSON;
        boolean bl = false;
        boolean bl2 = false;
        Appendable $this$appendJSON_u24lambda_u2d0 = appendable;
        boolean bl3 = false;
        if (json == null) {
            $this$appendJSON_u24lambda_u2d0.append("null");
        } else {
            json.appendTo($this$appendJSON_u24lambda_u2d0);
        }
        return appendable;
    }

    @NotNull
    public final JSONObject parseObject(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JSONValue result = this.parse(json);
        if (!(result instanceof JSONObject)) {
            throw new JSONException("JSON is not an object");
        }
        return (JSONObject)result;
    }

    @NotNull
    public final JSONArray parseArray(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JSONValue result = this.parse(json);
        if (!(result instanceof JSONArray)) {
            throw new JSONException("JSON is not an array");
        }
        return (JSONArray)result;
    }
}

