package io.apisdk.example.yaml;

import com.microsoft.kiota.ApiClientBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.serialization.FormParseNodeFactory;
import com.microsoft.kiota.serialization.FormSerializationWriterFactory;
import com.microsoft.kiota.serialization.MultipartSerializationWriterFactory;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import com.microsoft.kiota.serialization.SerializationWriterFactoryRegistry;
import com.microsoft.kiota.serialization.TextParseNodeFactory;
import com.microsoft.kiota.serialization.TextSerializationWriterFactory;
import io.apisdk.example.yaml.quarkuskiota.QuarkusKiotaRequestBuilder;
import io.kiota.serialization.json.quarkus.JsonParseNodeFactory;
import io.kiota.serialization.json.quarkus.JsonSerializationWriterFactory;
import java.util.HashMap;
import java.util.Objects;
import io.quarkus.arc.Arc;

/**
 * The main entry point of the SDK, exposes the configuration and the fluent API.
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class ApiClient extends BaseRequestBuilder {

    /**
     * The quarkusKiota property
     */
    @jakarta.annotation.Nonnull
    public QuarkusKiotaRequestBuilder quarkusKiota() {
        return new QuarkusKiotaRequestBuilder(pathParameters, requestAdapter);
    }

    /**
     * Instantiates a new ApiClient and sets the default values.
     * @param requestAdapter The request adapter to use to execute the requests.
     */
    public ApiClient(@jakarta.annotation.Nonnull final RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}");
        JsonSerializationWriterFactory jsonSerializationWriterFactory = Arc.container().instance(JsonSerializationWriterFactory.class).get();
        JsonParseNodeFactory jsonParseNodeFactory = Arc.container().instance(JsonParseNodeFactory.class).get();
        this.pathParameters = new HashMap<>();
        SerializationWriterFactoryRegistry.defaultInstance.contentTypeAssociatedFactories.put(jsonSerializationWriterFactory.getValidContentType(),  jsonSerializationWriterFactory);
        ApiClientBuilder.registerDefaultSerializer(() -> new TextSerializationWriterFactory());
        ApiClientBuilder.registerDefaultSerializer(() -> new FormSerializationWriterFactory());
        ApiClientBuilder.registerDefaultSerializer(() -> new MultipartSerializationWriterFactory());
        ParseNodeFactoryRegistry.defaultInstance.contentTypeAssociatedFactories.put(jsonParseNodeFactory.getValidContentType(), jsonParseNodeFactory);
        ApiClientBuilder.registerDefaultDeserializer(() -> new TextParseNodeFactory());
        ApiClientBuilder.registerDefaultDeserializer(() -> new FormParseNodeFactory());
    }
}
