/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.quarkus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.logging.Log;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.utilities.OS;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

@ConfigRoot(name="kiota", phase=ConfigPhase.BUILD_TIME)
public class KiotaCodeGenConfig {
    static final String KIOTA_CONFIG_PREFIX = "quarkus.kiota";
    private static final String OS = "quarkus.kiota.os";
    private static final String ARCH = "quarkus.kiota.arch";
    private static final String PROVIDED = "quarkus.kiota.provided";
    private static final String DEFAULT_RELEASE_URL = "https://github.com/microsoft/kiota/releases";
    private static final String RELEASE_URL = "quarkus.kiota.release.url";
    private static final String VERSION = "quarkus.kiota.version";
    private static final int DEFAULT_TIMEOUT = 30;
    private static final String TIMEOUT = "quarkus.kiota.timeout";
    private static final String DEFAULT_CLIENT_NAME = "ApiClient";
    private static final String CLIENT_CLASS_NAME = ".class-name";
    private static final String DEFAULT_CLIENT_PACKAGE = "io.apisdk";
    private static final String CLIENT_PACKAGE_NAME = ".package-name";
    private static final String INCLUDE_PATH = ".include-path";
    private static final String EXCLUDE_PATH = ".exclude-path";
    private static final List<String> DEFAULT_SERIALIZER = List.of("io.kiota.serialization.json.quarkus.JsonSerializationWriterFactory", "com.microsoft.kiota.serialization.TextSerializationWriterFactory", "com.microsoft.kiota.serialization.FormSerializationWriterFactory", "com.microsoft.kiota.serialization.MultipartSerializationWriterFactory");
    private static final String SERIALIZER = ".serializer";
    private static final List<String> DEFAULT_DESERIALIZER = List.of("io.kiota.serialization.json.quarkus.JsonParseNodeFactory", "com.microsoft.kiota.serialization.TextParseNodeFactory", "com.microsoft.kiota.serialization.FormParseNodeFactory");
    private static final String DESERIALIZER = ".deserializer";
    @ConfigItem(name="os")
    public Optional<String> os;
    @ConfigItem(name="arch")
    public Optional<String> arch;
    @ConfigItem(name="provided")
    public Optional<String> provided;
    @ConfigItem(name="release.url", defaultValue="https://github.com/microsoft/kiota/releases")
    public Optional<String> releaseUrl;
    @ConfigItem(name="version")
    public Optional<String> version;
    @ConfigItem(name="timeout", defaultValue="30")
    public Optional<String> timeout;
    @ConfigItem(name="spec-name")
    public Optional<SpecConfig> specName;

    public static OS getOs(Config config) {
        String os = config.getConfigValue(OS).getValue();
        if (os == null) {
            return io.quarkus.utilities.OS.determineOS();
        }
        return io.quarkus.utilities.OS.valueOf((String)os);
    }

    public static String getArch(Config config) {
        String arch = config.getConfigValue(ARCH).getValue();
        if (arch == null) {
            return io.quarkus.utilities.OS.getArchitecture();
        }
        return arch;
    }

    public static String getProvided(Config config) {
        return config.getConfigValue(PROVIDED).getValue();
    }

    public static String getReleaseUrl(Config config) {
        String releaseUrl = config.getConfigValue(RELEASE_URL).getValue();
        if (releaseUrl != null) {
            return releaseUrl;
        }
        return DEFAULT_RELEASE_URL;
    }

    public static String getVersion(Config config) {
        String version = config.getConfigValue(VERSION).getValue();
        if (version == null) {
            Log.warn((Object)"No Kiota version specified, trying to retrieve it from the GitHub API");
            try {
                URI releaseURI = new URI(KiotaCodeGenConfig.getReleaseUrl(config));
                URI latestVersionURI = new URI(releaseURI.getScheme(), "api." + releaseURI.getHost(), "/repos" + releaseURI.getPath() + "/latest", releaseURI.getFragment());
                HttpRequest request = HttpRequest.newBuilder().uri(latestVersionURI).GET().build();
                HttpResponse<String> response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    Log.warn((Object)"Failed to retrieve the latest Kiota version, please provide it explicitly.");
                    return null;
                }
                ObjectMapper mapper = new ObjectMapper();
                JsonNode latestVersionJson = mapper.readTree(response.body());
                String latestVersion = latestVersionJson.get("name").asText();
                if (latestVersion.startsWith("v")) {
                    latestVersion = latestVersion.substring(1);
                }
                return latestVersion;
            }
            catch (URISyntaxException e) {
                Log.warn((Object)"Failed to retrieve the latest Kiota version, please provide it explicitly.", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                Log.warn((Object)"Failed to retrieve the latest Kiota version, please provide it explicitly.", (Throwable)e);
                return null;
            }
            catch (InterruptedException e) {
                Log.warn((Object)"Failed to retrieve the latest Kiota version, please provide it explicitly.", (Throwable)e);
                return null;
            }
        }
        return version;
    }

    public static int getTimeout(Config config) {
        String timeout = config.getConfigValue(TIMEOUT).getValue();
        if (timeout != null) {
            return Integer.valueOf(timeout);
        }
        return 30;
    }

    public static String getClientClassName(Config config, String filename) {
        String clientName = config.getConfigValue("quarkus.kiota." + filename + CLIENT_CLASS_NAME).getValue();
        if (clientName != null) {
            return clientName;
        }
        return DEFAULT_CLIENT_NAME;
    }

    public static String getClientPackageName(Config config, String filename) {
        String packageName = config.getConfigValue("quarkus.kiota." + filename + CLIENT_PACKAGE_NAME).getValue();
        if (packageName != null) {
            return packageName;
        }
        return "io.apisdk." + filename;
    }

    public static String getIncludePath(Config config, String filename) {
        return config.getConfigValue("quarkus.kiota." + filename + INCLUDE_PATH).getValue();
    }

    public static String getExcludePath(Config config, String filename) {
        return config.getConfigValue("quarkus.kiota." + filename + EXCLUDE_PATH).getValue();
    }

    public static List<String> getSerializer(Config config, String filename) {
        String serializer = config.getConfigValue("quarkus.kiota." + filename + SERIALIZER).getValue();
        if (serializer != null) {
            return List.of(serializer.split(","));
        }
        return DEFAULT_SERIALIZER;
    }

    public static List<String> getDeserializer(Config config, String filename) {
        String deserializer = config.getConfigValue("quarkus.kiota." + filename + DESERIALIZER).getValue();
        if (deserializer != null) {
            return List.of(deserializer.split(","));
        }
        return DEFAULT_DESERIALIZER;
    }

    @ConfigGroup
    public static final class SpecConfig {
        @ConfigItem(name="class-name", defaultValue="ApiClient")
        public Optional<String> className;
        @ConfigItem(name="package-name", defaultValue="io.apisdk")
        public Optional<String> packageName;
        @ConfigItem(name="include-path")
        public Optional<String> includePath;
        @ConfigItem(name="exclude-path")
        public Optional<String> excludePath;
        @ConfigItem(name="serializer")
        public Optional<List<String>> serializer;
        @ConfigItem(name="deserializer")
        public Optional<List<String>> deserializer;
    }
}

