/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.quarkus.deployment;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.utils.SourceRoot;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Collectors;

public class FixClientClass {
    private final String clientName;
    private final String packageName;
    private final Path generatedSourceFolder;

    public FixClientClass(String clientName, String packageName, Path generatedSourceFolder) {
        this.clientName = clientName;
        this.packageName = packageName;
        this.generatedSourceFolder = generatedSourceFolder;
    }

    public void fix() throws IOException {
        SourceRoot source = new SourceRoot(this.generatedSourceFolder);
        ParseResult parsed = source.tryToParse(this.packageName, this.clientName + ".java");
        if (!parsed.isSuccessful() || parsed.getResult().isEmpty()) {
            throw new RuntimeException("Found issues while parsing the Client library, problems:\n" + parsed.getProblems().stream().map(p -> p.getVerboseMessage()).collect(Collectors.joining("\n")));
        }
        CompilationUnit cu = (CompilationUnit)parsed.getResult().get();
        ClassOrInterfaceDeclaration clientClass = (ClassOrInterfaceDeclaration)((CompilationUnit)parsed.getResult().get()).getClassByName(this.clientName).get();
        BlockStmt constructorBody = ((ConstructorDeclaration)clientClass.getConstructors().get(0)).getBody();
        cu.addImport("io.quarkus.arc.Arc");
        NodeList statements = constructorBody.getStatements();
        for (int i = 0; i < statements.size(); ++i) {
            Statement stmt = (Statement)statements.get(i);
            if (stmt.toString().contains("JsonSerializationWriterFactory")) {
                constructorBody.setStatement(i, (Statement)new ExpressionStmt((Expression)new NameExpr("SerializationWriterFactoryRegistry.defaultInstance.contentTypeAssociatedFactories.put(jsonSerializationWriterFactory.getValidContentType(),  jsonSerializationWriterFactory)")));
                continue;
            }
            if (!stmt.toString().contains("JsonParseNodeFactory")) continue;
            constructorBody.setStatement(i, (Statement)new ExpressionStmt((Expression)new NameExpr("ParseNodeFactoryRegistry.defaultInstance.contentTypeAssociatedFactories.put(jsonParseNodeFactory.getValidContentType(), jsonParseNodeFactory)")));
        }
        constructorBody.addStatement(1, (Statement)new ExpressionStmt((Expression)new NameExpr("JsonSerializationWriterFactory jsonSerializationWriterFactory = Arc.container().instance(JsonSerializationWriterFactory.class).get()")));
        constructorBody.addStatement(2, (Statement)new ExpressionStmt((Expression)new NameExpr("JsonParseNodeFactory jsonParseNodeFactory = Arc.container().instance(JsonParseNodeFactory.class).get()")));
        source.saveAll();
    }
}

