/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.http.vertx;

import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.ResponseHeaders;
import io.vertx.core.MultiMap;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;

public class HeadersCompatibility {
    private HeadersCompatibility() {
    }

    @Nonnull
    public static ResponseHeaders getResponseHeaders(@Nonnull MultiMap headers) {
        Objects.requireNonNull(headers);
        ResponseHeaders responseHeaders = new ResponseHeaders();
        headers.names().forEach(name -> {
            Objects.requireNonNull(name);
            responseHeaders.put(name, new HashSet(headers.getAll(name)));
        });
        return responseHeaders;
    }

    @Nonnull
    public static MultiMap getMultiMap(@Nonnull RequestHeaders headers) {
        MultiMap result = MultiMap.caseInsensitiveMultiMap();
        headers.entrySet().forEach(elem -> result.add((String)elem.getKey(), (Iterable)elem.getValue()));
        return result;
    }
}

