/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.http.jdk;

import com.microsoft.kiota.RequestInformation;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.Set;

public class HttpRequestCompatibility {
    private HttpRequestCompatibility() {
    }

    public static HttpRequest convert(RequestInformation requestInfo) {
        HttpRequest.Builder requestBuilder;
        HttpRequest.BodyPublisher body = requestInfo.content == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofInputStream(() -> requestInfo.content);
        try {
            requestBuilder = HttpRequest.newBuilder().uri(requestInfo.getUri()).method(requestInfo.httpMethod.toString(), body);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (requestInfo.headers != null) {
            for (Map.Entry headerEntry : requestInfo.headers.entrySet()) {
                for (String headerValue : (Set)headerEntry.getValue()) {
                    requestBuilder.setHeader((String)headerEntry.getKey(), headerValue);
                }
            }
        }
        return requestBuilder.build();
    }
}

