/*
 * Decompiled with CFR 0.152.
 */
package openai4s.http;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import extras.fs2.text.syntax$;
import fs2.Compiler;
import fs2.Compiler$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Json;
import java.io.Serializable;
import openai4s.http.HttpClient;
import openai4s.http.HttpClient$;
import openai4s.http.HttpClient$HttpResponse$;
import openai4s.http.HttpClient$HttpResponse$Failed$;
import openai4s.http.HttpClient$HttpResponse$Successful$;
import openai4s.http.HttpError$;
import openai4s.http.HttpError$UnexpectedStatus$Body$;
import org.http4s.DecodeFailure;
import org.http4s.EntityDecoder;
import org.http4s.EntityDecoder$;
import org.http4s.MediaRange;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.circe.CirceEntityCodec$;
import org.http4s.client.Client;
import org.http4s.headers.Accept$;
import org.http4s.headers.MediaRangeAndQValue$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;

public interface HttpClient<F> {
    public static <F> HttpClient<F> apply(Client<F> client, Async<F> async) {
        return HttpClient$.MODULE$.apply(client, async);
    }

    public <A> F send(Request<F> var1, Decoder<A> var2);

    public <A> F sendWith(F var1, Decoder<A> var2);

    public <A> F sendAndHandle(Request<F> var1, Function1<HttpResponse<F>, F> var2);

    public <A> F sendWithAndHandle(F var1, Function1<HttpResponse<F>, F> var2);

    public static final class HttpClientF<F>
    implements HttpClient<F> {
        private final Client<F> client;
        private final Async<F> evidence$4;

        public HttpClientF(Client<F> client, Async<F> evidence$4) {
            this.client = client;
            this.evidence$4 = evidence$4;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <A> F send(Request<F> request, Decoder<A> evidence$5) {
            Request request2;
            EntityDecoder entityDecoder = EntityDecoder$.MODULE$.apply(CirceEntityCodec$.MODULE$.circeEntityDecoder(this.evidence$4, evidence$5));
            if (entityDecoder.consumes().nonEmpty()) {
                List mediaRanges = entityDecoder.consumes().toList();
                List list = mediaRanges;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    MediaRange head = (MediaRange)colon2.head();
                    List tail = list2;
                    request2 = (Request)request.addHeader((Object)Accept$.MODULE$.apply(MediaRangeAndQValue$.MODULE$.apply(head, MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()), (Seq)tail.map((Function1 & Serializable)_$1 -> MediaRangeAndQValue$.MODULE$.apply(_$1, MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()))), Accept$.MODULE$.headerInstance());
                } else {
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list3 = list;
                    if (nil$ != null ? !nil$.equals(list3) : list3 != null) throw new MatchError((Object)list);
                    request2 = request;
                }
            } else {
                request2 = request;
            }
            Request theRequest = request2;
            return this.sendAndHandle(theRequest, (Function1 & Serializable)x$1 -> {
                HttpResponse httpResponse = x$1;
                if (httpResponse instanceof HttpResponse.Successful) {
                    Response response;
                    HttpResponse.Successful successful = HttpClient$HttpResponse$Successful$.MODULE$.unapply((HttpResponse.Successful)httpResponse);
                    Response res = response = successful._1();
                    return entityDecoder.decode(res, false).leftMap((Function1 & Serializable)_$2 -> HttpError$.MODULE$.decodingError(theRequest, (DecodeFailure)_$2), this.evidence$4).rethrowT(this.evidence$4);
                }
                if (httpResponse instanceof HttpResponse.Failed) {
                    Response response;
                    HttpResponse.Failed failed = HttpClient$HttpResponse$Failed$.MODULE$.unapply((HttpResponse.Failed)httpResponse);
                    Response res = response = failed._1();
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(res.as(this.evidence$4, CirceEntityCodec$.MODULE$.circeEntityDecoder(this.evidence$4, Decoder$.MODULE$.decodeJson())), this.evidence$4).map((Function1 & Serializable)jsonBody -> HttpError$.MODULE$.unexpectedStatus(request, res.status(), HttpError$UnexpectedStatus$Body$.MODULE$.jsonBody((Json)jsonBody))), this.evidence$4);
                    Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)_$3 -> package.all$.MODULE$.toFunctorOps(syntax$.MODULE$.utf8String(res.body(), Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$4))), this.evidence$4).map((Function1 & Serializable)body -> HttpError$.MODULE$.unexpectedStatus(request, res.status(), HttpError$UnexpectedStatus$Body$.MODULE$.stringBody((String)body))), this.evidence$4), this.evidence$4);
                    Object err2 = ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)err -> HttpError$.MODULE$.unexpectedStatus(request, res.status(), HttpError$UnexpectedStatus$Body$.MODULE$.withCause((Throwable)err)), this.evidence$4);
                    return package.all$.MODULE$.toFlatMapOps(err2, this.evidence$4).flatMap((Function1 & Serializable)_$4 -> cats.effect.package$.MODULE$.Sync().apply(this.evidence$4).raiseError(_$4));
                }
                throw new MatchError((Object)httpResponse);
            });
        }

        @Override
        public <A> F sendWith(F request, Decoder<A> evidence$6) {
            return (F)package.all$.MODULE$.toFlatMapOps(request, this.evidence$4).flatMap((Function1 & Serializable)_$5 -> this.send((Request<F>)_$5, evidence$6));
        }

        @Override
        public <A> F sendAndHandle(Request<F> request, Function1<HttpResponse<F>, F> handler) {
            return (F)this.client.run(request).handleErrorWith((Function1 & Serializable)err -> (Resource)HttpError$.MODULE$.fromHttp4sException((Throwable)err, request).fold(() -> this.sendAndHandle$$anonfun$1$$anonfun$1(err), (Function1 & Serializable)e -> cats.effect.package$.MODULE$.Resource().eval(cats.effect.package$.MODULE$.Sync().apply(this.evidence$4).raiseError(e))), this.evidence$4).use((Function1 & Serializable)response -> handler.apply(HttpClient$HttpResponse$.MODULE$.fromHttp4s(response)), this.evidence$4);
        }

        @Override
        public <A> F sendWithAndHandle(F request, Function1<HttpResponse<F>, F> handler) {
            return (F)package.all$.MODULE$.toFlatMapOps(request, this.evidence$4).flatMap((Function1 & Serializable)_$6 -> this.sendAndHandle((Request<F>)_$6, handler));
        }

        private final Resource sendAndHandle$$anonfun$1$$anonfun$1(Throwable err$1) {
            return cats.effect.package$.MODULE$.Resource().eval(cats.effect.package$.MODULE$.Sync().apply(this.evidence$4).raiseError((Object)err$1));
        }
    }

    public static abstract class HttpResponse<F> {
        private final Response response;

        public static <F> HttpResponse<F> failed(Response<F> response) {
            return HttpClient$HttpResponse$.MODULE$.failed(response);
        }

        public static <F> HttpResponse<F> fromHttp4s(Response<F> response) {
            return HttpClient$HttpResponse$.MODULE$.fromHttp4s(response);
        }

        public static int ordinal(HttpResponse<?> httpResponse) {
            return HttpClient$HttpResponse$.MODULE$.ordinal(httpResponse);
        }

        public static <F> HttpResponse<F> successful(Response<F> response) {
            return HttpClient$HttpResponse$.MODULE$.successful(response);
        }

        public HttpResponse(Response<F> response) {
            this.response = response;
        }

        public Response<F> response() {
            return this.response;
        }
    }
}

