/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.RunnerResult;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.runner.docker.Docker;
import io.micronaut.context.ApplicationContext;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@MicronautTest
public class LogConsumerTest {
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private RunContextFactory runContextFactory;

    @Test
    void run() throws Exception {
        Task task = new Task(this){

            public String getId() {
                return "id";
            }

            public String getType() {
                return "type";
            }
        };
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        String outputValue = "a".repeat(10000);
        CommandsWrapper taskCommands = new CommandsWrapper(runContext).withCommands(List.of("/bin/sh", "-c", "echo \"::{\\\"outputs\\\":{\\\"someOutput\\\":\\\"" + outputValue + "\\\"}}::\"\necho -n another line"));
        RunnerResult run = Docker.from((DockerOptions)DockerOptions.builder().image("alpine").build()).run(runContext, (TaskCommands)taskCommands, Collections.emptyList(), Collections.emptyList());
        Await.until(() -> run.getLogConsumer().getStdOutCount() == 2, null, (Duration)Duration.ofSeconds(5L));
        MatcherAssert.assertThat((Object)run.getLogConsumer().getStdOutCount(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(run.getLogConsumer().getOutputs().get("someOutput"), (Matcher)Matchers.is((Object)outputValue));
    }

    @Test
    void testWithMultipleCrInSameFrame() throws Exception {
        Task task = new Task(this){

            public String getId() {
                return "id";
            }

            public String getType() {
                return "type";
            }
        };
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        StringBuilder outputValue = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            outputValue.append(Integer.toString(i).repeat(100)).append("\r").append(Integer.toString(i).repeat(800)).append("\r").append(Integer.toString(i).repeat(2000)).append("\r");
        }
        CommandsWrapper taskCommands = new CommandsWrapper(runContext).withCommands(List.of("/bin/sh", "-c", "echo " + String.valueOf(outputValue) + "echo -n another line"));
        RunnerResult run = Docker.from((DockerOptions)DockerOptions.builder().image("alpine").build()).run(runContext, (TaskCommands)taskCommands, Collections.emptyList(), Collections.emptyList());
        Await.until(() -> run.getLogConsumer().getStdOutCount() == 10, null, (Duration)Duration.ofSeconds(5L));
        MatcherAssert.assertThat((Object)run.getLogConsumer().getStdOutCount(), (Matcher)Matchers.is((Object)10));
    }
}

