/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.models;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.plugin.scripts.runner.docker.Cpu;
import io.kestra.plugin.scripts.runner.docker.Credentials;
import io.kestra.plugin.scripts.runner.docker.DeviceRequest;
import io.kestra.plugin.scripts.runner.docker.Memory;
import io.kestra.plugin.scripts.runner.docker.PullPolicy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class DockerOptions {
    @Schema(title="Docker API URI.")
    @PluginProperty(dynamic=true)
    private String host;
    @Schema(title="Docker configuration file.", description="Docker configuration file that can set access credentials to private container registries. Usually located in `~/.docker/config.json`.", anyOf={String.class, Map.class})
    @PluginProperty(dynamic=true)
    private Object config;
    @Schema(title="Credentials for a private container registry.")
    @PluginProperty(dynamic=true)
    private Credentials credentials;
    @Schema(title="Docker image to use.")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected String image;
    @Schema(title="User in the Docker container.")
    @PluginProperty(dynamic=true)
    protected String user;
    @Schema(title="Docker entrypoint to use.")
    @PluginProperty(dynamic=true)
    protected List<String> entryPoint;
    @Schema(title="Extra hostname mappings to the container network interface configuration.")
    @PluginProperty(dynamic=true)
    protected List<String> extraHosts;
    @Schema(title="Docker network mode to use e.g. `host`, `none`, etc.")
    @PluginProperty(dynamic=true)
    protected String networkMode;
    @Schema(title="List of volumes to mount.", description="Must be a valid mount expression as string, example : `/home/user:/app`.\n\nVolumes mount are disabled by default for security reasons; you must enable them on server configuration by setting `kestra.tasks.scripts.docker.volume-enabled` to `true`.")
    @PluginProperty(dynamic=true)
    protected List<String> volumes;
    @PluginProperty
    protected PullPolicy pullPolicy;
    @Schema(title="A list of device requests to be sent to device drivers.")
    @PluginProperty
    protected List<DeviceRequest> deviceRequests;
    @Schema(title="Limits the CPU usage to a given maximum threshold value.", description="By default, each container\u2019s access to the host machine\u2019s CPU cycles is unlimited. You can set various constraints to limit a given container\u2019s access to the host machine\u2019s CPU cycles.")
    @PluginProperty
    protected Cpu cpu;
    @Schema(title="Limits memory usage to a given maximum threshold value.", description="Docker can enforce hard memory limits, which allow the container to use no more than a given amount of user or system memory, or soft limits, which allow the container to use as much memory as it needs unless certain conditions are met, such as when the kernel detects low memory or contention on the host machine. Some of these options have different effects when used alone or when more than one option is set.")
    @PluginProperty
    protected Memory memory;
    @Schema(title="Size of `/dev/shm` in bytes.", description="The size must be greater than 0. If omitted, the system uses 64MB.")
    @PluginProperty(dynamic=true)
    private String shmSize;

    @Deprecated
    public void setDockerHost(String host) {
        this.host = host;
    }

    @Deprecated
    public void setDockerConfig(String config) {
        this.config = config;
    }

    @Generated
    private static PullPolicy $default$pullPolicy() {
        return PullPolicy.ALWAYS;
    }

    @Generated
    protected DockerOptions(DockerOptionsBuilder<?, ?> b) {
        this.host = b.host;
        this.config = b.config;
        this.credentials = b.credentials;
        this.image = b.image;
        this.user = b.user;
        this.entryPoint = b.entryPoint;
        this.extraHosts = b.extraHosts;
        this.networkMode = b.networkMode;
        this.volumes = b.volumes;
        this.pullPolicy = b.pullPolicy$set ? b.pullPolicy$value : DockerOptions.$default$pullPolicy();
        this.deviceRequests = b.deviceRequests;
        this.cpu = b.cpu;
        this.memory = b.memory;
        this.shmSize = b.shmSize;
    }

    @Generated
    public static DockerOptionsBuilder<?, ?> builder() {
        return new DockerOptionsBuilderImpl();
    }

    @Generated
    public DockerOptionsBuilder<?, ?> toBuilder() {
        return new DockerOptionsBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public DockerOptions() {
        this.pullPolicy = DockerOptions.$default$pullPolicy();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Object getConfig() {
        return this.config;
    }

    @Generated
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public List<String> getEntryPoint() {
        return this.entryPoint;
    }

    @Generated
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Generated
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Generated
    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    @Generated
    public List<DeviceRequest> getDeviceRequests() {
        return this.deviceRequests;
    }

    @Generated
    public Cpu getCpu() {
        return this.cpu;
    }

    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @Generated
    public String getShmSize() {
        return this.shmSize;
    }

    @Generated
    public static abstract class DockerOptionsBuilder<C extends DockerOptions, B extends DockerOptionsBuilder<C, B>> {
        @Generated
        private String host;
        @Generated
        private Object config;
        @Generated
        private Credentials credentials;
        @Generated
        private String image;
        @Generated
        private String user;
        @Generated
        private List<String> entryPoint;
        @Generated
        private List<String> extraHosts;
        @Generated
        private String networkMode;
        @Generated
        private List<String> volumes;
        @Generated
        private boolean pullPolicy$set;
        @Generated
        private PullPolicy pullPolicy$value;
        @Generated
        private List<DeviceRequest> deviceRequests;
        @Generated
        private Cpu cpu;
        @Generated
        private Memory memory;
        @Generated
        private String shmSize;

        @Generated
        protected B $fillValuesFrom(C instance) {
            DockerOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DockerOptions instance, DockerOptionsBuilder<?, ?> b) {
            b.host(instance.host);
            b.config(instance.config);
            b.credentials(instance.credentials);
            b.image(instance.image);
            b.user(instance.user);
            b.entryPoint(instance.entryPoint);
            b.extraHosts(instance.extraHosts);
            b.networkMode(instance.networkMode);
            b.volumes(instance.volumes);
            b.pullPolicy(instance.pullPolicy);
            b.deviceRequests(instance.deviceRequests);
            b.cpu(instance.cpu);
            b.memory(instance.memory);
            b.shmSize(instance.shmSize);
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return this.self();
        }

        @Generated
        public B config(Object config) {
            this.config = config;
            return this.self();
        }

        @Generated
        public B credentials(Credentials credentials) {
            this.credentials = credentials;
            return this.self();
        }

        @Generated
        public B image(String image) {
            this.image = image;
            return this.self();
        }

        @Generated
        public B user(String user) {
            this.user = user;
            return this.self();
        }

        @Generated
        public B entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this.self();
        }

        @Generated
        public B extraHosts(List<String> extraHosts) {
            this.extraHosts = extraHosts;
            return this.self();
        }

        @Generated
        public B networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this.self();
        }

        @Generated
        public B volumes(List<String> volumes) {
            this.volumes = volumes;
            return this.self();
        }

        @Generated
        public B pullPolicy(PullPolicy pullPolicy) {
            this.pullPolicy$value = pullPolicy;
            this.pullPolicy$set = true;
            return this.self();
        }

        @Generated
        public B deviceRequests(List<DeviceRequest> deviceRequests) {
            this.deviceRequests = deviceRequests;
            return this.self();
        }

        @Generated
        public B cpu(Cpu cpu) {
            this.cpu = cpu;
            return this.self();
        }

        @Generated
        public B memory(Memory memory) {
            this.memory = memory;
            return this.self();
        }

        @Generated
        public B shmSize(String shmSize) {
            this.shmSize = shmSize;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DockerOptions.DockerOptionsBuilder(host=" + this.host + ", config=" + this.config + ", credentials=" + this.credentials + ", image=" + this.image + ", user=" + this.user + ", entryPoint=" + this.entryPoint + ", extraHosts=" + this.extraHosts + ", networkMode=" + this.networkMode + ", volumes=" + this.volumes + ", pullPolicy$value=" + this.pullPolicy$value + ", deviceRequests=" + this.deviceRequests + ", cpu=" + this.cpu + ", memory=" + this.memory + ", shmSize=" + this.shmSize + ")";
        }
    }

    @Generated
    private static final class DockerOptionsBuilderImpl
    extends DockerOptionsBuilder<DockerOptions, DockerOptionsBuilderImpl> {
        @Generated
        private DockerOptionsBuilderImpl() {
        }

        @Override
        @Generated
        protected DockerOptionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DockerOptions build() {
            return new DockerOptions(this);
        }
    }
}

