/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.runner.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ConnectionClosedException;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.RunnerResult;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskException;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.RetryUtils;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.runner.docker.Cpu;
import io.kestra.plugin.scripts.runner.docker.Credentials;
import io.kestra.plugin.scripts.runner.docker.DeviceRequest;
import io.kestra.plugin.scripts.runner.docker.DockerService;
import io.kestra.plugin.scripts.runner.docker.Memory;
import io.kestra.plugin.scripts.runner.docker.PullPolicy;
import io.micronaut.core.convert.format.ReadableBytesTypeConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Task runner that executes a task inside a container in a Docker compatible engine.", description="This task runner is container-based so the `containerImage` property must be set.\n\nTo access the task's working directory, use the `{{workingDir}}` Pebble expression or the `WORKING_DIR` environment variable. Input files and namespace files will be available in this directory.\n\nTo generate output files you can either use the `outputFiles` task's property and create a file with the same name in the task's working directory, or create any file in the output directory which can be accessed by the `{{outputDir}}` Pebble expression or the `OUTPUT_DIR` environment variables.\n\nNote that when the Kestra Worker running this task is terminated, the container will still run until completion, except if Kestra itself is run inside a container and Docker-In-Docker (dind) is used as the dind engine will also be terminated.")
@Plugin(examples={@Example(title="Execute a Shell command.", code={"id: new-shell\nnamespace: myteam\n\ntasks:\n  - id: shell\n    type: io.kestra.plugin.scripts.shell.Commands\n    taskRunner:\n      type: io.kestra.plugin.scripts.runner.docker.DockerTaskRunner\n    commands:\n    - echo \"Hello World\""}, full=true), @Example(title="Pass input files to the task, execute a Shell command, then retrieve output files.", code={"id: new-shell-with-file\nnamespace: myteam\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: shell\n    type: io.kestra.plugin.scripts.shell.Commands\n    inputFiles:\n      data.txt: \"{{inputs.file}}\"\n    outputFiles:\n      - out.txt\n    containerImage: centos\n    taskRunner:\n      type: io.kestra.plugin.scripts.runner.docker.DockerTaskRunner\n    commands:\n    - cp {{workingDir}}/data.txt {{workingDir}}/out.txt"}, full=true)}, beta=true)
public class DockerTaskRunner
extends TaskRunner {
    private static final ReadableBytesTypeConverter READABLE_BYTES_TYPE_CONVERTER = new ReadableBytesTypeConverter();
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("([^\\r\\n]+)[\\r\\n]+");
    @Schema(title="Docker API URI.")
    @PluginProperty(dynamic=true)
    private String host;
    @Schema(title="Docker configuration file.", description="Docker configuration file that can set access credentials to private container registries. Usually located in `~/.docker/config.json`.", anyOf={String.class, Map.class})
    @PluginProperty(dynamic=true)
    private Object config;
    @Schema(title="Credentials for a private container registry.")
    @PluginProperty(dynamic=true)
    private Credentials credentials;
    @Schema(hidden=true)
    protected String image;
    @Schema(title="User in the Docker container.")
    @PluginProperty(dynamic=true)
    protected String user;
    @Schema(title="Docker entrypoint to use.")
    @PluginProperty(dynamic=true)
    protected List<String> entryPoint;
    @Schema(title="Extra hostname mappings to the container network interface configuration.")
    @PluginProperty(dynamic=true)
    protected List<String> extraHosts;
    @Schema(title="Docker network mode to use e.g. `host`, `none`, etc.")
    @PluginProperty(dynamic=true)
    protected String networkMode;
    @Schema(title="List of volumes to mount.", description="Must be a valid mount expression as string, example : `/home/user:/app`.\n\nVolumes mount are disabled by default for security reasons; you must enable them on [plugin configuration](https://kestra.io/docs/configuration-guide/plugins) by setting `volume-enabled` to `true`.")
    @PluginProperty(dynamic=true)
    protected List<String> volumes;
    @Schema(title="The pull policy for an image.", description="Pull policy can be used to prevent pulling of an already existing image `IF_NOT_PRESENT`, or can be set to `ALWAYS` to pull the latest version of the image even if an image with the same tag already exists.")
    @PluginProperty
    protected PullPolicy pullPolicy;
    @Schema(title="A list of device requests to be sent to device drivers.")
    @PluginProperty
    protected List<DeviceRequest> deviceRequests;
    @Schema(title="Limits the CPU usage to a given maximum threshold value.", description="By default, each container\u2019s access to the host machine\u2019s CPU cycles is unlimited. You can set various constraints to limit a given container\u2019s access to the host machine\u2019s CPU cycles.")
    @PluginProperty
    protected Cpu cpu;
    @Schema(title="Limits memory usage to a given maximum threshold value.", description="Docker can enforce hard memory limits, which allow the container to use no more than a given amount of user or system memory, or soft limits, which allow the container to use as much memory as it needs unless certain conditions are met, such as when the kernel detects low memory or contention on the host machine. Some of these options have different effects when used alone or when more than one option is set.")
    @PluginProperty
    protected Memory memory;
    @Schema(title="Size of `/dev/shm` in bytes.", description="The size must be greater than 0. If omitted, the system uses 64MB.")
    @PluginProperty(dynamic=true)
    private String shmSize;

    public static DockerTaskRunner from(DockerOptions dockerOptions) {
        if (dockerOptions == null) {
            return DockerTaskRunner.builder().build();
        }
        return ((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)((DockerTaskRunnerBuilder)((Object)DockerTaskRunner.builder().host(dockerOptions.getHost()))).config(dockerOptions.getConfig()))).credentials(dockerOptions.getCredentials()))).image(dockerOptions.getImage()))).user(dockerOptions.getUser()))).entryPoint(dockerOptions.getEntryPoint()))).extraHosts(dockerOptions.getExtraHosts()))).networkMode(dockerOptions.getNetworkMode()))).volumes(dockerOptions.getVolumes()))).pullPolicy(dockerOptions.getPullPolicy()))).deviceRequests(dockerOptions.getDeviceRequests()))).cpu(dockerOptions.getCpu()))).memory(dockerOptions.getMemory()))).shmSize(dockerOptions.getShmSize()))).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnerResult run(RunContext runContext, TaskCommands taskCommands, List<String> filesToUpload, List<String> filesToDownload) throws Exception {
        if (taskCommands.getContainerImage() == null && this.image == null) {
            throw new IllegalArgumentException("This task runner needs the `containerImage` property to be set");
        }
        if (this.image == null) {
            this.image = taskCommands.getContainerImage();
        }
        Logger logger = runContext.logger();
        final AbstractLogConsumer defaultLogConsumer = taskCommands.getLogConsumer();
        Map additionalVars = this.additionalVars(runContext, taskCommands);
        String image = runContext.render(this.image, additionalVars);
        try (DockerClient dockerClient = this.dockerClient(runContext, image);){
            RunnerResult runnerResult;
            CreateContainerCmd container = this.configure(taskCommands, dockerClient, runContext, additionalVars);
            if (this.getPullPolicy() != PullPolicy.NEVER) {
                this.pullImage(dockerClient, image, this.getPullPolicy(), logger);
            }
            CreateContainerResponse exec = container.exec();
            dockerClient.startContainerCmd(exec.getId()).exec();
            logger.debug("Starting command with container id {} [{}]", (Object)exec.getId(), (Object)String.join((CharSequence)" ", taskCommands.getCommands()));
            final AtomicBoolean ended = new AtomicBoolean(false);
            try {
                dockerClient.logContainerCmd(exec.getId()).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){
                    private final Map<StreamType, StringBuilder> logBuffers = new HashMap<StreamType, StringBuilder>();

                    public void onNext(Frame frame) {
                        String frameStr = new String(frame.getPayload());
                        Matcher newLineMatcher = NEWLINE_PATTERN.matcher(frameStr);
                        this.logBuffers.computeIfAbsent(frame.getStreamType(), streamType -> new StringBuilder());
                        int lastIndex = 0;
                        while (newLineMatcher.find()) {
                            String fragment = newLineMatcher.group(0);
                            this.logBuffers.get(frame.getStreamType()).append(fragment);
                            StringBuilder logBuffer = this.logBuffers.get(frame.getStreamType());
                            this.send(logBuffer.toString(), frame.getStreamType() == StreamType.STDERR);
                            logBuffer.setLength(0);
                            lastIndex = newLineMatcher.end();
                        }
                        if (lastIndex < frameStr.length()) {
                            this.logBuffers.get(frame.getStreamType()).append(frameStr.substring(lastIndex));
                        }
                    }

                    private void send(String logBuffer, Boolean isStdErr) {
                        List.of(logBuffer.split("\n")).forEach(s -> defaultLogConsumer.accept(s, (Object)isStdErr));
                    }

                    public void onComplete() {
                        try {
                            this.logBuffers.entrySet().stream().filter(entry -> !((StringBuilder)entry.getValue()).isEmpty()).forEach(Rethrow.throwConsumer(entry -> {
                                String log = ((StringBuilder)entry.getValue()).toString();
                                this.send(log, entry.getKey() == StreamType.STDERR);
                            }));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        ended.set(true);
                        super.onComplete();
                    }
                });
                WaitContainerResultCallback result = dockerClient.waitContainerCmd(exec.getId()).start();
                Integer exitCode = result.awaitStatusCode();
                Await.until(ended::get);
                if (exitCode != 0) {
                    throw new TaskException(exitCode.intValue(), defaultLogConsumer.getStdOutCount(), defaultLogConsumer.getStdErrCount());
                }
                logger.debug("Command succeed with code " + exitCode);
                runnerResult = new RunnerResult(exitCode.intValue(), defaultLogConsumer);
            }
            catch (Throwable throwable) {
                try {
                    InspectContainerResponse inspect = dockerClient.inspectContainerCmd(exec.getId()).exec();
                    if (Boolean.TRUE.equals(inspect.getState().getRunning())) {
                        try {
                            dockerClient.killContainerCmd(exec.getId()).exec();
                        }
                        catch (Exception e) {
                            logger.error("Unable to kill a running container", (Throwable)e);
                        }
                    }
                    dockerClient.removeContainerCmd(exec.getId()).exec();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                InspectContainerResponse inspect = dockerClient.inspectContainerCmd(exec.getId()).exec();
                if (Boolean.TRUE.equals(inspect.getState().getRunning())) {
                    try {
                        dockerClient.killContainerCmd(exec.getId()).exec();
                    }
                    catch (Exception e) {
                        logger.error("Unable to kill a running container", (Throwable)e);
                    }
                }
                dockerClient.removeContainerCmd(exec.getId()).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return runnerResult;
        }
    }

    public Map<String, Object> runnerAdditionalVars(RunContext runContext, TaskCommands taskCommands) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("workingDir", taskCommands.getWorkingDirectory());
        if (taskCommands.outputDirectoryEnabled()) {
            vars.put("outputDir", taskCommands.getOutputDirectory());
        }
        return vars;
    }

    private DockerClient dockerClient(RunContext runContext, String image) throws IOException, IllegalVariableEvaluationException {
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(DockerService.findHost(runContext, this.host));
        if (this.getConfig() != null || this.getCredentials() != null) {
            Path config = DockerService.createConfig(runContext, this.getConfig(), this.getCredentials() != null ? List.of(this.getCredentials()) : null, image);
            dockerClientConfigBuilder.withDockerConfig(config.toFile().getAbsolutePath());
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        return DockerService.client((DockerClientConfig)dockerClientConfig);
    }

    private CreateContainerCmd configure(TaskCommands taskCommands, DockerClient dockerClient, RunContext runContext, Map<String, Object> additionalVars) throws IllegalVariableEvaluationException {
        Optional property;
        boolean volumesEnabled = runContext.pluginConfiguration("volume-enabled").orElse(Boolean.FALSE);
        if (!volumesEnabled && (property = runContext.getApplicationContext().getProperty("kestra.tasks.scripts.docker.volume-enabled", Boolean.class)).isPresent()) {
            runContext.logger().warn("`kestra.tasks.scripts.docker.volume-enabled` is deprecated, please use the plugin configuration `volume-enabled` instead");
            volumesEnabled = (Boolean)property.get();
        }
        Path workingDirectory = taskCommands.getWorkingDirectory();
        String image = runContext.render(this.image, additionalVars);
        CreateContainerCmd container = dockerClient.createContainerCmd(image);
        DockerTaskRunner.addMetadata(runContext, container);
        HostConfig hostConfig = new HostConfig();
        container.withEnv(this.env(runContext, taskCommands).entrySet().stream().map(r -> (String)r.getKey() + "=" + (String)r.getValue()).collect(Collectors.toList()));
        if (workingDirectory != null) {
            container.withWorkingDir(workingDirectory.toFile().getAbsolutePath());
        }
        ArrayList<Bind> binds = new ArrayList<Bind>();
        if (workingDirectory != null) {
            binds.add(new Bind(workingDirectory.toAbsolutePath().toString(), new Volume(workingDirectory.toAbsolutePath().toString()), AccessMode.rw));
        }
        if (this.getUser() != null) {
            container.withUser(runContext.render(this.getUser(), additionalVars));
        }
        if (this.getEntryPoint() != null) {
            container.withEntrypoint(runContext.render(this.getEntryPoint(), additionalVars));
        }
        if (this.getExtraHosts() != null) {
            hostConfig.withExtraHosts((String[])runContext.render(this.getExtraHosts(), additionalVars).toArray(String[]::new));
        }
        if (volumesEnabled && this.getVolumes() != null) {
            binds.addAll(runContext.render(this.getVolumes()).stream().map(Bind::parse).toList());
        }
        if (!binds.isEmpty()) {
            hostConfig.withBinds(binds);
        }
        if (this.getDeviceRequests() != null) {
            hostConfig.withDeviceRequests(this.getDeviceRequests().stream().map(Rethrow.throwFunction(deviceRequest -> new com.github.dockerjava.api.model.DeviceRequest().withDriver(runContext.render(deviceRequest.getDriver())).withCount(deviceRequest.getCount()).withDeviceIds(runContext.render(deviceRequest.getDeviceIds())).withCapabilities(deviceRequest.getCapabilities()).withOptions(deviceRequest.getOptions()))).collect(Collectors.toList()));
        }
        if (this.getCpu() != null && this.getCpu().getCpus() != null) {
            hostConfig.withCpuQuota(Long.valueOf(this.getCpu().getCpus() * 10000L));
        }
        if (this.getMemory() != null) {
            if (this.getMemory().getMemory() != null) {
                hostConfig.withMemory(DockerTaskRunner.convertBytes(runContext.render(this.getMemory().getMemory())));
            }
            if (this.getMemory().getMemorySwap() != null) {
                hostConfig.withMemorySwap(DockerTaskRunner.convertBytes(runContext.render(this.getMemory().getMemorySwap())));
            }
            if (this.getMemory().getMemorySwappiness() != null) {
                hostConfig.withMemorySwappiness(DockerTaskRunner.convertBytes(runContext.render(this.getMemory().getMemorySwappiness())));
            }
            if (this.getMemory().getMemoryReservation() != null) {
                hostConfig.withMemoryReservation(DockerTaskRunner.convertBytes(runContext.render(this.getMemory().getMemoryReservation())));
            }
            if (this.getMemory().getKernelMemory() != null) {
                hostConfig.withKernelMemory(DockerTaskRunner.convertBytes(runContext.render(this.getMemory().getKernelMemory())));
            }
            if (this.getMemory().getOomKillDisable() != null) {
                hostConfig.withOomKillDisable(this.getMemory().getOomKillDisable());
            }
        }
        if (this.getShmSize() != null) {
            hostConfig.withShmSize(DockerTaskRunner.convertBytes(runContext.render(this.getShmSize())));
        }
        if (this.getNetworkMode() != null) {
            hostConfig.withNetworkMode(runContext.render(this.getNetworkMode(), additionalVars));
        }
        return container.withHostConfig(hostConfig).withCmd(taskCommands.getCommands()).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true));
    }

    private static void addMetadata(RunContext runContext, CreateContainerCmd container) {
        container.withLabels(ScriptService.labels((RunContext)runContext, (String)"kestra.io/"));
    }

    private static Long convertBytes(String bytes) {
        return ((Number)READABLE_BYTES_TYPE_CONVERTER.convert((Object)bytes, Number.class).orElseThrow(() -> new IllegalArgumentException("Invalid size with value '" + bytes + "'"))).longValue();
    }

    private void pullImage(DockerClient dockerClient, String image, PullPolicy policy, Logger logger) {
        NameParser.ReposTag imageParse = NameParser.parseRepositoryTag((String)image);
        if (policy.equals((Object)PullPolicy.IF_NOT_PRESENT)) {
            try {
                dockerClient.inspectImageCmd(image).exec();
                return;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        try (PullImageCmd pull = dockerClient.pullImageCmd(image);){
            new RetryUtils().of((AbstractRetry)((Exponential.ExponentialBuilder)Exponential.builder().delayFactor(Double.valueOf(2.0)).interval(Duration.ofSeconds(5L)).maxInterval(Duration.ofSeconds(120L)).maxAttempt(Integer.valueOf(5))).build()).run((bool, throwable) -> throwable instanceof InternalServerErrorException || throwable.getCause() instanceof ConnectionClosedException, () -> {
                String tag = !imageParse.tag.isEmpty() ? imageParse.tag : "latest";
                String repository = pull.getRepository().contains(":") ? pull.getRepository().split(":")[0] : pull.getRepository();
                ((PullImageResultCallback)pull.withTag(tag).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
                logger.debug("Image pulled [{}:{}]", (Object)repository, (Object)tag);
                return true;
            });
        }
    }

    @Generated
    private static PullPolicy $default$pullPolicy() {
        return PullPolicy.ALWAYS;
    }

    @Generated
    protected DockerTaskRunner(DockerTaskRunnerBuilder<?, ?> b) {
        super(b);
        this.host = b.host;
        this.config = b.config;
        this.credentials = b.credentials;
        this.image = b.image;
        this.user = b.user;
        this.entryPoint = b.entryPoint;
        this.extraHosts = b.extraHosts;
        this.networkMode = b.networkMode;
        this.volumes = b.volumes;
        this.pullPolicy = b.pullPolicy$set ? b.pullPolicy$value : DockerTaskRunner.$default$pullPolicy();
        this.deviceRequests = b.deviceRequests;
        this.cpu = b.cpu;
        this.memory = b.memory;
        this.shmSize = b.shmSize;
    }

    @Generated
    public static DockerTaskRunnerBuilder<?, ?> builder() {
        return new DockerTaskRunnerBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DockerTaskRunner(super=" + super.toString() + ", host=" + this.getHost() + ", config=" + this.getConfig() + ", credentials=" + this.getCredentials() + ", image=" + this.getImage() + ", user=" + this.getUser() + ", entryPoint=" + this.getEntryPoint() + ", extraHosts=" + this.getExtraHosts() + ", networkMode=" + this.getNetworkMode() + ", volumes=" + this.getVolumes() + ", pullPolicy=" + this.getPullPolicy() + ", deviceRequests=" + this.getDeviceRequests() + ", cpu=" + this.getCpu() + ", memory=" + this.getMemory() + ", shmSize=" + this.getShmSize() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerTaskRunner)) {
            return false;
        }
        DockerTaskRunner other = (DockerTaskRunner)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Object this$config = this.getConfig();
        Object other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<String> this$entryPoint = this.getEntryPoint();
        List<String> other$entryPoint = other.getEntryPoint();
        if (this$entryPoint == null ? other$entryPoint != null : !((Object)this$entryPoint).equals(other$entryPoint)) {
            return false;
        }
        List<String> this$extraHosts = this.getExtraHosts();
        List<String> other$extraHosts = other.getExtraHosts();
        if (this$extraHosts == null ? other$extraHosts != null : !((Object)this$extraHosts).equals(other$extraHosts)) {
            return false;
        }
        String this$networkMode = this.getNetworkMode();
        String other$networkMode = other.getNetworkMode();
        if (this$networkMode == null ? other$networkMode != null : !this$networkMode.equals(other$networkMode)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        PullPolicy this$pullPolicy = this.getPullPolicy();
        PullPolicy other$pullPolicy = other.getPullPolicy();
        if (this$pullPolicy == null ? other$pullPolicy != null : !((Object)((Object)this$pullPolicy)).equals((Object)other$pullPolicy)) {
            return false;
        }
        List<DeviceRequest> this$deviceRequests = this.getDeviceRequests();
        List<DeviceRequest> other$deviceRequests = other.getDeviceRequests();
        if (this$deviceRequests == null ? other$deviceRequests != null : !((Object)this$deviceRequests).equals(other$deviceRequests)) {
            return false;
        }
        Cpu this$cpu = this.getCpu();
        Cpu other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        Memory this$memory = this.getMemory();
        Memory other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        String this$shmSize = this.getShmSize();
        String other$shmSize = other.getShmSize();
        return !(this$shmSize == null ? other$shmSize != null : !this$shmSize.equals(other$shmSize));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DockerTaskRunner;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Object $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<String> $entryPoint = this.getEntryPoint();
        result = result * 59 + ($entryPoint == null ? 43 : ((Object)$entryPoint).hashCode());
        List<String> $extraHosts = this.getExtraHosts();
        result = result * 59 + ($extraHosts == null ? 43 : ((Object)$extraHosts).hashCode());
        String $networkMode = this.getNetworkMode();
        result = result * 59 + ($networkMode == null ? 43 : $networkMode.hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        PullPolicy $pullPolicy = this.getPullPolicy();
        result = result * 59 + ($pullPolicy == null ? 43 : ((Object)((Object)$pullPolicy)).hashCode());
        List<DeviceRequest> $deviceRequests = this.getDeviceRequests();
        result = result * 59 + ($deviceRequests == null ? 43 : ((Object)$deviceRequests).hashCode());
        Cpu $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        Memory $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        String $shmSize = this.getShmSize();
        result = result * 59 + ($shmSize == null ? 43 : $shmSize.hashCode());
        return result;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Object getConfig() {
        return this.config;
    }

    @Generated
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public List<String> getEntryPoint() {
        return this.entryPoint;
    }

    @Generated
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Generated
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Generated
    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    @Generated
    public List<DeviceRequest> getDeviceRequests() {
        return this.deviceRequests;
    }

    @Generated
    public Cpu getCpu() {
        return this.cpu;
    }

    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @Generated
    public String getShmSize() {
        return this.shmSize;
    }

    @Generated
    public DockerTaskRunner() {
        this.pullPolicy = DockerTaskRunner.$default$pullPolicy();
    }

    @Generated
    public static abstract class DockerTaskRunnerBuilder<C extends DockerTaskRunner, B extends DockerTaskRunnerBuilder<C, B>>
    extends TaskRunner.TaskRunnerBuilder<C, B> {
        @Generated
        private String host;
        @Generated
        private Object config;
        @Generated
        private Credentials credentials;
        @Generated
        private String image;
        @Generated
        private String user;
        @Generated
        private List<String> entryPoint;
        @Generated
        private List<String> extraHosts;
        @Generated
        private String networkMode;
        @Generated
        private List<String> volumes;
        @Generated
        private boolean pullPolicy$set;
        @Generated
        private PullPolicy pullPolicy$value;
        @Generated
        private List<DeviceRequest> deviceRequests;
        @Generated
        private Cpu cpu;
        @Generated
        private Memory memory;
        @Generated
        private String shmSize;

        @Generated
        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B config(Object config) {
            this.config = config;
            return (B)this.self();
        }

        @Generated
        public B credentials(Credentials credentials) {
            this.credentials = credentials;
            return (B)this.self();
        }

        @Generated
        public B image(String image) {
            this.image = image;
            return (B)this.self();
        }

        @Generated
        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        @Generated
        public B entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return (B)this.self();
        }

        @Generated
        public B extraHosts(List<String> extraHosts) {
            this.extraHosts = extraHosts;
            return (B)this.self();
        }

        @Generated
        public B networkMode(String networkMode) {
            this.networkMode = networkMode;
            return (B)this.self();
        }

        @Generated
        public B volumes(List<String> volumes) {
            this.volumes = volumes;
            return (B)this.self();
        }

        @Generated
        public B pullPolicy(PullPolicy pullPolicy) {
            this.pullPolicy$value = pullPolicy;
            this.pullPolicy$set = true;
            return (B)this.self();
        }

        @Generated
        public B deviceRequests(List<DeviceRequest> deviceRequests) {
            this.deviceRequests = deviceRequests;
            return (B)this.self();
        }

        @Generated
        public B cpu(Cpu cpu) {
            this.cpu = cpu;
            return (B)this.self();
        }

        @Generated
        public B memory(Memory memory) {
            this.memory = memory;
            return (B)this.self();
        }

        @Generated
        public B shmSize(String shmSize) {
            this.shmSize = shmSize;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DockerTaskRunner.DockerTaskRunnerBuilder(super=" + super.toString() + ", host=" + this.host + ", config=" + this.config + ", credentials=" + this.credentials + ", image=" + this.image + ", user=" + this.user + ", entryPoint=" + this.entryPoint + ", extraHosts=" + this.extraHosts + ", networkMode=" + this.networkMode + ", volumes=" + this.volumes + ", pullPolicy$value=" + this.pullPolicy$value + ", deviceRequests=" + this.deviceRequests + ", cpu=" + this.cpu + ", memory=" + this.memory + ", shmSize=" + this.shmSize + ")";
        }
    }

    @Generated
    private static final class DockerTaskRunnerBuilderImpl
    extends DockerTaskRunnerBuilder<DockerTaskRunner, DockerTaskRunnerBuilderImpl> {
        @Generated
        private DockerTaskRunnerBuilderImpl() {
        }

        @Override
        @Generated
        protected DockerTaskRunnerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DockerTaskRunner build() {
            return new DockerTaskRunner(this);
        }
    }
}

