/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.DefaultLogConsumer;
import io.kestra.core.models.tasks.runners.RemoteRunnerInterface;
import io.kestra.core.models.tasks.runners.RunnerResult;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.tasks.runners.types.ProcessTaskRunner;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.NamespaceFilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.runner.docker.DockerTaskRunner;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CommandsWrapper
implements TaskCommands {
    private RunContext runContext;
    private Path workingDirectory;
    private Path outputDirectory;
    private Map<String, Object> additionalVars;
    private List<String> commands;
    private Map<String, String> env;
    private AbstractLogConsumer logConsumer;
    private RunnerType runnerType;
    private String containerImage;
    private TaskRunner taskRunner;
    private DockerOptions dockerOptions;
    private Boolean warningOnStdErr;
    private NamespaceFiles namespaceFiles;
    private Object inputFiles;
    private List<String> outputFiles;
    private Boolean enableOutputDirectory;
    private Duration timeout;

    public CommandsWrapper(RunContext runContext) {
        this.runContext = runContext;
        this.workingDirectory = runContext.tempDir();
        this.logConsumer = new DefaultLogConsumer(runContext);
        this.additionalVars = new HashMap<String, Object>();
        this.env = new HashMap<String, String>();
    }

    public CommandsWrapper withEnv(Map<String, String> envs) {
        return new CommandsWrapper(this.runContext, this.workingDirectory, this.getOutputDirectory(), this.additionalVars, this.commands, envs, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    public CommandsWrapper addAdditionalVars(Map<String, Object> additionalVars) {
        if (this.additionalVars == null) {
            this.additionalVars = new HashMap<String, Object>();
        }
        this.additionalVars.putAll(additionalVars);
        return this;
    }

    public CommandsWrapper addEnv(Map<String, String> envs) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.putAll(envs);
        return this;
    }

    public ScriptOutput run() throws Exception {
        ArrayList<String> filesToUpload = new ArrayList<String>();
        if (this.namespaceFiles != null) {
            String tenantId = (String)((Map)this.runContext.getVariables().get("flow")).get("tenantId");
            String namespace = (String)((Map)this.runContext.getVariables().get("flow")).get("namespace");
            NamespaceFilesService namespaceFilesService = (NamespaceFilesService)this.runContext.getApplicationContext().getBean(NamespaceFilesService.class);
            List injectedFiles = namespaceFilesService.inject(this.runContext, tenantId, namespace, this.workingDirectory, this.namespaceFiles);
            injectedFiles.forEach(uri -> filesToUpload.add(uri.toString().substring(1)));
        }
        TaskRunner realTaskRunner = this.getTaskRunner();
        if (this.inputFiles != null) {
            Map finalInputFiles = FilesService.inputFiles((RunContext)this.runContext, (Map)realTaskRunner.additionalVars(this.runContext, (TaskCommands)this), (Object)this.inputFiles);
            filesToUpload.addAll(finalInputFiles.keySet());
        }
        RunContext taskRunnerRunContext = this.runContext.forTaskRunner(realTaskRunner);
        this.commands = this.render(this.runContext, this.commands, filesToUpload);
        RunnerResult runnerResult = realTaskRunner.run(taskRunnerRunContext, (TaskCommands)this, filesToUpload, this.outputFiles);
        HashMap<String, URI> outputFiles = new HashMap<String, URI>();
        if (this.outputDirectoryEnabled()) {
            outputFiles.putAll(ScriptService.uploadOutputFiles((RunContext)taskRunnerRunContext, (Path)this.getOutputDirectory()));
        }
        if (this.outputFiles != null) {
            outputFiles.putAll(FilesService.outputFiles((RunContext)taskRunnerRunContext, this.outputFiles));
        }
        return ScriptOutput.builder().exitCode(runnerResult.getExitCode()).stdOutLineCount(runnerResult.getLogConsumer().getStdOutCount()).stdErrLineCount(runnerResult.getLogConsumer().getStdErrCount()).warningOnStdErr(this.warningOnStdErr).vars(runnerResult.getLogConsumer().getOutputs()).outputFiles(outputFiles).build();
    }

    public TaskRunner getTaskRunner() {
        if (this.taskRunner == null) {
            this.taskRunner = switch (this.runnerType) {
                default -> throw new IncompatibleClassChangeError();
                case RunnerType.DOCKER -> DockerTaskRunner.from(this.dockerOptions);
                case RunnerType.PROCESS -> new ProcessTaskRunner();
            };
        }
        return this.taskRunner;
    }

    public Boolean getEnableOutputDirectory() {
        if (this.enableOutputDirectory == null) {
            return this.runnerType != null;
        }
        return this.enableOutputDirectory;
    }

    public Path getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.workingDirectory.resolve(IdUtils.create());
            if (!this.outputDirectory.toFile().mkdirs()) {
                throw new RuntimeException("Unable to create the output directory " + this.outputDirectory);
            }
        }
        return this.outputDirectory;
    }

    public String render(RunContext runContext, String command, List<String> internalStorageLocalFiles) throws IllegalVariableEvaluationException, IOException {
        TaskRunner taskRunner = this.getTaskRunner();
        return ScriptService.replaceInternalStorage((RunContext)this.runContext, (Map)taskRunner.additionalVars(runContext, (TaskCommands)this), (String)command, (ignored, localFilePath) -> internalStorageLocalFiles.add((String)localFilePath), (boolean)(taskRunner instanceof RemoteRunnerInterface));
    }

    public List<String> render(RunContext runContext, List<String> commands, List<String> internalStorageLocalFiles) throws IllegalVariableEvaluationException, IOException {
        TaskRunner taskRunner = this.getTaskRunner();
        return ScriptService.replaceInternalStorage((RunContext)this.runContext, (Map)taskRunner.additionalVars(runContext, (TaskCommands)this), commands, (ignored, localFilePath) -> internalStorageLocalFiles.add((String)localFilePath), (boolean)(taskRunner instanceof RemoteRunnerInterface));
    }

    @ConstructorProperties(value={"runContext", "workingDirectory", "outputDirectory", "additionalVars", "commands", "env", "logConsumer", "runnerType", "containerImage", "taskRunner", "dockerOptions", "warningOnStdErr", "namespaceFiles", "inputFiles", "outputFiles", "enableOutputDirectory", "timeout"})
    @Generated
    public CommandsWrapper(RunContext runContext, Path workingDirectory, Path outputDirectory, Map<String, Object> additionalVars, List<String> commands, Map<String, String> env, AbstractLogConsumer logConsumer, RunnerType runnerType, String containerImage, TaskRunner taskRunner, DockerOptions dockerOptions, Boolean warningOnStdErr, NamespaceFiles namespaceFiles, Object inputFiles, List<String> outputFiles, Boolean enableOutputDirectory, Duration timeout) {
        this.runContext = runContext;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
        this.additionalVars = additionalVars;
        this.commands = commands;
        this.env = env;
        this.logConsumer = logConsumer;
        this.runnerType = runnerType;
        this.containerImage = containerImage;
        this.taskRunner = taskRunner;
        this.dockerOptions = dockerOptions;
        this.warningOnStdErr = warningOnStdErr;
        this.namespaceFiles = namespaceFiles;
        this.inputFiles = inputFiles;
        this.outputFiles = outputFiles;
        this.enableOutputDirectory = enableOutputDirectory;
        this.timeout = timeout;
    }

    @Generated
    public RunContext getRunContext() {
        return this.runContext;
    }

    @Generated
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Generated
    public Map<String, Object> getAdditionalVars() {
        return this.additionalVars;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public AbstractLogConsumer getLogConsumer() {
        return this.logConsumer;
    }

    @Generated
    public RunnerType getRunnerType() {
        return this.runnerType;
    }

    @Generated
    public String getContainerImage() {
        return this.containerImage;
    }

    @Generated
    public DockerOptions getDockerOptions() {
        return this.dockerOptions;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public CommandsWrapper withCommands(List<String> commands) {
        return this.commands == commands ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withLogConsumer(AbstractLogConsumer logConsumer) {
        return this.logConsumer == logConsumer ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withRunnerType(RunnerType runnerType) {
        return this.runnerType == runnerType ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withContainerImage(String containerImage) {
        return this.containerImage == containerImage ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withTaskRunner(TaskRunner taskRunner) {
        return this.taskRunner == taskRunner ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withDockerOptions(DockerOptions dockerOptions) {
        return this.dockerOptions == dockerOptions ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withWarningOnStdErr(Boolean warningOnStdErr) {
        return this.warningOnStdErr == warningOnStdErr ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withNamespaceFiles(NamespaceFiles namespaceFiles) {
        return this.namespaceFiles == namespaceFiles ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withInputFiles(Object inputFiles) {
        return this.inputFiles == inputFiles ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withOutputFiles(List<String> outputFiles) {
        return this.outputFiles == outputFiles ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, outputFiles, this.enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withEnableOutputDirectory(Boolean enableOutputDirectory) {
        return this.enableOutputDirectory == enableOutputDirectory ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, enableOutputDirectory, this.timeout);
    }

    @Generated
    public CommandsWrapper withTimeout(Duration timeout) {
        return this.timeout == timeout ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, timeout);
    }
}

