/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.models.templates.Template;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.TemplateRepositoryInterface;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.value.ValueException;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
@MemoryRepositoryEnabled
public class MemoryTemplateRepository
implements TemplateRepositoryInterface {
    private final Map<String, Template> templates = new HashMap<String, Template>();
    @Inject
    @Named(value="templateQueue")
    private QueueInterface<Template> templateQueue;
    @Inject
    private ApplicationEventPublisher<CrudEvent<Template>> eventPublisher;

    public Optional<Template> findById(String namespace, String id) {
        return this.templates.values().stream().filter(template -> template.getId().equals(id)).findFirst();
    }

    public List<Template> findAll() {
        return new ArrayList<Template>(this.templates.values());
    }

    public ArrayListTotal<Template> find(Pageable pageable, String query, String namespace) {
        if (pageable.getNumber() < 1) {
            throw new ValueException("Page cannot be < 1");
        }
        List<Template> filteredTemplates = this.find(query, namespace);
        return ArrayListTotal.of((Pageable)pageable, filteredTemplates);
    }

    public List<Template> find(@Nullable String query, @Nullable String namespace) {
        return this.templates.values().stream().filter(flow -> namespace == null || flow.getNamespace().equals(namespace)).collect(Collectors.toList());
    }

    public List<Template> findByNamespace(String namespace) {
        return this.templates.values().stream().filter(template -> template.getNamespace().equals(namespace)).collect(Collectors.toList());
    }

    public Template create(Template template) {
        this.templates.put(template.getId(), template);
        this.templateQueue.emit((Object)template);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)template, CrudEventType.CREATE));
        return template;
    }

    public Template update(Template template, Template previous) {
        this.findById(previous.getNamespace(), previous.getId()).map(current -> current.validateUpdate(template)).filter(Optional::isPresent).map(Optional::get).ifPresent(s -> {
            throw s;
        });
        this.templates.put(template.getId(), template);
        this.templateQueue.emit((Object)template);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)template, CrudEventType.UPDATE));
        return template;
    }

    public void delete(Template template) {
        if (!this.templates.containsKey(template.getId())) {
            throw new IllegalStateException("Template " + template.getId() + " doesn't exists");
        }
        this.templates.remove(template.getId());
        Template deleted = template.toDeleted();
        this.templateQueue.emit((Object)deleted);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)deleted, CrudEventType.DELETE));
    }

    public List<String> findDistinctNamespace() {
        HashSet<String> namespaces = new HashSet<String>();
        for (Template t : this.findAll()) {
            namespaces.add(t.getNamespace());
        }
        ArrayList namespacesList = new ArrayList(namespaces);
        Collections.sort(namespacesList);
        return new ArrayList<String>(namespacesList);
    }
}

