/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.event.Level;

@Singleton
@MemoryRepositoryEnabled
public class MemoryLogRepository
implements LogRepositoryInterface {
    private final List<LogEntry> logs = new ArrayList<LogEntry>();

    public List<LogEntry> findByExecutionId(String id, Level minLevel) {
        return this.logs.stream().filter(logEntry -> logEntry.getExecutionId().equals(id) && logEntry.getLevel().equals((Object)minLevel)).collect(Collectors.toList());
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String executionId, String taskId, Level minLevel) {
        return this.logs.stream().filter(logEntry -> logEntry.getExecutionId().equals(executionId) && logEntry.getTaskId().equals(taskId) && logEntry.getLevel().equals((Object)minLevel)).collect(Collectors.toList());
    }

    public List<LogEntry> findByExecutionIdAndTaskRunId(String executionId, String taskRunId, Level minLevel) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> find(Pageable pageable, @Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        throw new UnsupportedOperationException();
    }

    public LogEntry save(LogEntry log) {
        this.logs.add(log);
        return log;
    }

    public Integer purge(Execution execution) {
        throw new UnsupportedOperationException();
    }
}

