/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.services.FlowService;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.value.ValueException;
import io.micronaut.data.model.Pageable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;

@Singleton
@MemoryRepositoryEnabled
public class MemoryFlowRepository
implements FlowRepositoryInterface {
    private final HashMap<String, Flow> flows = new HashMap();
    private final HashMap<String, Flow> revisions = new HashMap();
    @Inject
    @Named(value="flowQueue")
    private QueueInterface<Flow> flowQueue;
    @Inject
    @Named(value="triggerQueue")
    private QueueInterface<Trigger> triggerQueue;
    @Inject
    private ApplicationEventPublisher eventPublisher;
    @Inject
    private ModelValidator modelValidator;

    private static String flowId(Flow flow) {
        return MemoryFlowRepository.flowId(flow.getNamespace(), flow.getId());
    }

    private static String flowId(String namespace, String id) {
        return String.join((CharSequence)"_", Arrays.asList(namespace, id));
    }

    public Optional<Flow> findById(String namespace, String id, Optional<Integer> revision) {
        return revision.map(integer -> this.findRevisions(namespace, id).stream().filter(flow -> flow.getRevision().equals(integer)).findFirst()).orElseGet(() -> this.flows.containsKey(MemoryFlowRepository.flowId(namespace, id)) ? Optional.of(this.flows.get(MemoryFlowRepository.flowId(namespace, id))) : Optional.empty());
    }

    public List<Flow> findRevisions(String namespace, String id) {
        return this.revisions.values().stream().filter(flow -> flow.getNamespace().equals(namespace) && flow.getId().equals(id)).sorted(Comparator.comparingInt(Flow::getRevision)).collect(Collectors.toList());
    }

    public List<Flow> findAll() {
        return new ArrayList<Flow>(this.flows.values());
    }

    public List<Flow> findAllWithRevisions() {
        return new ArrayList<Flow>(this.revisions.values());
    }

    public List<Flow> findByNamespace(String namespace) {
        return this.flows.values().stream().filter(flow -> flow.getNamespace().equals(namespace)).sorted(Comparator.comparingInt(Flow::getRevision)).collect(Collectors.toList());
    }

    public ArrayListTotal<Flow> find(String query, Pageable pageable) {
        if (pageable.getNumber() < 1) {
            throw new ValueException("Page cannot be < 1");
        }
        return ArrayListTotal.of((Pageable)pageable, this.findAll());
    }

    public Flow create(Flow flow) throws ConstraintViolationException {
        flow.validate().ifPresent(s -> {
            throw s;
        });
        return this.save(flow, CrudEventType.CREATE);
    }

    public Flow update(Flow flow, Flow previous) throws ConstraintViolationException {
        this.findById(previous.getNamespace(), previous.getId()).map(current -> current.validateUpdate(flow)).filter(Optional::isPresent).map(Optional::get).ifPresent(s -> {
            throw s;
        });
        Flow saved = this.save(flow, CrudEventType.UPDATE);
        FlowService.findRemovedTrigger((Flow)flow, (Flow)previous).forEach(abstractTrigger -> this.triggerQueue.delete((Object)Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger)));
        return saved;
    }

    private Flow save(Flow flow, CrudEventType crudEventType) throws ConstraintViolationException {
        this.modelValidator.isValid((Object)flow).ifPresent(s -> {
            throw s;
        });
        Optional exists = this.findById(flow.getNamespace(), flow.getId());
        if (exists.isPresent() && ((Flow)exists.get()).equalsWithoutRevision(flow)) {
            return (Flow)exists.get();
        }
        List<Flow> revisions = this.findRevisions(flow.getNamespace(), flow.getId());
        flow = revisions.size() > 0 ? flow.withRevision(Integer.valueOf(revisions.get(revisions.size() - 1).getRevision() + 1)) : flow.withRevision(Integer.valueOf(1));
        this.flows.put(MemoryFlowRepository.flowId(flow), flow);
        this.revisions.put(flow.uid(), flow);
        this.flowQueue.emit((Object)flow);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, crudEventType));
        return flow;
    }

    public Flow delete(Flow flow) {
        if (this.findById(flow.getNamespace(), flow.getId(), Optional.of(flow.getRevision())).isEmpty()) {
            throw new IllegalStateException("Flow " + flow.getId() + " doesn't exists");
        }
        Flow deleted = flow.toDeleted();
        this.flowQueue.emit((Object)deleted);
        this.flows.remove(MemoryFlowRepository.flowId(deleted));
        this.revisions.put(deleted.uid(), deleted);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, CrudEventType.DELETE));
        return deleted;
    }

    public List<String> findDistinctNamespace() {
        HashSet<String> namespaces = new HashSet<String>();
        for (Flow f : this.findAll()) {
            namespaces.add(f.getNamespace());
        }
        ArrayList namespacesList = new ArrayList(namespaces);
        Collections.sort(namespacesList);
        return new ArrayList<String>(namespacesList);
    }
}

