/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.core.value.ValueException;
import io.micronaut.data.model.Pageable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
@MemoryRepositoryEnabled
public class MemoryExecutionRepository
implements ExecutionRepositoryInterface {
    private Map<String, Execution> executions = new HashMap<String, Execution>();

    public ArrayListTotal<Execution> find(String query, Pageable pageable, List<State.Type> state) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<TaskRun> findTaskRun(String query, Pageable pageable, List<State.Type> state) {
        throw new UnsupportedOperationException();
    }

    public Optional<Execution> findById(String executionId) {
        return this.executions.containsKey(executionId) ? Optional.of(this.executions.get(executionId)) : Optional.empty();
    }

    public ArrayListTotal<Execution> findByFlowId(String namespace, String flowId, Pageable pageable) {
        if (pageable.getNumber() < 1) {
            throw new ValueException("Page cannot be < 1");
        }
        List filteredExecutions = this.executions.values().stream().filter(e -> Objects.nonNull(namespace)).filter(e -> e.getNamespace().equals(namespace)).filter(e -> Objects.nonNull(e.getFlowId())).filter(e -> e.getFlowId().equals(flowId)).collect(Collectors.toList());
        return ArrayListTotal.of((Pageable)pageable, filteredExecutions);
    }

    public Execution save(Execution execution) {
        return this.executions.put(execution.getId(), execution);
    }

    public Map<String, Map<String, List<DailyExecutionStatistics>>> dailyGroupByFlowStatistics(String query, LocalDate startDate, LocalDate endDate) {
        throw new UnsupportedOperationException();
    }

    public List<DailyExecutionStatistics> dailyStatistics(String query, LocalDate startDate, LocalDate endDate, boolean isTaskRun) {
        throw new UnsupportedOperationException();
    }

    public Integer maxTaskRunSetting() {
        throw new UnsupportedOperationException();
    }
}

