/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.statistics.LogStatistics;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.event.Level;

@Singleton
@MemoryRepositoryEnabled
public class MemoryLogRepository
implements LogRepositoryInterface {
    private final List<LogEntry> logs = new ArrayList<LogEntry>();

    public List<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel) {
        return this.logs.stream().filter(logEntry -> Objects.equals(logEntry.getExecutionId(), executionId) && Objects.equals(logEntry.getLevel(), minLevel)).filter(logEntry -> tenantId == null && logEntry.getTenantId() == null || tenantId != null && tenantId.equals(logEntry.getTenantId())).collect(Collectors.toList());
    }

    public ArrayListTotal<LogEntry> findByExecutionId(String tenantId, String id, Level minLevel, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<LogEntry> findByExecutionId(String tenantId, String namespace, String flowId, String executionId, Level level) {
        return this.findByExecutionId(tenantId, executionId, level);
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel) {
        return this.logs.stream().filter(logEntry -> logEntry.getExecutionId() != null && logEntry.getExecutionId().equals(executionId) && logEntry.getTaskId().equals(taskId) && logEntry.getLevel().equals((Object)minLevel)).filter(logEntry -> tenantId == null && logEntry.getTenantId() == null || tenantId != null && tenantId.equals(logEntry.getTenantId())).collect(Collectors.toList());
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String namespace, String flowId, String executionId, String taskId, Level level) {
        return this.findByExecutionIdAndTaskId(tenantId, executionId, taskId, level);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> find(Pageable pageable, @jakarta.annotation.Nullable String query, @jakarta.annotation.Nullable String tenantId, @jakarta.annotation.Nullable String namespace, @jakarta.annotation.Nullable String flowId, @jakarta.annotation.Nullable Level minLevel, @jakarta.annotation.Nullable ZonedDateTime startDate, @jakarta.annotation.Nullable ZonedDateTime endDate) {
        throw new UnsupportedOperationException();
    }

    public List<LogStatistics> statistics(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy) {
        throw new UnsupportedOperationException();
    }

    public LogEntry save(LogEntry log) {
        this.logs.add(log);
        return log;
    }

    public Integer purge(Execution execution) {
        throw new UnsupportedOperationException();
    }

    public void deleteByQuery(String tenantId, String executionId, String taskId, String taskRunId, Level minLevel, Integer attempt) {
        throw new UnsupportedOperationException();
    }
}

