/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ServiceInstanceRepositoryInterface;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Singleton
@MemoryRepositoryEnabled
public class MemoryServiceInstanceRepository
implements ServiceInstanceRepositoryInterface {
    private final Map<String, ServiceInstance> data = new HashMap<String, ServiceInstance>();

    public Optional<ServiceInstance> findById(String id) {
        return Optional.ofNullable(this.data.get(id));
    }

    public List<ServiceInstance> findAll() {
        return new ArrayList<ServiceInstance>(this.data.values());
    }

    public ArrayListTotal<ServiceInstance> find(Pageable pageable, Set<Service.ServiceState> states, Set<Service.ServiceType> types) {
        List<ServiceInstance> instances = this.findAll();
        return new ArrayListTotal(instances, (long)instances.size());
    }

    public void delete(ServiceInstance service) {
        this.data.remove(service.id());
    }

    public ServiceInstance save(ServiceInstance service) {
        this.data.put(service.id(), service);
        return service;
    }

    public List<ServiceInstance> findAllInstancesInState(Service.ServiceState state) {
        ArrayList<ServiceInstance> instancesInState = new ArrayList<ServiceInstance>();
        for (ServiceInstance instance : this.data.values()) {
            if (instance.state() != state) continue;
            instancesInState.add(instance);
        }
        return instancesInState;
    }

    public List<ServiceInstance> findAllInstancesInStates(Set<Service.ServiceState> states) {
        ArrayList<ServiceInstance> instancesInStates = new ArrayList<ServiceInstance>();
        for (ServiceInstance instance : this.data.values()) {
            if (!states.contains(instance.state())) continue;
            instancesInStates.add(instance);
        }
        return instancesInStates;
    }

    public List<ServiceInstance> findAllInstancesBetween(Service.ServiceType type, Instant from, Instant to) {
        return Collections.emptyList();
    }
}

