/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@Singleton
@MemoryRepositoryEnabled
public class MemoryTriggerRepository
implements TriggerRepositoryInterface {
    private final List<Trigger> triggers = new ArrayList<Trigger>();

    public Optional<Trigger> findLast(TriggerContext trigger) {
        throw new UnsupportedOperationException();
    }

    public Optional<Trigger> findByExecution(Execution execution) {
        throw new UnsupportedOperationException();
    }

    public List<Trigger> findAllForAllTenants() {
        return this.triggers;
    }

    public Trigger save(Trigger trigger) {
        this.triggers.add(trigger);
        return trigger;
    }

    public Trigger update(Trigger trigger) {
        this.triggers.add(trigger);
        return trigger;
    }

    public Trigger lock(String triggerUid, Function<Trigger, Trigger> consumer) {
        throw new UnsupportedOperationException();
    }

    public void delete(Trigger trigger) {
        this.triggers.remove(trigger);
    }

    public ArrayListTotal<Trigger> find(Pageable from, String query, String tenantId, String namespace) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<Trigger> find(Pageable from, String query, String tenantId, String namespace, String flowId) {
        List<Trigger> filteredTriggers = this.triggers.stream().filter(trigger -> {
            if (tenantId != null && !tenantId.equals(trigger.getTenantId())) {
                return false;
            }
            if (namespace != null && !namespace.equals(trigger.getNamespace())) {
                return false;
            }
            return flowId == null || flowId.equals(trigger.getFlowId());
        }).toList();
        return new ArrayListTotal(filteredTriggers, (long)filteredTriggers.size());
    }
}

