/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.models.SearchResult;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.value.ValueException;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.NotImplementedException;

@Singleton
@MemoryRepositoryEnabled
public class MemoryFlowRepository
implements FlowRepositoryInterface {
    private final HashMap<String, Flow> flows = new HashMap();
    private final HashMap<String, Flow> revisions = new HashMap();
    private final HashMap<String, String> flowSources = new HashMap();
    @Inject
    @Named(value="flowQueue")
    private QueueInterface<Flow> flowQueue;
    @Inject
    @Named(value="triggerQueue")
    private QueueInterface<Trigger> triggerQueue;
    @Inject
    private ApplicationEventPublisher<CrudEvent<Flow>> eventPublisher;
    @Inject
    private ModelValidator modelValidator;

    private static String flowId(Flow flow) {
        return MemoryFlowRepository.flowId(flow.getTenantId(), flow.getNamespace(), flow.getId());
    }

    private static String flowId(String tenantId, String namespace, String id) {
        return IdUtils.fromParts((String[])new String[]{tenantId, namespace, id});
    }

    public Optional<Flow> findById(String tenantId, String namespace, String id, Optional<Integer> revision, Boolean allowDeleted) {
        return revision.map(integer -> this.findRevisions(tenantId, namespace, id).stream().filter(flow -> flow.getRevision().equals(integer)).map(FlowWithSource::toFlow).findFirst()).orElseGet(() -> this.flows.containsKey(MemoryFlowRepository.flowId(tenantId, namespace, id)) ? Optional.of(this.flows.get(MemoryFlowRepository.flowId(tenantId, namespace, id))) : Optional.empty());
    }

    private Optional<String> findSourceById(String tenantId, String namespace, String id) {
        return this.flowSources.containsKey(MemoryFlowRepository.flowId(tenantId, namespace, id)) ? Optional.of(this.flowSources.get(MemoryFlowRepository.flowId(tenantId, namespace, id))) : Optional.empty();
    }

    public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id, Optional<Integer> revision, Boolean allowDeleted) {
        Optional flow = this.findById(tenantId, namespace, id, revision);
        Optional<String> sourceCode = this.findSourceById(tenantId, namespace, id);
        if (flow.isPresent() && sourceCode.isPresent()) {
            return Optional.of(FlowWithSource.of((Flow)((Flow)flow.get()), (String)FlowService.cleanupSource((String)sourceCode.get())));
        }
        return Optional.empty();
    }

    public List<FlowWithSource> findRevisions(String tenantId, String namespace, String id) {
        return this.revisions.values().stream().filter(flow -> flow.getNamespace().equals(namespace) && flow.getId().equals(id)).filter(flow -> tenantId == null && flow.getTenantId() == null || tenantId != null && tenantId.equals(flow.getTenantId())).map(flow -> FlowWithSource.of((Flow)flow, (String)flow.generateSource())).sorted(Comparator.comparingInt(Flow::getRevision)).collect(Collectors.toList());
    }

    public List<Flow> findAll(String tenantId) {
        return this.flows.values().stream().filter(flow -> tenantId == null && flow.getTenantId() == null || tenantId != null && tenantId.equals(flow.getTenantId())).toList();
    }

    public List<Flow> findAllForAllTenants() {
        return new ArrayList<Flow>(this.flows.values());
    }

    public List<Flow> findByNamespace(String tenantId, String namespace) {
        return this.flows.values().stream().filter(flow -> flow.getNamespace().equals(namespace)).filter(flow -> tenantId == null && flow.getTenantId() == null || tenantId != null && tenantId.equals(flow.getTenantId())).sorted(Comparator.comparingInt(Flow::getRevision)).collect(Collectors.toList());
    }

    public List<FlowWithSource> findByNamespaceWithSource(String tenantId, String namespace) {
        return this.flows.values().stream().filter(flow -> flow.getNamespace().equals(namespace)).filter(flow -> tenantId == null && flow.getTenantId() == null || tenantId != null && tenantId.equals(flow.getTenantId())).sorted(Comparator.comparingInt(Flow::getRevision)).map(flow -> FlowWithSource.of((Flow)flow, (String)FlowService.cleanupSource((String)this.findSourceById(tenantId, namespace, flow.getId()).get()))).collect(Collectors.toList());
    }

    public ArrayListTotal<Flow> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable Map<String, String> labels) {
        if (pageable.getNumber() < 1) {
            throw new ValueException("Page cannot be < 1");
        }
        List results = this.flows.values().stream().filter(flow -> namespace == null || flow.getNamespace().equals(namespace) || flow.getNamespace().startsWith(namespace + ".")).filter(flow -> tenantId == null && flow.getTenantId() == null || tenantId != null && tenantId.equals(flow.getTenantId())).filter(flow -> labels == null || labels.isEmpty() || flow.getLabels() != null && flow.getLabels().stream().anyMatch(label -> labels.containsKey(label.key()) && ((String)labels.get(label.key())).equals(label.value()))).collect(Collectors.toList());
        return ArrayListTotal.of((Pageable)pageable, results);
    }

    public List<FlowWithSource> findWithSource(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable Map<String, String> labels) {
        return this.flows.values().stream().filter(flow -> namespace == null || flow.getNamespace().equals(namespace) || flow.getNamespace().startsWith(namespace + ".")).filter(flow -> tenantId == null && flow.getTenantId() == null || tenantId != null && tenantId.equals(flow.getTenantId())).filter(flow -> labels == null || labels.isEmpty() || flow.getLabels() != null && flow.getLabels().stream().anyMatch(label -> labels.containsKey(label.key()) && ((String)labels.get(label.key())).equals(label.value()))).sorted(Comparator.comparingInt(Flow::getRevision)).map(flow -> (FlowWithSource)this.findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId(), Optional.of(flow.getRevision())).get()).collect(Collectors.toList());
    }

    public ArrayListTotal<SearchResult<Flow>> findSourceCode(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace) {
        throw new NotImplementedException();
    }

    public FlowWithSource create(Flow flow, String flowSource, Flow flowWithDefaults) {
        if (this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId()).isPresent()) {
            throw new ConstraintViolationException(Collections.singleton(ManualConstraintViolation.of((String)"Flow id already exists", (Object)flow, Flow.class, (String)"flow.id", (Object)flow.getId())));
        }
        this.modelValidator.validate((Object)flowWithDefaults);
        return this.save(flow, CrudEventType.CREATE, flowSource);
    }

    public FlowWithSource update(Flow flow, Flow previous, String flowSource, Flow flowWithDefaults) throws ConstraintViolationException {
        this.modelValidator.validate((Object)flowWithDefaults);
        Optional checkUpdate = previous.validateUpdate(flowWithDefaults);
        if (checkUpdate.isPresent()) {
            throw (ConstraintViolationException)checkUpdate.get();
        }
        FlowService.findRemovedTrigger((Flow)flow, (Flow)previous).forEach(abstractTrigger -> this.triggerQueue.delete((Object)Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger)));
        return this.save(flow, CrudEventType.UPDATE, flowSource);
    }

    private FlowWithSource save(Flow flow, CrudEventType crudEventType, String flowSource) throws ConstraintViolationException {
        if (flow instanceof FlowWithSource) {
            flow = ((FlowWithSource)flow).toFlow();
        }
        Optional exists = this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId());
        Optional<String> existsSource = this.findSourceById(flow.getTenantId(), flow.getNamespace(), flow.getId());
        if (exists.isPresent() && ((Flow)exists.get()).equalsWithoutRevision(flow) && existsSource.isPresent() && FlowService.cleanupSource((String)existsSource.get()).equals(FlowService.cleanupSource((String)flowSource))) {
            return FlowWithSource.of((Flow)((Flow)exists.get()), (String)existsSource.get());
        }
        List<FlowWithSource> revisions = this.findRevisions(flow.getTenantId(), flow.getNamespace(), flow.getId());
        flow = !revisions.isEmpty() ? flow.toBuilder().revision(Integer.valueOf(revisions.get(revisions.size() - 1).getRevision() + 1)).build() : flow.toBuilder().revision(Integer.valueOf(1)).build();
        this.flows.put(MemoryFlowRepository.flowId(flow), flow);
        this.revisions.put(flow.uid(), flow);
        this.flowSources.put(MemoryFlowRepository.flowId(flow), flowSource);
        this.flowQueue.emit((Object)flow);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, crudEventType));
        return FlowWithSource.of((Flow)flow, (String)flowSource);
    }

    public Flow delete(Flow flow) {
        if (flow instanceof FlowWithSource) {
            flow = ((FlowWithSource)flow).toFlow();
        }
        if (this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId(), Optional.of(flow.getRevision())).isEmpty()) {
            throw new IllegalStateException("Flow " + flow.getId() + " doesn't exists");
        }
        Flow deleted = flow.toDeleted();
        this.flowQueue.emit((Object)deleted);
        this.flows.remove(MemoryFlowRepository.flowId(deleted));
        this.revisions.put(deleted.uid(), deleted);
        Flow finalFlow = flow;
        ListUtils.emptyOnNull((List)flow.getTriggers()).forEach(abstractTrigger -> this.triggerQueue.delete((Object)Trigger.of((Flow)finalFlow, (AbstractTrigger)abstractTrigger)));
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, CrudEventType.DELETE));
        return deleted;
    }

    public List<String> findDistinctNamespace(String tenantId) {
        HashSet<String> namespaces = new HashSet<String>();
        for (Flow f : this.findAll(tenantId)) {
            namespaces.add(f.getNamespace());
        }
        ArrayList namespacesList = new ArrayList(namespaces);
        Collections.sort(namespacesList);
        return new ArrayList<String>(namespacesList);
    }
}

