/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.event.Level;

@Singleton
@MemoryRepositoryEnabled
public class MemoryLogRepository
implements LogRepositoryInterface {
    private final List<LogEntry> logs = new ArrayList<LogEntry>();

    public List<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel) {
        return this.logs.stream().filter(logEntry -> logEntry.getExecutionId().equals(executionId) && logEntry.getLevel().equals((Object)minLevel)).filter(logEntry -> tenantId == null && logEntry.getTenantId() == null || tenantId != null && tenantId.equals(logEntry.getTenantId())).collect(Collectors.toList());
    }

    public ArrayListTotal<LogEntry> findByExecutionId(String tenantId, String id, Level minLevel, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel) {
        return this.logs.stream().filter(logEntry -> logEntry.getExecutionId().equals(executionId) && logEntry.getTaskId().equals(taskId) && logEntry.getLevel().equals((Object)minLevel)).filter(logEntry -> tenantId == null && logEntry.getTenantId() == null || tenantId != null && tenantId.equals(logEntry.getTenantId())).collect(Collectors.toList());
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<LogEntry> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        throw new UnsupportedOperationException();
    }

    public LogEntry save(LogEntry log) {
        this.logs.add(log);
        return log;
    }

    public Integer purge(Execution execution) {
        throw new UnsupportedOperationException();
    }
}

