/*
 * Decompiled with CFR 0.152.
 */
package io.kermoss.cs.service;

import io.kermoss.cs.domain.Command;
import io.kermoss.cs.service.CommandService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public final class CommandServiceImpl
implements CommandService {
    private final JdbcTemplate jdbcTemplate;
    private final Long maxCommandExecutionTime;

    @Autowired
    public CommandServiceImpl(JdbcTemplate jdbcTemplate, @Value(value="${kermoss.cs.config.max-cmd-exec-time}") Long maxCommandExecutionTime) {
        this.jdbcTemplate = jdbcTemplate;
        this.maxCommandExecutionTime = maxCommandExecutionTime;
    }

    public List<Command> findFailedCommands() {
        Long currentTimestamp = new Date().getTime();
        return this.jdbcTemplate.query("SELECT id, status FROM KERMOSS_CMD cmd WHERE cmd.status = 'FAILED' " + String.format("OR (cmd.status = 'STARTED' AND (cmd.started_timestamp + %d) < %d)", this.maxCommandExecutionTime, currentTimestamp), (RowMapper)new BeanPropertyRowMapper(Command.class));
    }
}

