/*
 * Decompiled with CFR 0.152.
 */
package io.keploy;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JaCoCoUtil {
    public static void downloadAndExtractJaCoCoBinaries(String version, String resourceDir) throws Exception {
        Path cliPath = Paths.get(resourceDir, "jacococli.jar");
        Path agentPath = Paths.get(resourceDir, "jacocoagent.jar");
        Files.createDirectories(cliPath.getParent(), new FileAttribute[0]);
        Files.createDirectories(agentPath.getParent(), new FileAttribute[0]);
        if (Files.exists(cliPath, new LinkOption[0]) && Files.exists(agentPath, new LinkOption[0])) {
            return;
        }
        String downloadUrl = "https://github.com/jacoco/jacoco/releases/download/v" + version + "/jacoco-" + version + ".zip";
        try (InputStream inputStream = new URL(downloadUrl).openStream();
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.getName().endsWith("jacococli.jar")) {
                    Files.copy(zipInputStream, cliPath, StandardCopyOption.REPLACE_EXISTING);
                } else if (entry.getName().endsWith("jacocoagent.jar")) {
                    Files.copy(zipInputStream, agentPath, StandardCopyOption.REPLACE_EXISTING);
                }
                if (!Files.exists(cliPath, new LinkOption[0]) || !Files.exists(agentPath, new LinkOption[0])) continue;
                break;
            }
        }
        if (!Files.exists(cliPath, new LinkOption[0]) || !Files.exists(agentPath, new LinkOption[0])) {
            throw new IllegalStateException("Failed to find JaCoCo binaries in the distribution.");
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected two arguments: version and resourceDir");
        }
        String version = args[0];
        String resourceDir = args[1];
        try {
            JaCoCoUtil.downloadAndExtractJaCoCoBinaries(version, resourceDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

