/*
 * Decompiled with CFR 0.152.
 */
package io.keploy;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Keploy {
    private static final String GRAPHQL_ENDPOINT = "/query";
    private static final String HOST = "http://localhost:";
    private static final Logger logger = LogManager.getLogger(Keploy.class);
    private static int serverPort = 6789;
    private static String jacocoCliPath = "";
    private static String jacocoAgentPath = "";

    public static TestRunStatus getTestRunStatus(String statusStr) {
        switch (statusStr) {
            case "RUNNING": {
                return TestRunStatus.RUNNING;
            }
            case "PASSED": {
                return TestRunStatus.PASSED;
            }
            case "FAILED": {
                return TestRunStatus.FAILED;
            }
            case "APP_HALTED": {
                return TestRunStatus.APP_HALTED;
            }
            case "USER_ABORT": {
                return TestRunStatus.USER_ABORT;
            }
            case "APP_FAULT": {
                return TestRunStatus.APP_FAULT;
            }
            case "INTERNAL_ERR": {
                return TestRunStatus.INTERNAL_ERR;
            }
        }
        return null;
    }

    private static String attachJacocoAgent(String cmd) {
        String string;
        block9: {
            String resourcePath = "jacocoagent.jar";
            InputStream is = Keploy.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("jacocoagent.jar not found in resources");
                }
                Path tempFile = Files.createTempFile("jacocoagent", ".jar", new FileAttribute[0]);
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                is.close();
                String agentString = "-javaagent:" + tempFile.toAbsolutePath() + "=address=localhost,port=36320,destfile=coverage.exec,output=tcpserver";
                jacocoAgentPath = tempFile.toAbsolutePath().toString();
                string = cmd.replaceFirst("java", "java " + agentString);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Error setting up JaCoCo agent", e);
                }
            }
            is.close();
        }
        return string;
    }

    public static void FindCoverage(String testSet) throws IOException, InterruptedException {
        String dest = "target/" + testSet + ".exec";
        String jacocoCliPath = Keploy.getJacococliPath();
        List<String> command = Arrays.asList("java", "-jar", jacocoCliPath, "dump", "--address", "localhost", "--port", "36320", "--destfile", dest);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        Thread logThread = new Thread(() -> Keploy.logProcessOutput(process));
        logThread.start();
    }

    private static String getJacococliPath() {
        String string;
        block9: {
            String resourcePath = "jacococli.jar";
            InputStream is = Keploy.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("jacococli.jar not found in resources");
                }
                Path tempFile = Files.createTempFile("jacococli", ".jar", new FileAttribute[0]);
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                is.close();
                string = jacocoCliPath = tempFile.toAbsolutePath().toString();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Error setting up JacocoCli", e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String StopUserApplication(String appId) {
        HttpURLConnection conn = Keploy.setHttpClient();
        if (conn == null) {
            return "Failed to set up HTTP client";
        }
        String payload = "{\"query\": \"mutation StopApp { stopApp(appId: " + appId + ") }\"}";
        try {
            GraphQLResponse response;
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("Status code received: " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                String resBody = Keploy.getResponseBody(conn);
                logger.debug("Response body received: " + resBody);
                Gson gson = new Gson();
                response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                if (response.data == null) {
                    return gson.toJson(response.errors);
                }
            } else {
                return "Failed to stop user application. Status code: " + responseCode;
            }
            Boolean stopAppResult = response.data.stopApp;
            logger.debug("stopApp result: " + stopAppResult);
        }
        catch (Exception e) {
            logger.error("Error stopping user application: " + e.getMessage(), (Throwable)e);
            return "Error stopping user application: " + e.getMessage();
        }
        return null;
    }

    private static void deleteJacocoFiles() {
        Keploy.deleteFile(jacocoAgentPath);
        Keploy.deleteFile(jacocoCliPath);
    }

    private static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            System.out.println("File not found: " + filePath);
            return false;
        }
        if (file.delete()) {
            return true;
        }
        System.out.println("Failed to delete the file: " + filePath);
        return false;
    }

    private static long getProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.ProcessImpl")) {
            return process.pid();
        }
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return f.getLong(process);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to get process ID", e);
        }
    }

    private static void logProcessOutput(Process process) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HttpURLConnection setHttpClient() {
        try {
            URL obj = new URL(HOST + serverPort + GRAPHQL_ENDPOINT);
            logger.debug("Connecting to: " + obj.toString());
            HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(10000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("Accept", "application/json");
            conn.setInstanceFollowRedirects(false);
            return conn;
        }
        catch (Exception e) {
            logger.error("Error setting up HttpURLConnection", (Throwable)e);
            return null;
        }
    }

    public static String[] FetchTestSets() {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = "{ \"query\": \"{ testSets }\" }";
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                return response.data.testSets;
            }
        }
        catch (Exception e) {
            logger.error("Error fetching test sets", (Throwable)e);
        }
        return null;
    }

    public static Boolean RunTestSet(String testSetName) {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = String.format("{ \"query\": \"mutation { runTestSet(testSet: \\\"%s\\\") }\" }", testSetName);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                return response.data.runTestSet;
            }
        }
        catch (Exception e) {
            logger.error("Error running test set", (Throwable)e);
        }
        return null;
    }

    private static boolean isSuccessfulResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        return responseCode >= 200 && responseCode < 300;
    }

    private static String getSimulateResponseBody(HttpURLConnection conn) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        return content.toString();
    }

    public static void findAndCollectChildProcesses(String parentPID, List<Integer> pids) {
        try {
            pids.add(Integer.parseInt(parentPID));
            Process process = new ProcessBuilder("pgrep", "-P", parentPID).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = reader.readLine();
            if (output != null) {
                Arrays.stream(output.split("\n")).forEach(childPID -> {
                    if (!childPID.isEmpty()) {
                        Keploy.findAndCollectChildProcesses(childPID, pids);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runTests(String jarPath, RunOptions runOptions) {
        Object runCmd = "java -jar " + jarPath;
        if (runOptions.getPort() != 0) {
            serverPort = runOptions.getPort();
        }
        try {
            runCmd = Keploy.attachJacocoAgent((String)runCmd);
            Keploy.startKeploy((String)runCmd, runOptions.getDelay(), runOptions.isDebug(), serverPort);
            Thread.sleep(5000L);
            String[] testSets = Keploy.FetchTestSets();
            if (testSets == null) {
                throw new IllegalStateException("Test sets are null");
            }
            System.out.println("TestSets: " + Arrays.asList(testSets));
            StartHooksResult result = Keploy.startHooks();
            if (result.error != null) {
                throw new AssertionError((Object)("error starting hooks: " + result.error));
            }
            String appId = result.appId;
            String testRunId = result.testRunId;
            for (String testSet : testSets) {
                String appErr;
                Keploy.runTestSet(testRunId, testSet, appId);
                Keploy.startUserApplication(appId);
                String path = new File(runOptions.getPath()).getAbsolutePath();
                Path reportPath = Paths.get(path, "keploy", "reports", testRunId, testSet + "-report.yaml").normalize();
                String reportPathString = reportPath.toString();
                String err = Keploy.checkReportFile(reportPathString, runOptions.getDelay() + 10);
                if (err != null) {
                    appErr = Keploy.stopUserApplication(appId);
                    if (appErr != null) {
                        throw new AssertionError((Object)("error stopping user application: " + appErr));
                    }
                    logger.error("error getting report file: " + testRunId + ", testSetId: " + testSet + ". Error: " + err);
                    continue;
                }
                Keploy.waitForTestRunCompletion(testRunId, testSet, appId);
                try {
                    Keploy.FindCoverage(testSet);
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                appErr = Keploy.stopUserApplication(appId);
                if (appErr != null) {
                    throw new AssertionError((Object)("error stopping user application: " + appErr));
                }
            }
            Keploy.stopKeploy();
            Keploy.deleteJacocoFiles();
        }
        catch (Exception e) {
            logger.error("Error occurred while fetching test sets: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void startKeploy(String runCmd, int delay, boolean debug, int port) {
        Runnable task = () -> Keploy.runKeploy(runCmd, delay, debug, port);
        Thread thread = new Thread(task);
        thread.start();
    }

    public static void runKeploy(String runCmd, int delay, boolean debug, int port) {
        String overallCmd = String.format("sudo -E env \"PATH=$PATH\" /usr/local/bin/keploybin test -c \"%s\" --coverage --delay %d --port %d%s", runCmd, delay, port, debug ? " --debug" : "");
        logger.debug("Executing command: " + overallCmd);
        new Thread(() -> {
            ProcessBuilder processBuilder = new ProcessBuilder("sh", "-c", overallCmd);
            processBuilder.redirectErrorStream(true);
            try {
                String line;
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                logger.error("Error occurred while running Keploy: " + e.getMessage());
            }
        }).start();
    }

    public static StartHooksResult startHooks() {
        HttpURLConnection conn = Keploy.setHttpClient();
        if (conn == null) {
            return new StartHooksResult(null, null, "Failed to set up HTTP client");
        }
        String payload = "{\"query\": \"mutation StartHooks { startHooks { appId testRunId } }\"}";
        try {
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("Status code received: " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                String resBody = Keploy.getResponseBody(conn);
                logger.debug("Response body received: " + resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                if (response.data == null) {
                    return new StartHooksResult(null, null, gson.toJson(response.errors));
                }
                StartHooksData startHooksData = response.data.startHooks;
                if (startHooksData == null) {
                    return new StartHooksResult(null, null, "Failed to get start Hooks data");
                }
                return new StartHooksResult(startHooksData.appId, startHooksData.testRunId, null);
            }
            return new StartHooksResult(null, null, "Failed to start hooks. Status code: " + responseCode);
        }
        catch (Exception e) {
            logger.error("Error starting hooks: " + e.getMessage(), (Throwable)e);
            return new StartHooksResult(null, null, "Error starting hooks: " + e.getMessage());
        }
    }

    public static StartAppResult startUserApplication(String appId) {
        HttpURLConnection conn = Keploy.setHttpClient();
        if (conn == null) {
            return new StartAppResult(false, "Failed to set up HTTP client");
        }
        String payload = "{\"query\": \"mutation StartApp { startApp(appId: " + appId + ") }\"}";
        try {
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("Status code received: " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                String resBody = Keploy.getResponseBody(conn);
                logger.debug("Response body received: " + resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                if (response.data == null) {
                    return new StartAppResult(false, gson.toJson(response.errors));
                }
                Boolean startAppResult = response.data.startApp;
                return new StartAppResult(startAppResult, null);
            }
            return new StartAppResult(false, "Failed to start user application. Status code: " + responseCode);
        }
        catch (Exception e) {
            logger.error("Error starting user application: " + e.getMessage(), (Throwable)e);
            return new StartAppResult(false, "Error starting user application: " + e.getMessage());
        }
    }

    public static TestRunStatus FetchTestSetStatus(String testRunId, String testSetId) {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = String.format("{ \"query\": \"query GetTestSetStatus { testSetStatus(testRunId: \\\"%s\\\", testSetId: \\\"%s\\\") { status } }\" }", testRunId, testSetId);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                String testStatus = response.data.testSetStatus.status;
                return Keploy.getTestRunStatus(testStatus);
            }
            logger.error("Failed to fetch test set status. Status code: " + responseCode);
            return null;
        }
        catch (Exception e) {
            logger.error("Error fetching test set status: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void waitForTestRunCompletion(String testRunId, String testSet, String appId) {
        long MAX_TIMEOUT = 6000000L;
        long startTime = System.currentTimeMillis();
        try {
            TestRunStatus testRunStatus;
            block6: {
                testRunStatus = null;
                do {
                    Thread.sleep(2000L);
                    testRunStatus = Keploy.FetchTestSetStatus(testRunId, testSet);
                    if (testRunStatus != TestRunStatus.RUNNING) break block6;
                    System.out.println("Test run still in progress");
                } while (System.currentTimeMillis() - startTime <= MAX_TIMEOUT);
                System.out.println("Timeout reached, exiting loop");
            }
            if (testRunStatus == TestRunStatus.FAILED || testRunStatus == TestRunStatus.APP_HALTED || testRunStatus == TestRunStatus.USER_ABORT || testRunStatus == TestRunStatus.APP_FAULT || testRunStatus == TestRunStatus.INTERNAL_ERR) {
                logger.error("Test set: " + testSet + " failed with status: " + testRunStatus);
            } else if (testRunStatus == TestRunStatus.PASSED) {
                logger.info("Test set: " + testSet + " passed");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error waiting for test run completion: " + e.getMessage());
        }
    }

    public static RunTestSetResult runTestSet(String testRunId, String testSetId, String appId) {
        HttpURLConnection conn = Keploy.setHttpClient();
        if (conn == null) {
            return new RunTestSetResult(false, "Failed to set up HTTP client");
        }
        String payload = String.format("{\"query\": \"mutation RunTestSet { runTestSet(testSetId: \\\"%s\\\", testRunId: \\\"%s\\\", appId: %s) }\"}", testSetId, testRunId, appId);
        try {
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("Status code received: " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                String resBody = Keploy.getResponseBody(conn);
                logger.debug("Response body received: " + resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                if (response.data == null) {
                    return new RunTestSetResult(false, gson.toJson(response.errors));
                }
                return new RunTestSetResult(true, null);
            }
            return new RunTestSetResult(false, "Failed to run test set. Status code: " + responseCode);
        }
        catch (Exception e) {
            logger.error("Error running test set: " + e.getMessage(), (Throwable)e);
            return new RunTestSetResult(false, "Error running test set: " + e.getMessage());
        }
    }

    private static String checkReportFile(String reportPath, int timeout) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)timeout * 1000L) {
            File reportFile = new File(reportPath);
            if (reportFile.exists()) {
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return "Interrupted while waiting for report file";
            }
        }
        return "Report file not created within " + timeout + " seconds";
    }

    public static StopHooksResult stopKeploy() {
        HttpURLConnection conn = Keploy.setHttpClient();
        if (conn == null) {
            return new StopHooksResult(null, "Failed to set up HTTP client");
        }
        String payload = "{\"query\": \"mutation { stopHooks }\"}";
        try {
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("Status code received: " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                String resBody = Keploy.getResponseBody(conn);
                logger.debug("Response body received: " + resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                if (response.data == null) {
                    return new StopHooksResult(null, gson.toJson(response.errors));
                }
                Boolean stopHooksResult = response.data.stopHooks;
                return new StopHooksResult(stopHooksResult, null);
            }
            return new StopHooksResult(null, "Failed to stop hooks. Status code: " + responseCode);
        }
        catch (Exception e) {
            logger.error("Error stopping hooks: " + e.getMessage(), (Throwable)e);
            return new StopHooksResult(null, "Error stopping hooks: " + e.getMessage());
        }
    }

    private static String getResponseBody(HttpURLConnection conn) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        return content.toString();
    }

    public static String stopUserApplication(String appId) {
        String result = Keploy.StopUserApplication(appId);
        return result;
    }

    public static enum TestRunStatus {
        RUNNING,
        PASSED,
        FAILED,
        APP_HALTED,
        USER_ABORT,
        APP_FAULT,
        INTERNAL_ERR;

    }

    public class GraphQLResponse {
        Data data;
        Map<String, Object>[] errors;

        public class RunTestSetResponse {
            Boolean success;
            String testRunId;
            String message;
        }

        public class TestSetStatus {
            String status;
        }

        public class Data {
            String[] testSets;
            Boolean stopTest;
            TestSetStatus testSetStatus;
            Boolean runTestSet;
            StartHooksData startHooks;
            Boolean startApp;
            Boolean stopHooks;
            Boolean stopApp;
        }
    }

    public static class RunOptions {
        private int delay;
        private boolean debug;
        private int port;
        private String path;

        public RunOptions() {
            this(13, false, 6789, ".");
        }

        public RunOptions(int delay, boolean debug, int port, String path) {
            if (delay < 0) {
                throw new IllegalArgumentException("Delay must be a positive integer.");
            }
            this.delay = delay;
            this.debug = debug;
            if (path == null || path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be empty.");
            }
            this.path = path;
            if (port < 0) {
                throw new IllegalArgumentException("Port must be a positive integer.");
            }
            this.port = port;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delay) {
            if (delay < 0) {
                throw new IllegalArgumentException("Delay must be a positive integer.");
            }
            this.delay = delay;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Port must be a positive integer.");
            }
            this.port = port;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            if (path == null || path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be empty.");
            }
            this.path = path;
        }
    }

    public static class StartHooksResult {
        String appId;
        String testRunId;
        String error;

        public StartHooksResult(String appId, String testRunId, String error) {
            this.appId = appId;
            this.testRunId = testRunId;
            this.error = error;
        }
    }

    public static class RunTestSetResult {
        boolean success;
        String error;

        public RunTestSetResult(boolean success, String error) {
            this.success = success;
            this.error = error;
        }
    }

    public static class StartAppResult {
        boolean success;
        String error;

        public StartAppResult(boolean success, String error) {
            this.success = success;
            this.error = error;
        }
    }

    public static class StopHooksResult {
        Boolean success;
        String error;

        public StopHooksResult(Boolean success, String error) {
            this.success = success;
            this.error = error;
        }
    }

    private static class StartHooksData {
        String appId;
        String testRunId;

        private StartHooksData() {
        }
    }
}

