/*
 * Decompiled with CFR 0.152.
 */
package io.keploy;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;

public class Keploy {
    private static final String GRAPHQL_ENDPOINT = "/query";
    private static final String HOST = "http://localhost:";
    private static final Logger logger = LogManager.getLogger(Keploy.class);
    private static int serverPort = 6789;
    private static long userCommandPid = 0L;
    private static String jacocoCliPath = "";
    private static String currentTestRunId;
    private static String jacocoAgentPath;
    private static Boolean isFailed;
    private static List<String> failedTestSets;

    public static void StartUserApplication(String runCmd) throws IOException {
        System.out.println("Starting user application:" + runCmd);
        runCmd = Keploy.attachJacocoAgent(runCmd);
        String[] command = runCmd.split(" ");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        userCommandPid = Keploy.getProcessId(process);
        Thread logThread = new Thread(() -> Keploy.logProcessOutput(process));
        logThread.start();
    }

    private static String attachJacocoAgent(String cmd) {
        String string;
        block9: {
            String resourcePath = "jacocoagent.jar";
            InputStream is = Keploy.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("jacocoagent.jar not found in resources");
                }
                Path tempFile = Files.createTempFile("jacocoagent", ".jar", new FileAttribute[0]);
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                is.close();
                String agentString = "-javaagent:" + tempFile.toAbsolutePath() + "=address=localhost,port=36320,destfile=coverage.exec,output=tcpserver";
                jacocoAgentPath = tempFile.toAbsolutePath().toString();
                string = cmd.replaceFirst("java", "java " + agentString);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Error setting up JaCoCo agent", e);
                }
            }
            is.close();
        }
        return string;
    }

    public static void FindCoverage(String testSet) throws IOException, InterruptedException {
        String dest = "target/" + testSet;
        String runCmd = "java -jar " + Keploy.getJacococliPath() + " dump --address localhost --port 36320 --destfile " + dest + ".exec";
        String[] command = runCmd.split(" ");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        Thread logThread = new Thread(() -> Keploy.logProcessOutput(process));
        logThread.start();
    }

    private static String getJacococliPath() {
        String string;
        block9: {
            String resourcePath = "jacococli.jar";
            InputStream is = Keploy.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("jacococli.jar not found in resources");
                }
                Path tempFile = Files.createTempFile("jacococli", ".jar", new FileAttribute[0]);
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                is.close();
                string = jacocoCliPath = tempFile.toAbsolutePath().toString();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Error setting up JacocoCli", e);
                }
            }
            is.close();
        }
        return string;
    }

    public static void StopUserApplication() {
        Keploy.deleteJacocoFiles();
        Keploy.killProcessesAndTheirChildren((int)userCommandPid);
    }

    private static void deleteJacocoFiles() {
        Keploy.deleteFile(jacocoAgentPath);
        Keploy.deleteFile(jacocoCliPath);
    }

    private static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            System.out.println("File not found: " + filePath);
            return false;
        }
        if (file.delete()) {
            logger.debug("File deleted successfully:", (Object)filePath);
            return true;
        }
        System.out.println("Failed to delete the file: " + filePath);
        return false;
    }

    private static long getProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.ProcessImpl")) {
            return process.pid();
        }
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return f.getLong(process);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to get process ID", e);
        }
    }

    private static void logProcessOutput(Process process) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HttpURLConnection setHttpClient() {
        try {
            URL obj = new URL(HOST + serverPort + GRAPHQL_ENDPOINT);
            logger.debug("Connecting to: " + obj.toString());
            HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(10000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("Accept", "application/json");
            conn.setInstanceFollowRedirects(false);
            return conn;
        }
        catch (Exception e) {
            logger.error("Error setting up HttpURLConnection", (Throwable)e);
            return null;
        }
    }

    public static String[] FetchTestSets() {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = "{ \"query\": \"{ testSets }\" }";
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                return response.data.testSets;
            }
        }
        catch (Exception e) {
            logger.error("Error fetching test sets", (Throwable)e);
        }
        return null;
    }

    public static TestRunStatus FetchTestSetStatus(String testRunId) {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = String.format("{ \"query\": \"{ testSetStatus(testRunId: \\\"%s\\\") { status } }\" }", testRunId);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                String testStatus = response.data.testSetStatus.status;
                if (testStatus.equals("RUNNING")) {
                    return TestRunStatus.RUNNING;
                }
                if (testStatus.equals("PASSED")) {
                    return TestRunStatus.PASSED;
                }
                if (testStatus.equals("FAILED")) {
                    return TestRunStatus.FAILED;
                }
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error fetching test sets", (Throwable)e);
        }
        return null;
    }

    public static String RunTestSet(String testSetName) {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = String.format("{ \"query\": \"mutation { runTestSet(testSet: \\\"%s\\\") { success testRunId message } }\" }", testSetName);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                return response.data.runTestSet.testRunId;
            }
        }
        catch (Exception e) {
            logger.error("Error fetching test sets", (Throwable)e);
        }
        return null;
    }

    public static Boolean StopTest() {
        try {
            HttpURLConnection conn = Keploy.setHttpClient();
            if (conn == null) {
                throw new Exception("Could not initialize HTTP connection.");
            }
            String payload = "{ \"query\": \"{ stopTest }\" }";
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes());
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            logger.debug("status code received: {}", (Object)responseCode);
            if (Keploy.isSuccessfulResponse(conn)) {
                String resBody = Keploy.getSimulateResponseBody(conn);
                logger.debug("response body received: {}", (Object)resBody);
                Gson gson = new Gson();
                GraphQLResponse response = (GraphQLResponse)gson.fromJson(resBody, GraphQLResponse.class);
                return response.data.stopTest;
            }
        }
        catch (Exception e) {
            logger.error("Error stopping the test", (Throwable)e);
        }
        return null;
    }

    private static boolean isSuccessfulResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        return responseCode >= 200 && responseCode < 300;
    }

    private static String getSimulateResponseBody(HttpURLConnection conn) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        return content.toString();
    }

    public static void killProcessOnPort(int port) {
        try {
            Process process = new ProcessBuilder("sh", "-c", "lsof -t -i:" + port).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String pids = reader.readLine();
            if (pids != null) {
                Arrays.stream(pids.split("\n")).forEach(pidStr -> {
                    if (!pidStr.isEmpty()) {
                        int pid = Integer.parseInt(pidStr.trim());
                        Keploy.killProcessesAndTheirChildren(pid);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to fetch the process ID on port " + port);
        }
    }

    public static void killProcessesAndTheirChildren(int parentPID) {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        Keploy.findAndCollectChildProcesses(String.valueOf(parentPID), pids);
        Iterator iterator = pids.iterator();
        while (iterator.hasNext()) {
            int childPID = (Integer)iterator.next();
            if (childPID == Keploy.getCurrentPid()) continue;
            try {
                new ProcessBuilder("kill", "-15", String.valueOf(childPID)).start();
                logger.debug("Killed child process " + childPID);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Failed to kill child process " + childPID);
            }
        }
    }

    public static void findAndCollectChildProcesses(String parentPID, List<Integer> pids) {
        try {
            pids.add(Integer.parseInt(parentPID));
            Process process = new ProcessBuilder("pgrep", "-P", parentPID).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = reader.readLine();
            if (output != null) {
                Arrays.stream(output.split("\n")).forEach(childPID -> {
                    if (!childPID.isEmpty()) {
                        Keploy.findAndCollectChildProcesses(childPID, pids);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getCurrentPid() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(processName.split("@")[0]);
    }

    public static void runTests(String jarPath) {
        String[] testSets = Keploy.FetchTestSets();
        if (testSets == null) {
            System.err.println("Test sets are null ");
            return;
        }
        System.out.println("TestSets: " + Arrays.asList(testSets));
        for (String testSet : testSets) {
            String testRunId = Keploy.RunTestSet(testSet);
            currentTestRunId = testSet;
            Keploy.startUserApplication(jarPath);
            Keploy.waitForTestRunCompletion(testRunId);
            try {
                Keploy.FindCoverage(testSet);
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Keploy.stopUserApplication();
        }
        logger.debug("All test sets executed and stopping the ebpf hooks");
        Keploy.StopTest();
        Keploy.checkTestRunStatus();
    }

    private static void checkTestRunStatus() {
        if (isFailed.booleanValue()) {
            Assertions.fail((String)("Test run failed for test sets : " + failedTestSets));
        }
    }

    private static void startUserApplication(String jarPath) {
        CharSequence[] command = new String[]{"java", "-jar", jarPath};
        String userCmd = String.join((CharSequence)" ", command);
        try {
            Keploy.StartUserApplication(userCmd);
            System.out.println("Application started ");
        }
        catch (IOException e) {
            System.err.println("Failed to start user application: " + e.getMessage());
        }
    }

    private static void waitForTestRunCompletion(String testRunId) {
        long MAX_TIMEOUT = 6000000L;
        long startTime = System.currentTimeMillis();
        try {
            TestRunStatus testRunStatus;
            block6: {
                do {
                    Thread.sleep(2000L);
                    testRunStatus = Keploy.FetchTestSetStatus(testRunId);
                    if (testRunStatus != TestRunStatus.RUNNING) break block6;
                } while (System.currentTimeMillis() - startTime <= MAX_TIMEOUT);
                logger.error("Test run timed out,exiting the test run");
            }
            if (testRunStatus == TestRunStatus.FAILED || testRunStatus == TestRunStatus.RUNNING) {
                logger.info("Test run failed");
                isFailed = true;
                failedTestSets.add(currentTestRunId);
            } else if (testRunStatus == TestRunStatus.PASSED) {
                logger.info("Test run passed");
            }
        }
        catch (InterruptedException e) {
            logger.error("Error waiting for test run completion: " + e.getMessage());
        }
    }

    private static void stopUserApplication() {
        Keploy.StopUserApplication();
    }

    static {
        jacocoAgentPath = "";
        isFailed = false;
        failedTestSets = new ArrayList<String>();
    }

    public class GraphQLResponse {
        Data data;

        public class RunTestSetResponse {
            Boolean success;
            String testRunId;
            String message;
        }

        public class TestSetStatus {
            String status;
        }

        public class Data {
            String[] testSets;
            Boolean stopTest;
            TestSetStatus testSetStatus;
            RunTestSetResponse runTestSet;
        }
    }

    public static enum TestRunStatus {
        RUNNING,
        PASSED,
        FAILED;

    }
}

