/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime.profiling;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.openjdk.btrace.core.Profiler;
import org.openjdk.btrace.runtime.profiling.MethodInvocationRecorder;

public class MethodInvocationProfiler
extends Profiler
implements Profiler.MBeanValueProvider {
    private final Collection<WeakReference<MethodInvocationRecorder>> recorders = new ConcurrentLinkedDeque<WeakReference<MethodInvocationRecorder>>();
    private final int expectedBlockCnt;
    private final ThreadLocal<MethodInvocationRecorder> recorder = new ThreadLocal<MethodInvocationRecorder>(){

        @Override
        protected MethodInvocationRecorder initialValue() {
            MethodInvocationRecorder mir = new MethodInvocationRecorder(MethodInvocationProfiler.this.expectedBlockCnt);
            MethodInvocationProfiler.this.recorders.add(new WeakReference<MethodInvocationRecorder>(mir));
            return mir;
        }
    };
    private volatile Profiler.Snapshot lastValidSnapshot = null;
    private long lastTs = this.START_TIME;

    public MethodInvocationProfiler(int expectedMethodCnt) {
        this.expectedBlockCnt = expectedMethodCnt;
    }

    @Override
    public void recordEntry(String blockName) {
        this.recorder.get().recordEntry(blockName);
    }

    @Override
    public void recordExit(String blockName, long duration) {
        this.recorder.get().recordExit(blockName, duration);
    }

    @Override
    public void reset() {
        for (WeakReference<MethodInvocationRecorder> mirRef : this.recorders) {
            MethodInvocationRecorder mir = (MethodInvocationRecorder)mirRef.get();
            if (mir == null) continue;
            mir.reset();
        }
    }

    @Override
    public Profiler.Snapshot snapshot(boolean reset) {
        HashMap<String, Integer> idMap = new HashMap<String, Integer>();
        Profiler.Record[] mergedRecords = null;
        int mergedEntries = 0;
        int mergedCapacity = 0;
        for (WeakReference<MethodInvocationRecorder> mirRef : this.recorders) {
            Profiler.Record[] records;
            MethodInvocationRecorder mir = (MethodInvocationRecorder)mirRef.get();
            if (mir == null || (records = mir.getRecords(reset)) == null || records.length == 0) continue;
            if (mergedRecords == null) {
                mergedRecords = records;
                mergedCapacity = mergedRecords.length;
                for (int i = 0; i < records.length; ++i) {
                    if (records[i] == null) continue;
                    mergedEntries = i + 1;
                    idMap.put(records[i].blockName, i);
                }
                continue;
            }
            for (Profiler.Record r : records) {
                Integer id = (Integer)idMap.get(r.blockName);
                if (id == null) {
                    id = mergedEntries++;
                    if (mergedEntries > mergedCapacity) {
                        mergedCapacity = (mergedEntries + 1) * 5 >> 2;
                        Profiler.Record[] newRecs = new Profiler.Record[mergedCapacity];
                        System.arraycopy(mergedRecords, 0, newRecs, 0, mergedEntries - 1);
                        mergedRecords = newRecs;
                    }
                    idMap.put(r.blockName, id);
                    mergedRecords[id.intValue()] = r;
                    continue;
                }
                Profiler.Record merged = mergedRecords[id];
                merged.invocations += r.invocations;
                merged.selfTime += r.selfTime;
                merged.wallTime += r.wallTime;
            }
        }
        Profiler.Record[] rslt = new Profiler.Record[mergedEntries];
        if (mergedRecords != null) {
            System.arraycopy(mergedRecords, 0, rslt, 0, mergedEntries);
        }
        long curTs = System.currentTimeMillis();
        Profiler.Snapshot snp = new Profiler.Snapshot(rslt, this.lastTs, curTs);
        this.lastTs = curTs;
        this.lastValidSnapshot = snp;
        return snp;
    }

    @Override
    public Profiler.Snapshot getMBeanValue() {
        return this.lastValidSnapshot;
    }
}

