/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.util.Map;
import jdk.jfr.Event;
import org.openjdk.btrace.core.jfr.JfrEvent;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

class JfrEventImpl
extends JfrEvent {
    private static final Logger log = LoggerFactory.getLogger(JfrEventImpl.class);
    private final Event event;
    private final Map<String, Integer> fieldIndex;

    JfrEventImpl(Event event, Map<String, Integer> fieldIndex) {
        this.event = event;
        this.fieldIndex = fieldIndex;
    }

    @Override
    public JfrEvent withValue(String fieldName, byte value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, boolean value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, char value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), Character.valueOf(value));
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, short value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, int value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, float value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), Float.valueOf(value));
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, long value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, double value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public JfrEvent withValue(String fieldName, String value) {
        if (this.checkField(fieldName)) {
            this.event.set(this.fieldIndex.get(fieldName), value);
        }
        return this;
    }

    @Override
    public void commit() {
        this.event.commit();
    }

    @Override
    public boolean shouldCommit() {
        return this.event.shouldCommit();
    }

    @Override
    public void begin() {
        this.event.begin();
    }

    @Override
    public void end() {
        this.event.end();
    }

    private boolean checkField(String fieldName) {
        if (!this.fieldIndex.containsKey(fieldName)) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid event field: {}", (Object)fieldName);
            }
            return false;
        }
        return true;
    }
}

