/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.lang.instrument.Instrumentation;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.BTraceRuntimeAccess;
import org.openjdk.btrace.runtime.BTraceRuntimeImplFactory;

public final class BTraceRuntimes {
    private static final Logger log = LoggerFactory.getLogger(BTraceRuntimes.class);
    private static BTraceRuntimeImplFactory<?> FACTORY = null;

    private static boolean loadFactory(String clzName) {
        try {
            log.debug("Attempting to load BTrace runtime implementation: {}", (Object)clzName);
            Class<?> factoryClz = ClassLoader.getSystemClassLoader().loadClass(clzName);
            BTraceRuntimeImplFactory instance = (BTraceRuntimeImplFactory)factoryClz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (instance.isEnabled()) {
                FACTORY = instance;
                log.debug("BTrace runtime implementation {} is loaded", (Object)clzName);
                return true;
            }
        }
        catch (ClassNotFoundException | UnsupportedClassVersionError factoryClz) {
        }
        catch (Exception e) {
            log.warn("Failed to load BTrace runtime implementation {}", (Object)clzName, (Object)e);
        }
        return false;
    }

    public static BTraceRuntime.Impl getDefault() {
        return FACTORY != null ? (BTraceRuntime.Impl)FACTORY.getDefault() : null;
    }

    public static BTraceRuntime.Impl getRuntime(String className, ArgsMap args, CommandListener cmdListener, Instrumentation inst) {
        return FACTORY != null ? (BTraceRuntime.Impl)FACTORY.getRuntime(className, args, cmdListener, inst) : null;
    }

    static {
        boolean loaded = BTraceRuntimes.loadFactory("org.openjdk.btrace.runtime.BTraceRuntimeImpl_11$Factory") || BTraceRuntimes.loadFactory("org.openjdk.btrace.runtime.BTraceRuntimeImpl_9$Factory") || BTraceRuntimes.loadFactory("org.openjdk.btrace.runtime.BTraceRuntimeImpl_8$Factory");
        log.debug("BTraceRuntime loaded: {}", (Object)loaded);
        BTraceRuntimeAccess.registerRuntimeAccessor();
    }
}

