/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.Profiler;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.comm.ErrorCommand;
import org.openjdk.btrace.core.comm.EventCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.MessageCommand;
import org.openjdk.btrace.core.handlers.ErrorHandler;
import org.openjdk.btrace.core.handlers.EventHandler;
import org.openjdk.btrace.core.handlers.ExitHandler;
import org.openjdk.btrace.core.handlers.LowMemoryHandler;
import org.openjdk.btrace.core.handlers.TimerHandler;
import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MpmcArrayQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MpscChunkedArrayQueue;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.BTraceMBean;
import org.openjdk.btrace.runtime.BTraceRuntimeAccess;
import org.openjdk.btrace.runtime.BTraceRuntimeImplFactory;
import org.openjdk.btrace.runtime.DOTWriter;
import org.openjdk.btrace.runtime.ExitException;
import org.openjdk.btrace.runtime.NullPerfReaderImpl;
import org.openjdk.btrace.runtime.PerfReader;
import org.openjdk.btrace.runtime.XMLSerializer;
import org.openjdk.btrace.runtime.profiling.MethodInvocationProfiler;
import org.openjdk.btrace.services.api.RuntimeContext;

public abstract class BTraceRuntimeImplBase
implements BTraceRuntime.Impl,
RuntimeContext {
    private static final Logger log = LoggerFactory.getLogger(BTraceRuntimeImplBase.class);
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final int CMD_QUEUE_LIMIT_DEFAULT = 100;
    private static int CMD_QUEUE_LIMIT;
    private boolean shouldInitializeMBeans = true;
    private static Properties dotWriterProps;
    private static final boolean messageTimestamp = false;
    private static volatile boolean dtraceEnabled;
    private static volatile MemoryMXBean memoryMBean;
    private static volatile List<MemoryPoolMXBean> memPoolList;
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;
    private static volatile RuntimeMXBean runtimeMBean;
    private static volatile ThreadMXBean threadMBean;
    private static volatile List<GarbageCollectorMXBean> gcBeanList;
    private static volatile OperatingSystemMXBean operatingSystemMXBean;
    private final ThreadLocal<Throwable> currentException = new ThreadLocal();
    private final ArgsMap args;
    protected volatile boolean disabled;
    private final String className;
    private Class clazz;
    private Field level;
    private TimerHandler[] timerHandlers;
    private EventHandler[] eventHandlers;
    private ErrorHandler[] errorHandlers;
    private ExitHandler[] exitHandlers;
    private LowMemoryHandler[] lowMemoryHandlers;
    private Map<String, Method> eventHandlerMap;
    private Map<String, LowMemoryHandler> lowMemoryHandlerMap;
    private volatile Timer timer;
    private volatile ExecutorService threadPool;
    private volatile NotificationListener memoryListener;
    private final MpscChunkedArrayQueue<Command> queue;
    private final SpeculativeQueueManager specQueueManager;
    private volatile Thread cmdThread;
    private final Instrumentation instrumentation;
    private final AtomicBoolean exitting = new AtomicBoolean(false);
    private final MessagePassingQueue.WaitStrategy waitStrategy = i -> {
        if (this.exitting.get()) {
            return 0;
        }
        try {
            if (i < 3000) {
                Thread.yield();
            } else if (i < 3100) {
                Thread.sleep(1L);
            } else {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            return 0;
        }
        return i + 1;
    };
    private final MessagePassingQueue.ExitCondition exitCondition = () -> !this.exitting.get();
    protected static final PerfReader perfReader;
    protected static final Map<String, ByteBuffer> counters;
    private static final BTraceRuntimeImplFactory<BTraceRuntime.Impl> factory;

    public abstract void newPerfCounter(Object var1, String var2, String var3);

    public final int getPerfInt(String name) {
        return (int)this.getPerfLong(name);
    }

    public final void putPerfInt(int value, String name) {
        this.putPerfLong(value, name);
    }

    public final float getPerfFloat(String name) {
        int val = this.getPerfInt(name);
        return Float.intBitsToFloat(val);
    }

    public final void putPerfFloat(float value, String name) {
        int i = Float.floatToRawIntBits(value);
        this.putPerfInt(i, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getPerfLong(String name) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = counters.get(name);
        synchronized (byteBuffer) {
            long l = b.getLong();
            b.rewind();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putPerfLong(long value, String name) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = counters.get(name);
        synchronized (byteBuffer) {
            b.putLong(value);
            b.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getPerfString(String name) {
        ByteBuffer b = counters.get(name);
        byte[] buf = new byte[b.limit()];
        byte t = 0;
        int i = 0;
        ByteBuffer byteBuffer = b;
        synchronized (byteBuffer) {
            while ((t = b.get()) != 0) {
                buf[i++] = t;
            }
            b.rewind();
        }
        return new String(buf, 0, i, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putPerfString(String value, String name) {
        ByteBuffer b = counters.get(name);
        byte[] v = BTraceRuntimeImplBase.getStringBytes(value);
        ByteBuffer byteBuffer = b;
        synchronized (byteBuffer) {
            b.put(v);
            b.rewind();
        }
    }

    BTraceRuntimeImplBase() {
        this.args = null;
        this.queue = null;
        this.specQueueManager = null;
        this.className = null;
        this.instrumentation = null;
    }

    BTraceRuntimeImplBase(String className, ArgsMap args, CommandListener cmdListener, Instrumentation inst) {
        this.args = args;
        this.queue = new MpscChunkedArrayQueue(CMD_QUEUE_LIMIT);
        this.specQueueManager = new SpeculativeQueueManager();
        this.className = className;
        this.instrumentation = inst;
        BTraceRuntimeAccess.addRuntime(className, this);
        this.cmdThread = new Thread(() -> {
            try {
                this.enter();
                this.queue.drain((MessagePassingQueue.Consumer)new ConsumerWrapper(cmdListener, this.exitting), this.waitStrategy, this.exitCondition);
            }
            finally {
                this.queue.clear();
                this.specQueueManager.clear();
                this.leave();
                this.disabled = true;
            }
        });
        this.cmdThread.setDaemon(true);
        this.cmdThread.start();
    }

    protected final String getClassName() {
        return this.className;
    }

    private static void setupCmdQueueParams() {
        String maxQLen = System.getProperty("org.openjdk.btrace.core.cmdQueueLimit", null);
        if (maxQLen == null) {
            CMD_QUEUE_LIMIT = 100;
        } else {
            try {
                CMD_QUEUE_LIMIT = Integer.parseInt(maxQLen);
                if (log.isDebugEnabled()) {
                    log.debug("The cmd queue limit set to {}", (Object)CMD_QUEUE_LIMIT);
                }
            }
            catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log.debug("\"{}\" is not a valid int number. Using the default cmd queue limit of {}", (Object)maxQLen, (Object)100);
                }
                CMD_QUEUE_LIMIT = 100;
            }
        }
    }

    final void init(Class cl, TimerHandler[] tHandlers, EventHandler[] evHandlers, ErrorHandler[] errHandlers, ExitHandler[] eHandlers, LowMemoryHandler[] lmHandlers) {
        if (log.isDebugEnabled()) {
            log.debug("init: clazz = {}, cl = {}", (Object)this.clazz, (Object)cl);
        }
        if (this.clazz != null) {
            return;
        }
        this.clazz = cl;
        if (log.isDebugEnabled()) {
            log.debug("init: timerHandlers = {}", (Object)Arrays.deepToString(tHandlers));
        }
        this.timerHandlers = tHandlers;
        this.eventHandlers = evHandlers;
        this.errorHandlers = errHandlers;
        this.exitHandlers = eHandlers;
        this.lowMemoryHandlers = lmHandlers;
        try {
            this.level = cl.getDeclaredField("$btrace$$level");
            this.level.setAccessible(true);
            int levelVal = BTraceRuntime.parseInt(this.args.get("level"), Integer.MIN_VALUE);
            if (levelVal > Integer.MIN_VALUE) {
                this.level.set(null, levelVal);
            }
        }
        catch (Throwable e) {
            log.debug("Instrumentation level setting not available", e);
        }
        BTraceMBean.registerMBean(this.clazz);
    }

    public final void start() {
        this.initMBeans();
        if (this.timerHandlers != null) {
            this.timer = new Timer(true);
            TimerTask[] timerTasks = new TimerTask[this.timerHandlers.length];
            this.wrapToTimerTasks(timerTasks);
            for (int index = 0; index < this.timerHandlers.length; ++index) {
                TimerHandler th = this.timerHandlers[index];
                long period = th.period;
                String periodArg = th.periodArg;
                if (periodArg != null) {
                    period = BTraceRuntime.parseLong(this.args.template(periodArg), period);
                }
                this.timer.schedule((TimerTask)timerTasks[index], period, period);
            }
        }
        if (this.lowMemoryHandlers != null) {
            this.lowMemoryHandlerMap = new HashMap<String, LowMemoryHandler>();
            for (LowMemoryHandler lmh : this.lowMemoryHandlers) {
                String poolName = this.args.template(lmh.pool);
                this.lowMemoryHandlerMap.put(poolName, lmh);
            }
            for (MemoryPoolMXBean mpoolBean : this.getMemoryPoolMXBeans()) {
                String name = mpoolBean.getName();
                LowMemoryHandler lmh = this.lowMemoryHandlerMap.get(name);
                if (lmh == null || !mpoolBean.isUsageThresholdSupported()) continue;
                mpoolBean.setUsageThreshold(lmh.threshold);
            }
            NotificationEmitter emitter = (NotificationEmitter)((Object)memoryMBean);
            emitter.addNotificationListener(this.memoryListener, null, null);
        }
        this.leave();
    }

    @Override
    public final void handleEvent(EventCommand ecmd) {
        if (this.eventHandlers != null) {
            String event;
            Method eventHandler;
            if (this.eventHandlerMap == null) {
                this.eventHandlerMap = new HashMap<String, Method>();
                for (EventHandler eh : this.eventHandlers) {
                    try {
                        String eventName = this.args.template(eh.getEvent());
                        this.eventHandlerMap.put(eventName, eh.getMethod(this.clazz));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if ((eventHandler = this.eventHandlerMap.get(event = (event = ecmd.getEvent()) != null ? event : "")) != null) {
                BTraceRuntimeAccess.doWithCurrent(() -> {
                    eventHandler.invoke(null, (Object[])null);
                    return null;
                });
            }
        }
    }

    @Override
    public final int getInstrumentationLevel() {
        BTraceRuntimeImplBase cur = this.getCurrent();
        try {
            return cur.getLevel();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public final void setInstrumentationLevel(int level) {
        BTraceRuntimeImplBase cur = this.getCurrent();
        try {
            cur.setLevel(level);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void shutdownCmdLine() {
        this.exitting.set(true);
    }

    @Override
    public final void leave() {
        BTraceRuntimeAccess.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handleException(Throwable th) {
        if (this.currentException.get() != null) {
            return;
        }
        boolean entered = BTraceRuntimeAccess.enter(this);
        try {
            this.currentException.set(th);
            if (th instanceof ExitException) {
                this.exitImpl(((ExitException)th).exitCode());
            } else if (this.errorHandlers != null) {
                for (ErrorHandler eh : this.errorHandlers) {
                    try {
                        eh.getMethod(this.clazz).invoke(null, th);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                this.enqueue(new ErrorCommand(th));
            }
        }
        finally {
            this.currentException.set(null);
            if (entered) {
                this.leave();
            }
        }
    }

    @Override
    public final int speculation() {
        return this.specQueueManager.speculation();
    }

    @Override
    public final void speculate(int id) {
        this.specQueueManager.speculate(id);
    }

    @Override
    public final void discard(int id) {
        this.specQueueManager.discard(id);
    }

    @Override
    public final void commit(int id) {
        this.specQueueManager.commit(id, this.queue);
    }

    @Override
    public final long sizeof(Object obj) {
        return this.instrumentation.getObjectSize(obj);
    }

    @Override
    public final int $length() {
        return this.args == null ? 0 : this.args.size();
    }

    @Override
    public final String $(int n) {
        if (this.args == null) {
            return null;
        }
        return this.args.get(n);
    }

    @Override
    public final String $(String key) {
        BTraceRuntimeImplBase runtime = this.getCurrent();
        if (this.args == null) {
            return null;
        }
        return this.args.get(key);
    }

    @Override
    public final int perfInt(String name) {
        return BTraceRuntimeImplBase.getPerfReader().perfInt(name);
    }

    @Override
    public final long perfLong(String name) {
        return BTraceRuntimeImplBase.getPerfReader().perfLong(name);
    }

    @Override
    public final String perfString(String name) {
        return BTraceRuntimeImplBase.getPerfReader().perfString(name);
    }

    @Override
    public final String toXML(Object obj) {
        try {
            return XMLSerializer.toXML(obj);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    @Override
    public final void writeXML(Object obj, String fileName) {
        try {
            Path p = FileSystems.getDefault().getPath(this.resolveFileName(fileName), new String[0]);
            try (BufferedWriter bw = Files.newBufferedWriter(p, StandardCharsets.UTF_8, new OpenOption[0]);){
                XMLSerializer.write(obj, bw);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static synchronized void initDOTWriterProps() {
        if (dotWriterProps == null) {
            dotWriterProps = new Properties();
            InputStream is = BTraceRuntime.class.getResourceAsStream("resources/btrace.dotwriter.properties");
            if (is != null) {
                try {
                    dotWriterProps.load(is);
                }
                catch (IOException ioExp) {
                    ioExp.printStackTrace();
                }
            }
            try {
                String home = System.getProperty("user.home");
                File file = new File(home, "btrace.dotwriter.properties");
                if (file.exists() && file.isFile()) {
                    is = new BufferedInputStream(new FileInputStream(file));
                    dotWriterProps.load(is);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    @Override
    public final void writeDOT(Object obj, String fileName) {
        DOTWriter writer = new DOTWriter(this.resolveFileName(fileName));
        BTraceRuntimeImplBase.initDOTWriterProps();
        writer.customize(dotWriterProps);
        writer.addNode(null, obj);
        writer.close();
    }

    @Override
    public final Profiler newProfiler() {
        return new MethodInvocationProfiler(600);
    }

    @Override
    public final Profiler newProfiler(int expectedMethodCnt) {
        return new MethodInvocationProfiler(expectedMethodCnt);
    }

    @Override
    public final RuntimeMXBean getRuntimeMXBean() {
        this.initMBeans();
        return runtimeMBean;
    }

    @Override
    public final ThreadMXBean getThreadMXBean() {
        this.initMBeans();
        return threadMBean;
    }

    @Override
    public final OperatingSystemMXBean getOperatingSystemMXBean() {
        this.initMBeans();
        return operatingSystemMXBean;
    }

    @Override
    public final List<GarbageCollectorMXBean> getGCMBeans() {
        this.initMBeans();
        return gcBeanList;
    }

    @Override
    public final HotSpotDiagnosticMXBean getHotspotMBean() {
        this.initMBeans();
        return hotspotMBean;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public final boolean enter() {
        return BTraceRuntimeAccess.enter(this);
    }

    @Override
    public final void handleExit(int exitCode) {
        this.exitImpl(exitCode);
        try {
            this.cmdThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.cleanupRuntime();
    }

    public final int getLevel() {
        try {
            return (Integer)this.level.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            return 0;
        }
    }

    public final void setLevel(int level) {
        try {
            this.level.set(null, level);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected void cleanupRuntime() {
    }

    protected static void loadLibrary(ClassLoader cl) {
        AccessController.doPrivileged(() -> {
            BTraceRuntimeImplBase.loadBTraceLibrary(cl);
            return null;
        });
    }

    private static void loadBTraceLibrary(ClassLoader loader) {
        boolean isSolaris = System.getProperty("os.name").equals("SunOS");
        if (isSolaris) {
            try {
                System.loadLibrary("btrace");
                dtraceEnabled = true;
            }
            catch (LinkageError le) {
                URL btracePkg = null;
                if (loader != null) {
                    btracePkg = loader.getResource("org/openjdk/btrace");
                }
                if (btracePkg == null) {
                    log.debug("cannot load libbtrace.so, will miss DTrace probes from BTrace");
                    return;
                }
                String path = btracePkg.toString();
                int archSeparator = path.indexOf(33);
                if (archSeparator != -1) {
                    path = path.substring(0, archSeparator);
                    path = path.substring("jar:".length(), path.lastIndexOf(47));
                } else {
                    int buildSeparator = path.indexOf("/classes/");
                    if (buildSeparator != -1) {
                        path = path.substring(0, buildSeparator);
                    }
                }
                String cpu = System.getProperty("os.arch");
                if (cpu.equals("x86")) {
                    cpu = "i386";
                }
                path = path + "/" + cpu + "/libbtrace.so";
                try {
                    path = new File(new URI(path)).getAbsolutePath();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    System.load(path);
                    dtraceEnabled = true;
                }
                catch (LinkageError le1) {
                    log.debug("cannot load libbtrace.so, will miss DTrace probes from BTrace");
                }
            }
        }
    }

    private BTraceRuntimeImplBase getCurrent() {
        return BTraceRuntimeAccess.getCurrent();
    }

    private void initThreadPool() {
        this.threadPool = Executors.newFixedThreadPool(1, r -> {
            Thread th = new Thread(r, "BTrace Worker");
            th.setDaemon(true);
            return th;
        });
    }

    private synchronized void initMBeans() {
        if (this.shouldInitializeMBeans) {
            BTraceRuntimeImplBase.initMemoryMBean();
            BTraceRuntimeImplBase.initOperatingSystemMBean();
            BTraceRuntimeImplBase.initRuntimeMBean();
            BTraceRuntimeImplBase.initThreadMBean();
            BTraceRuntimeImplBase.initHotspotMBean();
            BTraceRuntimeImplBase.initGcMBeans();
            BTraceRuntimeImplBase.initMemoryPoolList();
            this.initMemoryListener();
            this.shouldInitializeMBeans = false;
        }
    }

    private void initMemoryListener() {
        this.initThreadPool();
        this.memoryListener = (notif, handback) -> {
            boolean entered = this.enter();
            try {
                CompositeData cd2;
                MemoryNotificationInfo info;
                String name;
                LowMemoryHandler handler;
                String notifType = notif.getType();
                if (notifType.equals("java.management.memory.threshold.exceeded") && (handler = this.lowMemoryHandlerMap.get(name = (info = MemoryNotificationInfo.from(cd2 = (CompositeData)notif.getUserData())).getPoolName())) != null) {
                    this.threadPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            boolean entered = BTraceRuntimeImplBase.this.enter();
                            try {
                                if (handler.trackUsage) {
                                    handler.invoke(BTraceRuntimeImplBase.this.clazz, null, info.getUsage());
                                } else {
                                    handler.invoke(BTraceRuntimeImplBase.this.clazz, null, null);
                                }
                            }
                            catch (Throwable throwable) {
                            }
                            finally {
                                if (entered) {
                                    BTraceRuntime.leave();
                                }
                            }
                        }
                    });
                }
            }
            finally {
                if (entered) {
                    BTraceRuntime.leave();
                }
            }
        };
    }

    @Override
    public final void send(String msg) {
        this.send(new MessageCommand(0L, msg));
    }

    @Override
    public final void send(Command cmd) {
        boolean speculated = this.specQueueManager.send(cmd);
        if (!speculated) {
            this.enqueue(cmd);
        }
    }

    private void enqueue(Command cmd) {
        int backoffCntr = 0;
        while (!Thread.interrupted() && this.queue != null && !this.queue.relaxedOffer((Object)cmd)) {
            if (backoffCntr < 3000) {
                Thread.yield();
            } else if (backoffCntr < 3100) {
                LockSupport.parkNanos(1000000L);
            } else {
                LockSupport.parkNanos(100000000L);
            }
            ++backoffCntr;
        }
    }

    private void wrapToTimerTasks(TimerTask[] tasks) {
        for (int index = 0; index < this.timerHandlers.length; ++index) {
            final TimerHandler th = this.timerHandlers[index];
            tasks[index] = new TimerTask(){
                final Method mthd;
                {
                    Method m3 = null;
                    try {
                        m3 = th.getMethod(BTraceRuntimeImplBase.this.clazz);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    this.mthd = m3;
                }

                @Override
                public void run() {
                    if (this.mthd != null) {
                        try {
                            this.mthd.invoke(null, (Object[])null);
                        }
                        catch (Throwable th2) {
                            th2.printStackTrace();
                        }
                    }
                }
            };
        }
    }

    @Override
    public final void exit(int exitCode) {
        this.exitImpl(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void exitImpl(int exitCode) {
        boolean entered = this.enter();
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (this.memoryListener != null && memoryMBean != null) {
                NotificationEmitter emitter = (NotificationEmitter)((Object)memoryMBean);
                try {
                    emitter.removeNotificationListener(this.memoryListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            }
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
            if (this.exitHandlers != null) {
                for (ExitHandler eh : this.exitHandlers) {
                    try {
                        eh.getMethod(this.clazz).invoke(null, exitCode);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.exitHandlers = null;
            }
            this.send(new ExitCommand(exitCode));
        }
        finally {
            this.disabled = true;
            if (entered) {
                BTraceRuntime.leave();
            }
        }
    }

    @Override
    public final String resolveFileName(String name) {
        if (name.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("directories are not allowed");
        }
        StringBuilder buf = new StringBuilder();
        buf.append('.');
        buf.append(File.separatorChar);
        buf.append("btrace");
        if (this.args != null && this.args.size() > 0) {
            buf.append(this.args.get(0));
        }
        buf.append(File.separatorChar);
        buf.append(this.className);
        new File(buf.toString()).mkdirs();
        buf.append(File.separatorChar);
        buf.append(name);
        return buf.toString();
    }

    private static void initMemoryPoolList() {
        try {
            memPoolList = AccessController.doPrivileged(ManagementFactory::getMemoryPoolMXBeans);
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    private static void initMemoryMBean() {
        try {
            memoryMBean = AccessController.doPrivileged(ManagementFactory::getMemoryMXBean);
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    private static void initOperatingSystemMBean() {
        try {
            operatingSystemMXBean = AccessController.doPrivileged(ManagementFactory::getOperatingSystemMXBean);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static void initRuntimeMBean() {
        try {
            runtimeMBean = AccessController.doPrivileged(ManagementFactory::getRuntimeMXBean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initThreadMBean() {
        try {
            threadMBean = AccessController.doPrivileged(ManagementFactory::getThreadMXBean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initGcMBeans() {
        try {
            gcBeanList = AccessController.doPrivileged(ManagementFactory::getGarbageCollectorMXBeans);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initHotspotMBean() {
        try {
            hotspotMBean = AccessController.doPrivileged(() -> {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> s2 = server.queryNames(new ObjectName(HOTSPOT_BEAN_NAME), null);
                Iterator<ObjectName> itr = s2.iterator();
                if (itr.hasNext()) {
                    ObjectName name = itr.next();
                    return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), HotSpotDiagnosticMXBean.class);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public boolean isDTraceEnabled() {
        return dtraceEnabled;
    }

    @Override
    public List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        this.initMBeans();
        return memPoolList;
    }

    @Override
    public MemoryMXBean getMemoryMXBean() {
        this.initMBeans();
        return memoryMBean;
    }

    protected static PerfReader getPerfReader() {
        return perfReader;
    }

    protected static byte[] getStringBytes(String value) {
        byte[] v = null;
        v = value.getBytes(StandardCharsets.UTF_8);
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return v1;
    }

    private static PerfReader createPerfReaderImpl() {
        try {
            if (String.class.getResource("sun/jvmstat/monitor/MonitoredHost.class") != null) {
                return (PerfReader)Class.forName("org.openjdk.btrace.agent.PerfReaderImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new NullPerfReaderImpl();
    }

    static {
        perfReader = BTraceRuntimeImplBase.createPerfReaderImpl();
        counters = new HashMap<String, ByteBuffer>();
        factory = null;
        BTraceRuntimeImplBase.setupCmdQueueParams();
        BTraceRuntimeImplBase.loadLibrary(perfReader.getClass().getClassLoader());
    }

    private static class SpeculativeQueueManager {
        private static final int MAX_SPECULATIVE_BUFFERS = Short.MAX_VALUE;
        private static final int MAX_SPECULATIVE_MSG_LIMIT = Short.MAX_VALUE;
        private int nextSpeculationId;
        private ConcurrentHashMap<Integer, MpmcArrayQueue<Command>> speculativeQueues = new ConcurrentHashMap();
        private ThreadLocal<Integer> currentSpeculationId = new ThreadLocal();

        SpeculativeQueueManager() {
        }

        void clear() {
            this.speculativeQueues.clear();
            this.speculativeQueues = null;
            this.currentSpeculationId.remove();
            this.currentSpeculationId = null;
        }

        int speculation() {
            int nextId = this.getNextSpeculationId();
            if (nextId != -1) {
                this.speculativeQueues.put(nextId, new MpmcArrayQueue(Short.MAX_VALUE));
            }
            return nextId;
        }

        boolean send(Command cmd) {
            MpmcArrayQueue<Command> sb;
            Integer curId;
            if (this.currentSpeculationId != null && (curId = this.currentSpeculationId.get()) != null && cmd.getType() != 2 && (sb = this.speculativeQueues.get(curId)) != null) {
                if (!sb.offer(cmd)) {
                    sb.clear();
                    sb.offer(new MessageCommand("speculative buffer overflow: " + curId));
                }
                return true;
            }
            return false;
        }

        void speculate(int id) {
            this.validateId(id);
            this.currentSpeculationId.set(id);
        }

        void commit(int id, MpscChunkedArrayQueue<Command> result) {
            this.validateId(id);
            this.currentSpeculationId.set(null);
            MpmcArrayQueue<Command> sb = this.speculativeQueues.get(id);
            if (sb != null) {
                result.addAll(sb);
                sb.clear();
            }
        }

        void discard(int id) {
            this.validateId(id);
            this.currentSpeculationId.set(null);
            this.speculativeQueues.get(id).clear();
        }

        private synchronized int getNextSpeculationId() {
            if (this.nextSpeculationId == Short.MAX_VALUE) {
                return -1;
            }
            return this.nextSpeculationId++;
        }

        private void validateId(int id) {
            if (!this.speculativeQueues.containsKey(id)) {
                throw new RuntimeException("invalid speculative buffer id: " + id);
            }
        }
    }

    private static final class ConsumerWrapper
    implements MessagePassingQueue.Consumer<Command> {
        private final CommandListener cmdHandler;
        private final AtomicBoolean exitSignal;

        public ConsumerWrapper(CommandListener cmdHandler, AtomicBoolean exitSignal) {
            this.cmdHandler = cmdHandler;
            this.exitSignal = exitSignal;
        }

        @Override
        public void accept(Command t) {
            try {
                this.cmdHandler.onCommand(t);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            if (t.getType() == 2) {
                this.exitSignal.set(true);
            }
        }
    }
}

