/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.queues.atomic.AtomicQueueUtil;
import org.openjdk.btrace.libs.org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import org.openjdk.btrace.libs.org.jctools.util.Pow2;
import org.openjdk.btrace.libs.org.jctools.util.RangeUtil;

public class SpscChunkedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    private final int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedAtomicArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscChunkedAtomicArrayQueue(int chunkSize, int capacity) {
        AtomicReferenceArray buffer;
        RangeUtil.checkGreaterThanOrEqual(capacity, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(chunkSize, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        RangeUtil.checkLessThan(chunkCapacity, this.maxQueueCapacity, "chunkCapacity");
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = AtomicQueueUtil.allocateRefArray(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, long pIndex, int offset, E v, MessagePassingQueue.Supplier<? extends E> s2) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        long pQueueLimit = this.producerQueueLimit;
        if (pIndex >= pQueueLimit) {
            long cIndex = this.lvConsumerIndex();
            this.producerQueueLimit = pQueueLimit = cIndex + (long)this.maxQueueCapacity;
            if (pIndex >= pQueueLimit) {
                return false;
            }
        }
        if (pBufferLimit - pQueueLimit > 0L) {
            pBufferLimit = pQueueLimit;
        }
        if (pBufferLimit > pIndex + 1L && null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s2.get() : v, pIndex, offset);
        } else if (null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, v == null ? s2.get() : v, pIndex, offset);
        } else {
            AtomicReferenceArray newBuffer;
            this.producerBuffer = newBuffer = AtomicQueueUtil.allocateRefArray((int)(mask + 2L));
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s2.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

