/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr.templates;

import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.btrace.core.MethodID;
import org.openjdk.btrace.instr.Assembler;
import org.openjdk.btrace.instr.BTraceMethodVisitor;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.instr.templates.BTraceTemplates;
import org.openjdk.btrace.instr.templates.Template;
import org.openjdk.btrace.instr.templates.TemplateExpander;
import org.openjdk.btrace.instr.templates.impl.MethodTrackingExpander;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Attribute;
import org.openjdk.btrace.libs.org.objectweb.asm.Handle;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.TypePath;

public class TemplateExpanderVisitor
extends BTraceMethodVisitor {
    private final Collection<TemplateExpander> expanders = new ArrayList<TemplateExpander>();
    private final BTraceProbe bcn;
    private final String className;
    private final String methodName;
    private final String desc;
    private final Assembler asm;
    private TemplateExpander.Result lastResult = TemplateExpander.Result.IGNORED;
    private boolean expanding = false;

    public TemplateExpanderVisitor(MethodVisitor mv, MethodInstrumentorHelper mHelper, BTraceProbe bcn, String className, String methodName, String desc) {
        super(mv, mHelper);
        this.expanders.add(new MethodTrackingExpander(MethodID.getMethodId(className, methodName, desc), mHelper));
        this.bcn = bcn;
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.asm = new Assembler(mv, mHelper);
    }

    public Assembler asm() {
        return this.asm;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isIface) {
        Template t = BTraceTemplates.getTemplate(owner, name, desc);
        if (this.expandTemplate(t) == TemplateExpander.Result.IGNORED) {
            super.visitMethodInsn(opcode, owner, name, desc, isIface);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitVarInsn(opcode, var);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int i) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitMultiANewArrayInsn(string, i);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitLookupSwitchInsn(label, ints, labels);
        }
    }

    @Override
    public void visitTableSwitchInsn(int i, int i1, Label label, Label ... labels) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitTableSwitchInsn(i, i1, label, labels);
        }
    }

    @Override
    public void visitIincInsn(int i, int i1) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitIincInsn(i, i1);
        }
    }

    @Override
    public void visitLdcInsn(Object o) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitLdcInsn(o);
        }
    }

    @Override
    public void visitJumpInsn(int i, Label label) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitJumpInsn(i, label);
        }
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string1, Handle handle, Object ... os) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitInvokeDynamicInsn(string, string1, handle, os);
        }
    }

    @Override
    public void visitFieldInsn(int i, String string, String string1, String string2) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitFieldInsn(i, string, string1, string2);
        }
    }

    @Override
    public void visitTypeInsn(int i, String string) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitTypeInsn(i, string);
        }
    }

    @Override
    public void visitIntInsn(int i, int i1) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitIntInsn(i, i1);
        }
    }

    @Override
    public void visitInsn(int i) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            switch (i) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    this.resetState();
                }
            }
            super.visitInsn(i);
        }
    }

    @Override
    public void visitLineNumber(int i, Label label) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitLineNumber(i, label);
        }
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int i, TypePath tp, Label[] labels, Label[] labels1, int[] ints, String string, boolean bln) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitLocalVariableAnnotation(i, tp, labels, labels1, ints, string, bln);
        }
        return null;
    }

    @Override
    public void visitLocalVariable(String string, String string1, String string2, Label label, Label label1, int i) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitLocalVariable(string, string1, string2, label, label1, i);
        }
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int i, TypePath tp, String string, boolean bln) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitTryCatchAnnotation(i, tp, string, bln);
        }
        return null;
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label1, Label label2, String string) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitTryCatchBlock(label, label1, label2, string);
        }
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int i, TypePath tp, String string, boolean bln) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitInsnAnnotation(i, tp, string, bln);
        }
        return null;
    }

    @Override
    public void visitLabel(Label label) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitLabel(label);
        }
    }

    @Override
    public void visitAttribute(Attribute atrbt) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitAttribute(atrbt);
        }
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int i, String string, boolean bln) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitParameterAnnotation(i, string, bln);
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int i, TypePath tp, String string, boolean bln) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitTypeAnnotation(i, tp, string, bln);
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bln) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitAnnotation(string, bln);
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            return super.visitAnnotationDefault();
        }
        return null;
    }

    @Override
    public void visitParameter(String string, int i) {
        if (this.expandTemplate(null) == TemplateExpander.Result.IGNORED) {
            super.visitParameter(string, i);
        }
    }

    @Override
    public void visitEnd() {
        this.expandTemplate(null);
        super.visitEnd();
    }

    @Override
    public void visitMaxs(int stack, int locals) {
        this.expandTemplate(null);
        super.visitMaxs(stack, locals);
    }

    public String getProbeClassName(boolean internal) {
        return this.bcn.getClassName(internal);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDesc() {
        return this.desc;
    }

    private TemplateExpander.Result expandTemplate(Template newTemplate) {
        if (this.expanding) {
            return TemplateExpander.Result.IGNORED;
        }
        if (newTemplate == null && this.lastResult == TemplateExpander.Result.IGNORED) {
            return TemplateExpander.Result.IGNORED;
        }
        for (TemplateExpander exp : this.expanders) {
            TemplateExpander.Result r = exp.expand(this, newTemplate);
            if (r == TemplateExpander.Result.IGNORED) continue;
            this.lastResult = r;
            return r;
        }
        this.lastResult = TemplateExpander.Result.IGNORED;
        return TemplateExpander.Result.IGNORED;
    }

    private void resetState() {
        for (TemplateExpander exp : this.expanders) {
            exp.resetState();
        }
    }

    public void expand(TemplateExpander.Consumer<TemplateExpanderVisitor> f) {
        try {
            if (!this.expanding) {
                this.expanding = true;
                f.consume(this);
            }
        }
        finally {
            this.expanding = false;
        }
    }
}

