/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.openjdk.btrace.instr.ProbeDescriptor;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

final class ProbeDescriptorLoader {
    private static final Logger log = LoggerFactory.getLogger(ProbeDescriptorLoader.class);
    private static final Map<String, ProbeDescriptor> probeDescMap = new ConcurrentHashMap<String, ProbeDescriptor>();
    private final String[] probeDescDirs;

    ProbeDescriptorLoader(String probeDescPath) {
        this.probeDescDirs = probeDescPath != null ? probeDescPath.split(File.pathSeparator) : null;
    }

    ProbeDescriptor load(String namespace) {
        ProbeDescriptor res = probeDescMap.get(namespace);
        if (res != null) {
            if (log.isDebugEnabled()) {
                log.debug("probe descriptor cache hit for namespace {}", (Object)namespace);
            }
            return res;
        }
        InputStream file = this.openDescriptor(namespace);
        if (file == null) {
            if (log.isDebugEnabled()) {
                log.debug("didn't find probe descriptor file for namespace {}", (Object)namespace);
            }
            return null;
        }
        ProbeDescriptor pd = this.load(file);
        if (pd != null) {
            if (log.isDebugEnabled()) {
                log.debug("read probe descriptor for namespace {}", (Object)namespace);
            }
            probeDescMap.put(namespace, pd);
        }
        return pd;
    }

    private ProbeDescriptor load(InputStream stream) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.openjdk.btrace.core.annotations:org.openjdk.btrace.instr");
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            ProbeDescriptor pd = (ProbeDescriptor)u.unmarshal(stream);
            pd.setProbes(pd.getProbes());
            return pd;
        }
        catch (JAXBException exp) {
            log.debug("Failed to load a BTrace probe descriptor", exp);
            return null;
        }
    }

    private InputStream openDescriptor(String namespace) {
        InputStream is = null;
        if (this.probeDescDirs != null) {
            is = this.openDescriptorFromDirs(namespace);
        }
        if (is == null) {
            is = this.openDescriptorFromClassPath(namespace);
        }
        if (is == null && log.isDebugEnabled()) {
            log.debug("no probe descriptor found for namespace {}", (Object)namespace);
        }
        return is;
    }

    private InputStream openDescriptorFromDirs(String namespace) {
        String desc = namespace.trim() + ".xml";
        for (String dir : this.probeDescDirs) {
            File f = new File(dir.trim(), desc);
            if (log.isDebugEnabled()) {
                log.debug("looking for probe descriptor file '{}' ({}, {})", f.getPath(), f.exists(), f.isFile());
            }
            if (!f.exists() || !f.isFile()) continue;
            if (log.isDebugEnabled()) {
                log.debug("probe descriptor for namespace {} is {}", (Object)namespace, (Object)f);
            }
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream openDescriptorFromClassPath(String namespace) {
        String target = "META-INF/btrace/" + namespace.trim() + ".xml";
        if (log.isDebugEnabled()) {
            log.debug("looking for probe descriptor file '{}'", (Object)target);
        }
        return ClassLoader.getSystemResourceAsStream(target);
    }
}

