/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openjdk.btrace.core.PrefixMap;
import org.openjdk.btrace.core.annotations.BTrace;
import org.openjdk.btrace.instr.ClassCache;
import org.openjdk.btrace.instr.ClassInfo;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Attribute;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.FieldVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class ClassFilter {
    private static final Class<?> REFERENCE_CLASS = Reference.class;
    private static final PrefixMap SENSITIVE_CLASSES = new PrefixMap();
    private final List<OnMethod> onMethods = new ArrayList<OnMethod>();
    private Set<String> sourceClasses;
    private Pattern[] sourceClassPatterns;
    private String[] annotationClasses;
    private Pattern[] annotationClassPatterns;
    private String[] superTypes;
    private String[] superTypesInternal;

    public ClassFilter(Iterable<OnMethod> onMethods) {
        for (OnMethod om : onMethods) {
            this.onMethods.add(om);
        }
        this.init();
    }

    public static boolean isSubTypeOf(Class<?> clazz, String typeName) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(typeName)) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!ClassFilter.isSubTypeOf(iface, typeName)) continue;
            return true;
        }
        return ClassFilter.isSubTypeOf(clazz.getSuperclass(), typeName);
    }

    public static boolean isSubTypeOf(String typeA, ClassLoader loader, String ... types) {
        if (typeA == null || typeA.equals("java/lang/Object")) {
            return false;
        }
        if (types.length == 0) {
            return false;
        }
        boolean internal = types[0].contains("/");
        loader = loader != null ? loader : ClassLoader.getSystemClassLoader();
        typeA = internal ? typeA.replace('.', '/') : typeA.replace('/', '.');
        HashSet<String> typeSet = new HashSet<String>(Arrays.asList(types));
        if (typeSet.contains(typeA)) {
            return true;
        }
        ClassInfo ci = ClassCache.getInstance().get(loader, typeA);
        Collection<ClassInfo> sTypesInfo = ci.getSupertypes(false);
        if (sTypesInfo != null) {
            ArrayList<String> sTypes = new ArrayList<String>(sTypesInfo.size());
            for (ClassInfo sCi : sTypesInfo) {
                sTypes.add(internal ? sCi.getClassName() : sCi.getJavaClassName());
            }
            sTypes.retainAll(typeSet);
            return !sTypes.isEmpty();
        }
        return false;
    }

    public static boolean isSensitiveClass(String name) {
        return SENSITIVE_CLASSES.contains(name);
    }

    public boolean isCandidate(Class<?> target) {
        if (target.isInterface() || target.isPrimitive() || target.isArray()) {
            return false;
        }
        if (REFERENCE_CLASS.equals(target)) {
            return false;
        }
        try {
            if (target.getAnnotation(BTrace.class) != null) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        String className = target.getName();
        if (this.isNameMatching(className)) {
            return true;
        }
        for (Pattern pat : this.sourceClassPatterns) {
            if (!pat.matcher(className).matches()) continue;
            return true;
        }
        for (String st : this.superTypes) {
            if (!ClassFilter.isSubTypeOf(target, st)) continue;
            return true;
        }
        Annotation[] annotations = target.getAnnotations();
        String[] annoTypes = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annoTypes[i] = annotations[i].annotationType().getName();
        }
        for (String name : this.annotationClasses) {
            for (String annoType : annoTypes) {
                if (!name.equals(annoType)) continue;
                return true;
            }
        }
        for (Pattern pat : this.annotationClassPatterns) {
            for (String annoType : annoTypes) {
                if (!pat.matcher(annoType).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNameMatching(String clzName) {
        if (this.sourceClasses.contains(clzName)) {
            return true;
        }
        for (Pattern pat : this.sourceClassPatterns) {
            if (!pat.matcher(clzName).matches()) continue;
            return true;
        }
        return false;
    }

    private void init() {
        ArrayList<String> strSrcList = new ArrayList<String>();
        ArrayList<Pattern> patSrcList = new ArrayList<Pattern>();
        ArrayList<String> superTypesList = new ArrayList<String>();
        ArrayList<String> superTypesInternalList = new ArrayList<String>();
        ArrayList<String> strAnoList = new ArrayList<String>();
        ArrayList<Pattern> patAnoList = new ArrayList<Pattern>();
        for (OnMethod om : this.onMethods) {
            String className = om.getClazz();
            if (className.length() == 0) continue;
            if (om.isClassRegexMatcher()) {
                try {
                    Pattern p = Pattern.compile(className);
                    if (om.isClassAnnotationMatcher()) {
                        patAnoList.add(p);
                        continue;
                    }
                    patSrcList.add(p);
                }
                catch (PatternSyntaxException pse) {
                    System.err.println("btrace ERROR: invalid regex pattern - " + className.substring(1, className.length() - 1));
                }
                continue;
            }
            if (om.isClassAnnotationMatcher()) {
                strAnoList.add(className);
                continue;
            }
            if (om.isSubtypeMatcher()) {
                superTypesList.add(className);
                superTypesInternalList.add(className.replace('.', '/'));
                continue;
            }
            strSrcList.add(className);
        }
        this.sourceClasses = new HashSet<String>(strSrcList.size());
        this.sourceClasses.addAll(strSrcList);
        this.sourceClassPatterns = new Pattern[patSrcList.size()];
        patSrcList.toArray(this.sourceClassPatterns);
        this.superTypes = new String[superTypesList.size()];
        superTypesList.toArray(this.superTypes);
        this.superTypesInternal = new String[superTypesInternalList.size()];
        superTypesInternalList.toArray(this.superTypesInternal);
        this.annotationClasses = new String[strAnoList.size()];
        strAnoList.toArray(this.annotationClasses);
        this.annotationClassPatterns = new Pattern[patAnoList.size()];
        patAnoList.toArray(this.annotationClassPatterns);
    }

    static {
        ClassReader.class.getClassLoader();
        AnnotationVisitor.class.getClassLoader();
        FieldVisitor.class.getClassLoader();
        MethodVisitor.class.getClassLoader();
        Attribute.class.getClassLoader();
        SENSITIVE_CLASSES.add("java/lang/Object");
        SENSITIVE_CLASSES.add("java/lang/String");
        SENSITIVE_CLASSES.add("java/lang/Shutdown");
        SENSITIVE_CLASSES.add("java/lang/ThreadLocal");
        SENSITIVE_CLASSES.add("java/lang/VerifyError");
        SENSITIVE_CLASSES.add("java/lang/instrument/");
        SENSITIVE_CLASSES.add("java/lang/invoke/");
        SENSITIVE_CLASSES.add("java/lang/ref/");
        SENSITIVE_CLASSES.add("java/lang/concurrent/");
        SENSITIVE_CLASSES.add("sun/reflect");
        SENSITIVE_CLASSES.add("sun/misc/Unsafe");
        SENSITIVE_CLASSES.add("sun/security/");
        SENSITIVE_CLASSES.add("org/openjdk/btrace/");
        SENSITIVE_CLASSES.add("com/sun/proxy/");
        SENSITIVE_CLASSES.add("sun/instrument/");
        SENSITIVE_CLASSES.add("java/lang/ClassValue");
        SENSITIVE_CLASSES.add("java/lang/Throwable$PrintStreamOrWriter");
        SENSITIVE_CLASSES.add("java/lang/Throwable$WrappedPrintStream");
        SENSITIVE_CLASSES.add("java/lang/StackTraceElement");
        SENSITIVE_CLASSES.add("java/lang/StackWalker");
        SENSITIVE_CLASSES.add("java/lang/WeakPairMap$Pair$Weak");
        SENSITIVE_CLASSES.add("java/util/concurrent/locks/");
        SENSITIVE_CLASSES.add("java/nio/charset/");
        SENSITIVE_CLASSES.add("java/nio/HeapCharBuffer");
        SENSITIVE_CLASSES.add("java/nio/CharBuffer");
        SENSITIVE_CLASSES.add("java/nio/Buffer");
        SENSITIVE_CLASSES.add("java/nio/ByteBuffer");
        SENSITIVE_CLASSES.add("java/nio/HeapByteBuffer");
        SENSITIVE_CLASSES.add("jdk/internal/misc/");
        SENSITIVE_CLASSES.add("jdk/internal/reflect/GeneratedConstructorAccessor1");
        SENSITIVE_CLASSES.add("sun/invoke/");
        SENSITIVE_CLASSES.add("java/lang/");
        SENSITIVE_CLASSES.add("java/util/");
        SENSITIVE_CLASSES.add("com/sun/");
    }
}

