/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.handlers;

import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class LowMemoryHandler {
    public final String method;
    public final String pool;
    public final String thresholdProperty;
    public final long threshold;
    public final boolean trackUsage;
    private Method executable;

    public LowMemoryHandler(String method, String pool, long threshold, String thresholdProperty, boolean trackUsage) {
        this.method = method;
        this.pool = pool;
        this.threshold = threshold;
        this.thresholdProperty = thresholdProperty;
        this.trackUsage = trackUsage;
    }

    public synchronized Method getMethod(Class<?> clz) throws NoSuchMethodException {
        if (this.executable == null) {
            this.executable = this.trackUsage ? clz.getMethod(this.method, MemoryUsage.class) : clz.getMethod(this.method, new Class[0]);
        }
        return this.executable;
    }

    public void invoke(Class<?> clz, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.getMethod(clz).invoke(clz, null, args);
    }
}

