/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.comm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openjdk.btrace.core.comm.DataCommand;

public class MessageCommand
extends DataCommand {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm:ss:SSS"));
    private long time;
    private String msg;

    public MessageCommand(long time, String msg) {
        this(time, msg, false);
    }

    public MessageCommand(long time, String msg, boolean urgent) {
        super((byte)4, null, urgent);
        this.time = time;
        this.msg = msg;
    }

    public MessageCommand(String msg) {
        this(msg, false);
    }

    public MessageCommand(String msg, boolean urgent) {
        this(0L, msg, urgent);
    }

    protected MessageCommand() {
        this(0L, null);
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isUrgent());
        out.writeLong(this.time);
        byte[] bytes = this.msg != null ? this.msg.getBytes(StandardCharsets.UTF_8) : new byte[]{};
        out.writeInt(bytes.length);
        if (bytes.length > 0) {
            out.write(bytes);
        }
    }

    @Override
    protected void read(ObjectInput in) throws ClassNotFoundException, IOException {
        if (in.readBoolean()) {
            this.setUrgent();
        }
        this.time = in.readLong();
        int len = in.readInt();
        byte[] bytes = new byte[len];
        for (int ptr = 0; ptr < len; ptr += in.read(bytes, ptr, len - ptr)) {
        }
        this.msg = new String(bytes, StandardCharsets.UTF_8);
    }

    public long getTime() {
        return this.time;
    }

    public String getMessage() {
        return this.msg;
    }

    @Override
    public void print(PrintWriter out) {
        if (this.time != 0L) {
            out.print(DATE_FORMAT.get().format(new Date(this.time)));
            out.print(" : ");
        }
        if (this.msg != null) {
            out.println(this.msg);
        }
        if (this.isUrgent()) {
            out.flush();
        }
    }
}

