/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Event {
    public String name();

    public String label() default "";

    public String description() default "";

    public String[] category() default {""};

    public boolean stacktrace() default true;

    public Field[] fields();

    public static @interface Field {
        public FieldType type();

        public String name();

        public String label() default "";

        public String description() default "";

        public Kind kind() default @Kind(name=FieldKind.NONE);

        public static @interface Kind {
            public FieldKind name();

            public String value() default "";
        }
    }

    public static enum FieldKind {
        TIMESTAMP,
        TIMESPAN,
        DATAAMOUNT,
        FREQUENCY,
        MEMORYADDRESS,
        PERCENTAGE,
        BOOLEANFLAG,
        UNSIGNED,
        NONE;

    }

    public static enum FieldType {
        BYTE("byte"),
        CHAR("char"),
        SHORT("short"),
        INT("int"),
        LONG("long"),
        FLOAT("float"),
        DOUBLE("double"),
        BOOLEAN("boolean"),
        STRING("java.lang.String"),
        CLASS("java.lang.Class"),
        THREAD("java.lang.Thread");

        private final String type;

        private FieldType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

