/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import java.util.HashMap;
import java.util.Map;

public class PrefixMap {
    private final Node root = new Node();

    public void add(CharSequence val) {
        Node n = this.root;
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            Node child = n.getReferencedNode(ch);
            if (child == null) {
                child = new Node();
                n.addReferencedNode(ch, child);
            }
            n = child;
        }
        n.setValue(val);
    }

    public boolean contains(CharSequence val) {
        Node n = this.root;
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            Node child = n.getReferencedNode(ch);
            if (child == null) {
                return false;
            }
            if (child.value != null) {
                return true;
            }
            n = child;
        }
        return false;
    }

    private static final class Node {
        private final Map<Character, Node> refs = new HashMap<Character, Node>();
        private CharSequence value = null;

        public Node getReferencedNode(char ch) {
            return this.refs.get(Character.valueOf(ch));
        }

        public void addReferencedNode(char ch, Node n) {
            if (!this.refs.containsKey(Character.valueOf(ch))) {
                this.refs.put(Character.valueOf(ch), n);
            }
        }

        public void setValue(CharSequence val) {
            this.value = val;
        }
    }
}

